/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.FileMonitorListener;
import jp.sourceforge.concierge.plugin.FileMonitorPlugin;
import jp.sourceforge.concierge.plugin.registerer.Initializer;
import jp.sourceforge.concierge.plugin.registerer.preferences.RegistererPreferencePage;
import jp.sourceforge.concierge.plugin.registerer.preferences.internal.DirEntry;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class RegistererPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.registerer";
    private static RegistererPlugin plugin;
    private MessageConsole messageconsole;
    private MessageConsoleStream messagestream;
    private Initializer initializer = new Initializer();

    public RegistererPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.monitoringDirectory();
        this.messageconsole = new MessageConsole("", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.messageconsole});
        this.messagestream = this.messageconsole.newMessageStream();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RegistererPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return RegistererPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private Request createRequest(Document doc) {
        Request req = new Request();
        req.collection = "data";
        req.command = 1;
        req.data = doc;
        req.options = 0;
        return req;
    }

    public void monitoringDirectory() {
        if (this.initializer.getState() == 4) {
            return;
        }
        FileMonitorPlugin.getDefault().resetDirectoryManager();
        this.initializer.schedule();
        ArrayList<DirEntry> entry = RegistererPreferencePage.getMonitoringList();
        int i = 0;
        while (i < entry.size()) {
            DirEntry de = entry.get(i);
            if (de.monitor) {
                FileMonitorPlugin.getDefault().manageExternalDirectory(de.dirname, de.subdir, (FileMonitorListener)new DirListener());
            }
            ++i;
        }
    }

    public void unmonitoringDirectory() {
        FileMonitorPlugin.getDefault().resetDirectoryManager();
    }

    public void setConsoleMessage(String message) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IConsoleView cv = (IConsoleView)page.findView("org.eclipse.ui.console.ConsoleView");
        if (cv == null) {
            return;
        }
        this.messagestream.println(message);
        cv.display((IConsole)this.messageconsole);
    }

    private class DirListener
    extends FileMonitorListener {
        public void fileCreated(String p) {
            File f = new File(p);
            String file = f.getAbsolutePath();
            if (FilenameUtils.getName((String)file).startsWith(".")) {
                return;
            }
            if (f.isDirectory()) {
                return;
            }
            String dbdir = FrameworkPlugin.getLocalDatabaseDirectory();
            if (file.startsWith(dbdir)) {
                return;
            }
            ArrayList<DirEntry> de = RegistererPreferencePage.getMonitoringList();
            String ftype = RegistererPreferencePage.getType(de, FilenameUtils.getFullPathNoEndSeparator((String)file), file);
            if (ftype == null) {
                return;
            }
            if (FrameworkPlugin.isDocumentedByOriginalPath((String)file)) {
                return;
            }
            System.err.println(String.valueOf(file) + "=" + ftype);
            Document typedoc = TypeManager.getTypeDocument((String)ftype);
            Document ndoc = DataDomImpl.createDocument((Document)typedoc);
            DataDomImpl.setFilePath((Document)ndoc, (String)file);
            DataDomImpl.filloutFileInformation((Document)ndoc);
            ArrayList<Request> reqs = new ArrayList<Request>();
            Request req = RegistererPlugin.this.createRequest(ndoc);
            reqs.add(req);
            FrameworkPlugin.updateDocuments(reqs, (Object)RegistererPlugin.PLUGIN_ID);
        }

        public void fileDeleted(String p) {
        }

        public void fileChanged(String p) {
        }
    }
}

