/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.net.URL;
import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.IFileFilter;
import jp.sourceforge.concierge.plugin.dataextractor.Configure;
import jp.sourceforge.concierge.plugin.filters.ExcelFilter;
import jp.sourceforge.concierge.plugin.filters.PPTFilter;
import jp.sourceforge.concierge.plugin.filters.PdfFilter;
import jp.sourceforge.concierge.plugin.filters.WordFilter;
import jp.sourceforge.concierge.plugin.filters.XmlFilter;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DataExtractorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.dataextractor";
    private static DataExtractorPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Configure.initialize();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DataExtractorPlugin getDefault() {
        return plugin;
    }

    public static String getFilePath(String path) {
        try {
            URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(path), null);
            return FileLocator.toFileURL((URL)url).getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFileProperty(String filename, String elementname) {
        IFileFilter ff = DataExtractorPlugin.getFilter(filename);
        if (ff == null) {
            return "";
        }
        ArrayList<String> fstrs = Configure.mapTo(FilenameUtils.getExtension((String)filename), elementname);
        if (fstrs == null) {
            return "";
        }
        int i = 0;
        while (i < fstrs.size()) {
            String v = ff.getData(fstrs.get(i));
            if (v != null && v.length() > 0) {
                return v;
            }
            ++i;
        }
        return "";
    }

    public static IFileFilter getFilter(String path) {
        try {
            String ext = FilenameUtils.getExtension((String)path);
            if (ext.compareToIgnoreCase("pdf") == 0) {
                return new PdfFilter(path);
            }
            if (ext.compareToIgnoreCase("doc") == 0) {
                return new WordFilter(path);
            }
            if (ext.compareToIgnoreCase("xls") == 0) {
                return new ExcelFilter(path);
            }
            if (ext.compareToIgnoreCase("ppt") == 0) {
                return new PPTFilter(path);
            }
            if (ext.compareToIgnoreCase("xml") == 0) {
                return new XmlFilter(path);
            }
            if (ext.compareToIgnoreCase("xhtml") == 0) {
                return new XmlFilter(path);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DataExtractorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

