/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.plugin.FileMonitorListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FileMonitorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.filemanager";
    private static FileMonitorPlugin plugin;
    private Hashtable<String, DirMonitor> dirmonitors = new Hashtable();

    public FileMonitorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.resetDirectoryManager();
    }

    public void manageExternalDirectory(String path, boolean recursive, FileMonitorListener listener) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileObject pathobj = fsManager.resolveFile(path);
            DirMonitor dirmon = new DirMonitor(recursive, path);
            this.dirmonitors.put(path, dirmon);
            dirmon.listener.setListener(pathobj, listener);
            dirmon.monitor.addFile(pathobj);
            dirmon.monitor.setRecursive(recursive);
            dirmon.monitor.start();
            System.err.println("monitoring " + path + " recursive:" + String.valueOf(dirmon.monitor.isRecursive()));
        }
        catch (Exception exception) {}
    }

    public void unmanageExternalDirectory(String path) {
        DirMonitor dirmon = this.dirmonitors.get(path);
        if (dirmon == null) {
            return;
        }
        dirmon.monitor.stop();
        dirmon.listener.reset();
        this.dirmonitors.remove(path);
    }

    public void resetDirectoryManager() {
        Enumeration<DirMonitor> dirmons = this.dirmonitors.elements();
        while (dirmons.hasMoreElements()) {
            DirMonitor dm = dirmons.nextElement();
            dm.monitor.stop();
            dm.listener.reset();
        }
        this.dirmonitors.clear();
    }

    public static FileMonitorPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return FileMonitorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private class DirMonitor {
        public DefaultFileMonitor monitor;
        public ExternalDirListener listener;

        public DirMonitor(boolean recursive, String path) {
            this.listener = new ExternalDirListener(recursive, path);
            this.monitor = new DefaultFileMonitor((FileListener)this.listener);
        }
    }

    private class ExternalDirListener
    implements FileListener {
        private FileMonitorListener listener;
        private boolean recursive;
        private String dirpath;

        private boolean shouldNotify(URL url) {
            block5: {
                block4: {
                    try {
                        if (url.toExternalForm().contains(this.dirpath.replaceAll("\\\\", "/"))) break block4;
                        return false;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (!this.recursive) break block5;
                return true;
            }
            String p = FilenameUtils.getFullPath((String)url.toExternalForm());
            File dirf = new File(this.dirpath);
            return dirf.toURL().sameFile(new URL(p));
        }

        public ExternalDirListener(boolean rec, String path) {
            this.dirpath = path;
            this.recursive = rec;
        }

        public void fileChanged(FileChangeEvent ev) {
            try {
                URL url = ev.getFile().getURL();
                if (this.listener != null && this.shouldNotify(url)) {
                    this.listener.fileChanged(FileUtils.toFile((URL)url).getAbsolutePath());
                }
            }
            catch (Exception exception) {}
        }

        public void fileDeleted(FileChangeEvent ev) {
            try {
                URL url = ev.getFile().getURL();
                if (this.listener != null && this.shouldNotify(url)) {
                    this.listener.fileDeleted(FileUtils.toFile((URL)url).getAbsolutePath());
                }
            }
            catch (Exception exception) {}
        }

        public void fileCreated(FileChangeEvent ev) {
            try {
                URL url = ev.getFile().getURL();
                if (this.listener != null && this.shouldNotify(url)) {
                    this.listener.fileCreated(FileUtils.toFile((URL)url).getAbsolutePath());
                }
            }
            catch (Exception exception) {}
        }

        public void setListener(FileObject fo, FileMonitorListener listener) {
            this.listener = listener;
        }

        public void removeListener(FileObject fo) {
            this.listener = null;
        }

        public void reset() {
            this.listener = null;
        }
    }
}

