/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.ProjectBrowserPlugin;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectFileMap;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshDialog
extends Dialog {
    private static final String DEFAULTMSG = "Register the project files or relink them to the present items.";
    private static final String CONFLICTMSG = "Some files point to the same item.";
    private static final Image ERRORIMG = ProjectBrowserPlugin.getImageDescriptor("icons/error.gif").createImage();
    private static final Image ITEMED = ProjectBrowserPlugin.getImageDescriptor("icons/item.png").createImage();
    private static final Image NOITEMED = ProjectBrowserPlugin.getImageDescriptor("icons/noitem.png").createImage();
    private static final Image DELETEITEM = ProjectBrowserPlugin.getImageDescriptor("icons/deleteitem.png").createImage();
    private TableViewer tableviewer;
    private final Color COLORRED = new Color(null, 255, 0, 0);
    private CLabel toplabel = null;
    private ArrayList<String> prjdocuments = new ArrayList();
    private ArrayList<ProjectFileMap> filemaps = null;
    private ArrayList<ProjectFileMap> nofilemaps = null;
    private boolean deleteunlink = false;

    private void checkNoFileMapMapped() {
        int i = 0;
        while (i < this.nofilemaps.size()) {
            ProjectFileMap nofpfm = this.nofilemaps.get(i);
            nofpfm.projectfile = "No file item";
            int j = 0;
            while (j < this.filemaps.size()) {
                ProjectFileMap fpfm = this.filemaps.get(j);
                if (nofpfm.docfile.equals(fpfm.docfile)) {
                    nofpfm.projectfile = "Mapped to other file";
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public RefreshDialog(Shell parentShell) {
        super(new Shell(parentShell));
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        comp.setLayout((Layout)gl);
        Composite header = new Composite(comp, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GraphicUtil.setBackground((Control)header, (int)1);
        this.toplabel = new CLabel(header, 0);
        this.toplabel.setText(DEFAULTMSG);
        GraphicUtil.setBackground((Control)this.toplabel, (int)1);
        this.tableviewer = new TableViewer(comp, 65536);
        Table tbl = this.tableviewer.getTable();
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        GridData tblgd = new GridData(4, 4, true, true);
        tblgd.widthHint = 600;
        tblgd.heightHint = 480;
        tbl.setLayoutData((Object)tblgd);
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText("Files in the project");
        tc.setResizable(true);
        tc.setMoveable(false);
        tc.setWidth(280);
        tc = new TableColumn(tbl, 16384);
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(50);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Map to the item of");
        tc.setResizable(true);
        tc.setMoveable(false);
        tc.setWidth(280);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = new ComboBoxCellEditor((Composite)tbl, this.prjdocuments.toArray(new String[0]), 8);
        CellEditor[] ce = cellEditorArray;
        this.tableviewer.setColumnProperties(new String[]{"prjfile", "mark", "prjdoc"});
        this.tableviewer.setCellEditors(ce);
        this.tableviewer.setContentProvider((IContentProvider)new RefreshContentProvider());
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new RefreshLabelProvider());
        this.tableviewer.setCellModifier((ICellModifier)new RefreshModifier(this.tableviewer));
        ArrayList<ProjectFileMap> tvmaps = new ArrayList<ProjectFileMap>();
        if (this.filemaps != null) {
            tvmaps.addAll(this.filemaps);
        }
        if (this.nofilemaps != null) {
            tvmaps.addAll(this.nofilemaps);
        }
        this.tableviewer.setInput(tvmaps);
        Button cb = new Button(comp, 32);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 10;
        cb.setLayoutData((Object)gd);
        cb.setText("Delete no file items of this project.");
        cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                RefreshDialog.this.deleteunlink = b.getSelection();
                RefreshDialog.this.tableviewer.refresh();
            }
        });
        return parent;
    }

    private boolean isConflict() {
        int i = 0;
        while (i < this.filemaps.size()) {
            ProjectFileMap ipfm = this.filemaps.get(i);
            if (ipfm.hasDocument()) {
                int j = i;
                while (j < this.filemaps.size()) {
                    ProjectFileMap jpfm = this.filemaps.get(j);
                    if (jpfm.hasDocument() && i != j && ipfm.docfile.equals(jpfm.docfile)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean canHandleShellCloseEvent() {
        this.setReturnCode(1);
        return true;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.isConflict()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Conflict items", (String)CONFLICTMSG);
            return;
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    protected void initializeBounds() {
        this.getShell().setLocation(300, 100);
        this.getShell().setSize(this.getShell().computeSize(-1, -1));
    }

    public void setPrjDocuments(ArrayList<String> docs) {
        this.prjdocuments.clear();
        this.prjdocuments.add("Register");
        this.prjdocuments.add("No operation");
        this.prjdocuments.addAll(docs);
    }

    public void setFileMap(ArrayList<ProjectFileMap> maps) {
        this.filemaps = maps;
    }

    public void setNoFileMap(ArrayList<ProjectFileMap> maps) {
        this.nofilemaps = maps;
    }

    public ArrayList<ProjectFileMap> getFileMap() {
        return this.filemaps;
    }

    public ArrayList<ProjectFileMap> getNoFileMap() {
        return this.nofilemaps;
    }

    public boolean deleteUnlinkedItems() {
        return this.deleteunlink;
    }

    public boolean close() {
        this.COLORRED.dispose();
        return super.close();
    }

    private class RefreshContentProvider
    implements IStructuredContentProvider {
        private RefreshContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RefreshLabelProvider
    implements ITableLabelProvider {
        private RefreshLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                ProjectFileMap pfm = (ProjectFileMap)element;
                if (pfm.hasFile()) {
                    return NOITEMED;
                }
                if (pfm.isMappedToOther()) {
                    return ITEMED;
                }
                if (RefreshDialog.this.deleteunlink) {
                    return DELETEITEM;
                }
                return NOITEMED;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ProjectFileMap)element).projectfile;
            }
            if (columnIndex == 2) {
                return ((ProjectFileMap)element).docfile;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class RefreshModifier
    implements ICellModifier {
        private TableViewer viewer;

        public RefreshModifier(TableViewer tv) {
            this.viewer = tv;
        }

        public boolean canModify(Object element, String property) {
            if (!property.equals("prjdoc")) {
                return false;
            }
            ProjectFileMap pfm = (ProjectFileMap)element;
            return pfm.hasFile();
        }

        public Object getValue(Object element, String property) {
            ProjectFileMap pfm = (ProjectFileMap)element;
            if (property.equals("prjdoc")) {
                return new Integer(RefreshDialog.this.prjdocuments.indexOf(pfm.docfile));
            }
            if (property.equals("prjfile")) {
                return pfm.projectfile;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ProjectFileMap pfm = (ProjectFileMap)element;
            if (property.equals("prjdoc")) {
                Integer v = (Integer)value;
                if (v == -1) {
                    return;
                }
                pfm.docfile = (String)RefreshDialog.this.prjdocuments.get((Integer)value);
                pfm.modified = true;
                RefreshDialog.this.checkNoFileMapMapped();
            } else if (property.equals("prjfile")) {
                pfm.projectfile = (String)value;
                pfm.modified = true;
            }
            if (RefreshDialog.this.isConflict()) {
                RefreshDialog.this.toplabel.setText(RefreshDialog.CONFLICTMSG);
                RefreshDialog.this.toplabel.setImage(ERRORIMG);
                RefreshDialog.this.getButton(0).setEnabled(false);
            } else {
                RefreshDialog.this.toplabel.setText(RefreshDialog.DEFAULTMSG);
                RefreshDialog.this.toplabel.setImage(null);
                RefreshDialog.this.getButton(0).setEnabled(true);
            }
            this.viewer.refresh();
        }
    }
}

