/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.TabulatorPlugin;
import jp.sourceforge.concierge.plugin.tabulator.InternalTabulator;
import jp.sourceforge.concierge.plugin.tabulator.actions.DeleteItemAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.EditItemAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.ExpandAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.ExportFileAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.ExportItemAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.MailAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.OpenFileAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.ShowAllAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.ShowPathAction;
import jp.sourceforge.concierge.plugin.tabulator.actions.SyncAction;
import jp.sourceforge.concierge.plugin.tabulator.indexer.InternalIndexer;
import jp.sourceforge.concierge.util.CCGFileUtils;
import jp.sourceforge.concierge.widget.BrowserToolTip;
import jp.sourceforge.concierge.widget.CCGToolTip;
import jp.sourceforge.concierge.widget.ImageToolTip;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tabulator
extends ConciergeViewPart {
    private IMemento memento;
    private SashForm sashform;
    private InternalTabulator tabulator;
    private InternalIndexer indexer;
    private CCGToolTip tooltip;
    private Cursor normalCursor = new Cursor(null, 0);
    private Cursor fileCursor = new Cursor(null, 21);
    private int[] curratio;
    private boolean expanded;
    private String xpath;
    private ArrayList<Document> documents;
    Action editItemAction;
    Action openFileAction;
    Action deleteItemAction;
    Action exportFileAction;
    Action syncAction;
    Action showPathAction;
    Action selectAllTabulatorAction;
    Action dupTypeAction;
    Action addTypeAction;
    Action renameTypeAction;
    Action deleteTypeAction;
    Action exportItemAction;
    Action mailAction;
    Action expandAction;
    Action showAllAction;

    private void setActions() {
        this.deleteItemAction = new DeleteItemAction(this);
        this.deleteItemAction.setText(TabulatorPlugin.getString("Tabulator.88"));
        this.deleteItemAction.setToolTipText(TabulatorPlugin.getString("Tabulator.89"));
        this.deleteItemAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.exportFileAction = new ExportFileAction(this);
        this.exportFileAction.setText(TabulatorPlugin.getString("Tabulator.90"));
        this.exportFileAction.setToolTipText(TabulatorPlugin.getString("Tabulator.91"));
        this.syncAction = new SyncAction(this);
        this.syncAction.setText(TabulatorPlugin.getString("Tabulator.92"));
        this.syncAction.setToolTipText(TabulatorPlugin.getString("Tabulator.93"));
        this.syncAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/synchronize.gif"));
        this.showPathAction = new ShowPathAction(this);
        this.showPathAction.setText("Toggle filename/filepath");
        this.showPathAction.setToolTipText("Toggle filename/filepath");
        this.showPathAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/filepath.png"));
        this.openFileAction = new OpenFileAction(this);
        this.openFileAction.setText(TabulatorPlugin.getString("Tabulator.99"));
        this.openFileAction.setToolTipText(TabulatorPlugin.getString("Tabulator.100"));
        this.openFileAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/openfile.png"));
        this.editItemAction = new EditItemAction(this);
        this.editItemAction.setText(TabulatorPlugin.getString("Tabulator.102"));
        this.editItemAction.setToolTipText(TabulatorPlugin.getString("Tabulator.103"));
        this.editItemAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/editmetadata.png"));
        this.exportItemAction = new ExportItemAction(this);
        this.exportItemAction.setText(TabulatorPlugin.getString("Tabulator.105"));
        this.exportItemAction.setToolTipText(TabulatorPlugin.getString("Tabulator.106"));
        this.exportItemAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
        this.mailAction = new MailAction(this);
        this.mailAction.setText("Send email");
        this.mailAction.setToolTipText("Send email with selected items.");
        this.expandAction = new ExpandAction(this);
        this.expandAction.setText("Expand/Shrink indexer");
        this.expandAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/expand.png"));
        this.showAllAction = new ShowAllAction(this);
        this.showAllAction.setText("Show all documents in database");
        this.showAllAction.setImageDescriptor(TabulatorPlugin.getImageDescriptor("icons/home_nav.png"));
        this.selectAllTabulatorAction = new Action(){

            public void run() {
                TableViewer tableview = Tabulator.this.tabulator.getView();
                tableview.getTable().selectAll();
                tableview.getTable().notifyListeners(13, null);
            }
        };
        this.selectAllTabulatorAction.setText("Select All");
        this.selectAllTabulatorAction.setToolTipText("Select All");
    }

    private void disableActions() {
        this.editItemAction.setEnabled(false);
        this.openFileAction.setEnabled(false);
        this.deleteItemAction.setEnabled(false);
        this.exportItemAction.setEnabled(false);
        this.exportFileAction.setEnabled(false);
        this.mailAction.setEnabled(false);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Tabulator.this.fillContextMenu(manager);
            }
        });
        TableViewer tableview = this.tabulator.getView();
        Menu menu = menuMgr.createContextMenu((Control)tableview.getTable());
        tableview.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)tableview);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.editItemAction);
        manager.add((IAction)this.openFileAction);
        manager.add((IAction)this.deleteItemAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.syncAction);
        manager.add((IAction)this.showAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showPathAction);
        manager.add((IAction)this.expandAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.editItemAction);
        manager.add((IAction)this.openFileAction);
        manager.add((IAction)this.deleteItemAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportFileAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportItemAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mailAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showPathAction);
        manager.add((IAction)this.expandAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void dispose() {
        this.normalCursor.dispose();
        this.fileCursor.dispose();
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.tabulator.saveStatus(memento);
        this.indexer.saveState(memento);
        int[] w = this.sashform.getWeights();
        memento.putInteger("TabulatorSashRatioU", w[0]);
        memento.putInteger("TabulatorSashRatioD", w[1]);
        memento.putString("TabulatorTitle", this.getPartName());
        if (this.xpath != null) {
            memento.putString("TabulatorXPath", this.xpath);
        } else if (this.documents != null) {
            String ids = "";
            int i = 0;
            while (i < this.documents.size()) {
                if (i != 0) {
                    ids = String.valueOf(ids) + ",";
                }
                long id = DomImpl.getID((Document)this.documents.get(i));
                ids = String.valueOf(ids) + String.valueOf(id);
                ++i;
            }
            memento.putString("TabulatorIDs", ids);
        }
    }

    public void createPartControl(Composite parent) {
        int[] w;
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setBackground(new Color((Device)parent.getDisplay(), 250, 250, 255));
        this.sashform = new SashForm(parent, 512);
        this.sashform.setLayoutData((Object)new GridData(1808));
        this.sashform.setBackground(new Color((Device)parent.getDisplay(), 250, 250, 255));
        this.sashform.SASH_WIDTH = 2;
        this.indexer = new InternalIndexer((Composite)this.sashform, 0, this.memento);
        this.tabulator = new InternalTabulator((Composite)this.sashform, 0, this.memento);
        this.indexer.setTabulator(this.tabulator);
        try {
            int uratio = this.memento.getInteger("TabulatorSashRatioU");
            int dratio = this.memento.getInteger("TabulatorSashRatioD");
            this.sashform.setWeights(new int[]{uratio, dratio});
            String title = this.memento.getString("TabulatorTitle");
            if (title != null) {
                this.setPartName(title);
            }
        }
        catch (Exception exception) {
            int[] nArray = new int[2];
            nArray[1] = 100;
            this.sashform.setWeights(nArray);
        }
        this.expanded = (w = this.sashform.getWeights())[0] > 0;
        Action itemClickAction = new Action(){

            public void run() {
                TableViewer tableview = Tabulator.this.tabulator.getView();
                IStructuredSelection selection = (IStructuredSelection)tableview.getSelection();
                if (selection.size() == 0) {
                    Tabulator.this.disableActions();
                    return;
                }
                if (selection.size() == 1) {
                    Document doc = (Document)selection.getFirstElement();
                    String path = DataDomImpl.getFilePath((Document)doc);
                    if (path == null || path.length() == 0) {
                        Tabulator.this.openFileAction.setEnabled(false);
                        Tabulator.this.exportFileAction.setEnabled(false);
                    } else {
                        Tabulator.this.openFileAction.setEnabled(true);
                        Tabulator.this.exportFileAction.setEnabled(true);
                    }
                    ArrayList<Document> docs = new ArrayList<Document>();
                    docs.add(doc);
                    Tabulator.this.deleteItemAction.setEnabled(true);
                    Tabulator.this.editItemAction.setEnabled(true);
                    Tabulator.this.exportItemAction.setEnabled(true);
                    Tabulator.this.mailAction.setEnabled(true);
                }
                if (selection.size() > 1) {
                    Tabulator.this.openFileAction.setEnabled(false);
                    Tabulator.this.deleteItemAction.setEnabled(true);
                    Tabulator.this.editItemAction.setEnabled(true);
                    Tabulator.this.exportFileAction.setEnabled(false);
                    Tabulator.this.mailAction.setEnabled(true);
                }
            }
        };
        TableViewer tableview = this.tabulator.getView();
        tableview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                itemClickAction.run();
            }
        });
        tableview.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TableViewer tableview = Tabulator.this.tabulator.getView();
                if (Tabulator.this.tabulator.inFileColumn(e.x + tableview.getTable().getHorizontalBar().getSelection())) {
                    Tabulator.this.openFileAction.run();
                } else {
                    Tabulator.this.editItemAction.run();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        tableview.getTable().addMouseMoveListener(new MouseMoveListener(){
            private TableItem currentitem = null;

            public void mouseMove(MouseEvent e) {
                TableViewer tableview = Tabulator.this.tabulator.getView();
                if (Tabulator.this.tabulator.inFileColumn(e.x + tableview.getTable().getHorizontalBar().getSelection())) {
                    tableview.getTable().setCursor(Tabulator.this.fileCursor);
                    Tabulator.this.showMessageOnStatusLine(TabulatorPlugin.getString("Tabulator.111"));
                    TableItem ti = tableview.getTable().getItem(new Point(e.x, e.y));
                    if (ti == null) {
                        return;
                    }
                    if (this.currentitem != null && this.currentitem == ti) {
                        return;
                    }
                    this.currentitem = ti;
                    if (Tabulator.this.tooltip != null) {
                        Tabulator.this.tooltip.hide();
                        Tabulator.this.tooltip.dispose();
                        Tabulator.this.tooltip = null;
                    }
                    if (!(ti.getData() instanceof Document)) {
                        return;
                    }
                    Document doc = (Document)ti.getData();
                    String path = DataDomImpl.getFilePath((Document)doc);
                    if (CCGFileUtils.isHtml((String)path)) {
                        File f = new File(path);
                        if (!f.exists()) {
                            return;
                        }
                        BrowserToolTip btooltip = new BrowserToolTip(tableview.getControl(), 0, true);
                        btooltip.setDocument(doc);
                        Tabulator.this.tooltip = (CCGToolTip)btooltip;
                    } else {
                        Image img = FrameworkPlugin.getThumbnailImage((long)DomImpl.getID((Document)doc));
                        if (img == null) {
                            return;
                        }
                        ImageToolTip itooltip = new ImageToolTip(tableview.getControl(), 0, true);
                        itooltip.setImage(img);
                        Tabulator.this.tooltip = (CCGToolTip)itooltip;
                    }
                    Rectangle r = ti.getBounds();
                    Tabulator.this.tooltip.show(new Point(r.x + r.width / 2, r.y + r.height / 2));
                } else {
                    this.currentitem = null;
                    if (Tabulator.this.tooltip != null) {
                        Tabulator.this.tooltip.hide();
                        Tabulator.this.tooltip.dispose();
                        Tabulator.this.tooltip = null;
                    }
                    tableview.getTable().setCursor(Tabulator.this.normalCursor);
                    ArrayList docs = (ArrayList)tableview.getInput();
                    if (docs != null) {
                        Tabulator.this.showMessageOnStatusLine("Number of Documents: " + docs.size());
                    } else {
                        Tabulator.this.showMessageOnStatusLine("");
                    }
                }
            }
        });
        tableview.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    Tabulator.this.deleteItemAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tableview.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = Tabulator.this.getViewSite().getActionBars();
                bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)Tabulator.this.selectAllTabulatorAction);
                bars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                IActionBars bars = Tabulator.this.getViewSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        this.setActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.disableActions();
        try {
            ArrayList docs = null;
            this.xpath = this.memento.getString("TabulatorXPath");
            if (this.xpath == null) {
                String[] ids = this.memento.getString("TabulatorIDs").split(",");
                if (ids.length > 0) {
                    String xp = "/mdata[@id='" + Long.parseLong(ids[0]) + "'";
                    int i = 1;
                    while (i < ids.length) {
                        xp = String.valueOf(xp) + " or @" + "id" + "='" + Long.parseLong(ids[i]) + "'";
                        ++i;
                    }
                    xp = String.valueOf(xp) + "]";
                    this.documents = FrameworkPlugin.getDocumentsOfQuery((Request)new Request(4, (Object)xp, "data"));
                    if (this.documents != null) {
                        this.indexer.setDocuments(this.documents, false);
                    }
                }
            } else {
                docs = FrameworkPlugin.getDocumentsOfQuery((Request)new Request(4, (Object)this.xpath, "data"));
                if (docs != null) {
                    this.indexer.setDocuments(docs, false);
                }
            }
        }
        catch (Exception exception) {}
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "TITLE") {
                    Tabulator.this.setPartName((String)event.getNewValue());
                }
            }
        });
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread((Control)this.tabulator, new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (!ev.collection.equals("data")) {
                    return;
                }
                switch (ev.type) {
                    case DEL_DOCUMENT: {
                        Tabulator.this.deleteDocuments(ev.documents);
                        break;
                    }
                    case ADD_DOCUMENT: {
                        Tabulator.this.refresh();
                        break;
                    }
                    case UPD_DOCUMENT: {
                        Tabulator.this.updateDocuments(ev.documents);
                    }
                }
            }
        }));
    }

    public void setDocuments(ArrayList<Document> docs) {
        this.documents = docs;
        this.indexer.setDocuments(docs, false);
        this.xpath = null;
    }

    public void setDocuments(String xp) {
        Request r = new Request(4, (Object)xp, "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
        if (docs == null) {
            return;
        }
        this.documents = null;
        this.indexer.setDocuments(docs, false);
        this.xpath = xp;
    }

    private void deleteDocuments(ArrayList<Document> ddocs) {
        if (this.documents != null) {
            ArrayList<Document> newdocuments = new ArrayList<Document>();
            int i = 0;
            while (i < this.documents.size()) {
                Document doc = this.documents.get(i);
                Document ndoc = DomImpl.findDocument(ddocs, (Document)doc);
                if (ndoc == null) {
                    newdocuments.add(doc);
                }
                ++i;
            }
            this.documents = newdocuments;
        }
        this.refresh();
    }

    private void updateDocuments(ArrayList<Document> ndocs) {
        if (this.documents != null) {
            int i = 0;
            while (i < this.documents.size()) {
                Document doc = this.documents.get(i);
                Document ndoc = DomImpl.findDocument(ndocs, (Document)doc);
                if (ndoc != null) {
                    this.documents.set(i, ndoc);
                }
                ++i;
            }
        }
        this.refresh();
    }

    public void refresh() {
        if (this.xpath != null) {
            Request r = new Request(4, (Object)this.xpath, "data");
            ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
            if (docs == null) {
                return;
            }
            this.indexer.setDocuments(docs, true);
        } else if (this.documents != null) {
            this.indexer.setDocuments(this.documents, true);
        }
    }

    public InternalIndexer getIndexer() {
        return this.indexer;
    }

    public InternalTabulator getTabulator() {
        return this.tabulator;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void ExpandIndexer(boolean b) {
        if (b) {
            if (this.curratio != null) {
                this.sashform.setWeights(this.curratio);
            } else {
                this.sashform.setWeights(new int[]{30, 70});
            }
        } else {
            this.curratio = this.sashform.getWeights();
            int[] nArray = new int[2];
            nArray[1] = 100;
            this.sashform.setWeights(nArray);
        }
        this.expanded = b;
    }

    public void setMessageOnStatusLine(String msg) {
        super.showMessageOnStatusLine(msg);
    }

    public void setFocus() {
        this.indexer.setFocus();
    }

    public void Update(ArrayList<Request> requests, Object sender) {
    }
}

