/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public final class Font
extends Resource {
    public int handle;
    public short style;
    public float size;
    public int atsuiStyle;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.atsName);
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        FontData fd = fds[0];
        this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.atsName);
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        this.init(name, height, style, null);
        this.init();
    }

    Font(Device device, String name, float height, int style) {
        super(device);
        this.init(name, height, style, null);
        this.init();
    }

    int createStyle() {
        int[] values;
        int[] sizes;
        int[] tags;
        int[] buffer = new int[1];
        OS.ATSUCreateStyle(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        int atsuStyle = buffer[0];
        boolean synthesize = this.style != 0;
        int ptr = OS.NewPtr(8 + (synthesize ? 8 : 0));
        OS.memmove(ptr, new int[]{OS.FMGetFontFromATSFontRef(this.handle)}, 4);
        OS.memmove(ptr + 4, new int[]{OS.X2Fix(this.size)}, 4);
        if (synthesize) {
            OS.memmove(ptr + 8, new byte[]{(this.style & 1) != 0 ? (byte)1 : 0}, 1);
            OS.memmove(ptr + 9, new byte[]{(this.style & 2) != 0 ? (byte)1 : 0}, 1);
            tags = new int[]{261, 262, 256, 257};
            sizes = new int[]{4, 4, 1, 1};
            values = new int[]{ptr, ptr + 4, ptr + 8, ptr + 9};
        } else {
            tags = new int[]{261, 262};
            sizes = new int[]{4, 4};
            values = new int[]{ptr, ptr + 4};
        }
        OS.ATSUSetAttributes(atsuStyle, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr);
        short[] types = new short[]{1, 1, 1, 1, 1, 1, 1, 1};
        short[] selectors = new short[]{1, 3, 5, 7, 9, 11, 13, 15, 17};
        OS.ATSUSetFontFeatures(atsuStyle, types.length, types, selectors);
        return atsuStyle;
    }

    void destroy() {
        if (this.handle == 0) {
            return;
        }
        this.handle = 0;
        if (this.atsuiStyle != 0) {
            OS.ATSUDisposeStyle(this.atsuiStyle);
        }
        this.atsuiStyle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle && this.size == font.size;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] buffer = new int[1];
        OS.ATSFontGetName(this.handle, 0, buffer);
        CFRange range = new CFRange();
        range.length = OS.CFStringGetLength(buffer[0]);
        char[] chars = new char[range.length];
        OS.CFStringGetCharacters(buffer[0], range, chars);
        OS.CFRelease(buffer[0]);
        String atsName = new String(chars);
        int platformCode = 0;
        int encoding = 256;
        if (OS.ATSUFindFontName(this.handle, 1, platformCode, -1, -1, 0, null, buffer, null) != 0) {
            platformCode = -1;
            encoding = 0;
            OS.ATSUFindFontName(this.handle, 1, platformCode, -1, -1, 0, null, buffer, null);
        }
        byte[] bytes = new byte[buffer[0]];
        OS.ATSUFindFontName(this.handle, 1, platformCode, -1, -1, bytes.length, bytes, buffer, null);
        String name = "";
        int ptr = OS.CFStringCreateWithBytes(0, bytes, bytes.length, encoding, false);
        if (ptr != 0) {
            range.length = OS.CFStringGetLength(ptr);
            if (range.length != 0) {
                chars = new char[range.length];
                OS.CFStringGetCharacters(ptr, range, chars);
                name = new String(chars);
            }
            OS.CFRelease(ptr);
        }
        int style = 0;
        if ((this.style & 2) != 0) {
            style |= 2;
        }
        if ((this.style & 1) != 0) {
            style |= 1;
        }
        if (atsName.indexOf("Italic") != -1) {
            style |= 2;
        }
        if (atsName.indexOf("Bold") != -1) {
            style |= 1;
        }
        FontData data = new FontData(name, this.size, style);
        data.atsName = atsName;
        return new FontData[]{data};
    }

    public static Font carbon_new(Device device, int handle, short style, float size) {
        Font font = new Font(device);
        font.handle = handle;
        font.style = style;
        font.size = size;
        return font;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(String name, float height, int style, String atsName) {
        int ptr;
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0.0f) {
            SWT.error(5);
        }
        int font = 0;
        if (atsName != null) {
            ptr = this.createCFString(atsName);
            if (ptr != 0) {
                font = OS.ATSFontFindFromName(ptr, 0);
                OS.CFRelease(ptr);
            }
        } else {
            atsName = name;
            if ((style & 1) != 0) {
                atsName = String.valueOf(atsName) + " Bold";
            }
            if ((style & 2) != 0) {
                atsName = String.valueOf(atsName) + " Italic";
            }
            if ((ptr = this.createCFString(atsName)) != 0) {
                font = OS.ATSFontFindFromName(ptr, 0);
                OS.CFRelease(ptr);
            }
            if (font == 0 && (style & 2) != 0) {
                this.style = (short)(this.style | 2);
                atsName = name;
                if ((style & 1) != 0) {
                    atsName = String.valueOf(atsName) + " Bold";
                }
                if ((ptr = this.createCFString(atsName)) != 0) {
                    font = OS.ATSFontFindFromName(ptr, 0);
                    OS.CFRelease(ptr);
                }
            }
            if (font == 0 && (style & 1) != 0) {
                this.style = (short)(this.style | 1);
                atsName = name;
                ptr = this.createCFString(atsName);
                if (ptr != 0) {
                    font = OS.ATSFontFindFromName(ptr, 0);
                    OS.CFRelease(ptr);
                }
            }
        }
        this.size = height;
        if (font == 0) {
            Font systemFont = this.device.systemFont;
            this.handle = systemFont.handle;
        } else {
            this.handle = font;
        }
        this.atsuiStyle = this.createStyle();
    }

    int createCFString(String str) {
        char[] chars = new char[str.length()];
        str.getChars(0, chars.length, chars, 0);
        return OS.CFStringCreateWithCharacters(0, chars, chars.length);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

