/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int currentEffect = 0;
    TreeItem insertItem = null;
    boolean insertBefore = false;
    TreeItem scrollItem;
    long scrollBeginTime;
    TreeItem expandItem;
    long expandBeginTime;
    DataBrowserCallbacks callbacks = null;
    static Callback AcceptDragProc;
    static /* synthetic */ Class class$0;

    static {
        int acceptDragProc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TreeDropTargetEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acceptDragProc = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    int acceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        return (this.currentEffect & 1) != 0 ? 1 : 0;
    }

    static int AcceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        DropTarget target = TreeDropTargetEffect.FindDropTarget(theControl, theDrag);
        if (target == null) {
            return 0;
        }
        return (target.feedback & 1) != 0 ? 1 : 0;
    }

    static DropTarget FindDropTarget(int theControl, int theDrag) {
        if (theControl == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(theControl);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.callbacks == null) {
            Tree table = (Tree)this.control;
            DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(table.handle, callbacks);
            callbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
            OS.SetDataBrowserCallbacks(table.handle, callbacks);
        }
        this.insertItem = null;
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent event) {
        Tree tree = (Tree)this.control;
        if (this.insertItem != null) {
            this.setInsertMark(tree, null, false);
            this.insertItem = null;
        }
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        Tree tree = (Tree)this.control;
        TreeItem item = (TreeItem)this.getItem(tree, event.x, event.y);
        int effect = this.checkEffect(event.feedback);
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (item != null && item.equals(this.expandItem) && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (item.getItemCount() > 0 && !item.getExpanded()) {
                    Event e = new Event();
                    e.x = event.x;
                    e.y = event.y;
                    e.item = item;
                    e.time = (int)System.currentTimeMillis();
                    tree.notifyListeners(17, e);
                    if (item.isDisposed()) {
                        return;
                    }
                    item.setExpanded(true);
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandItem = item;
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                Rectangle area = tree.getClientArea();
                int headerHeight = tree.getHeaderHeight();
                int itemHeight = tree.getItemHeight();
                Point pt = new Point(event.x, event.y);
                pt = tree.getDisplay().map(null, (Control)tree, pt);
                TreeItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    nextItem = this.previousItem(tree, item);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    nextItem = this.nextItem(tree, item);
                }
                if (nextItem != null) {
                    tree.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        if ((effect & 4) != 0 || (effect & 2) != 0) {
            if (this.insertItem != item || (effect & 4) != (this.currentEffect & 4) || (effect & 2) != (this.currentEffect & 2)) {
                this.setInsertMark(tree, item, (effect & 2) != 0);
                this.currentEffect = effect;
                this.insertItem = item;
            }
        } else {
            this.setInsertMark(tree, null, false);
        }
        ((DropTarget)event.widget).feedback = effect;
    }

    void setInsertMark(Tree tree, TreeItem item, boolean before) {
        if (item == this.insertItem && before == this.insertBefore) {
            return;
        }
        this.insertItem = item;
        this.insertBefore = before;
        tree.setInsertMark(item, before);
    }
}

