/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import java.util.ArrayList;
import jp.sourceforge.concierge.contentassist.Word;
import jp.sourceforge.concierge.contentassist.WordList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SmartText
extends Composite {
    private static final String STITLE_REGWORD = "_____r";
    private static final String STITLE_FREQWORD = "_____f";
    private static final String STITLE_RECENTWORD = "_____s";
    private static Image image = FrameworkPlugin.getImageDescriptor("icons/blueball.png").createImage();
    private Text textctrl;
    private Action regAction;
    private KeywordTextAdapter ktadapter;

    private boolean isReservedValue(String v) {
        return v.equals(STITLE_REGWORD) || v.equals(STITLE_FREQWORD) || v.equals(STITLE_RECENTWORD);
    }

    private String getReservedValueTitle(String v) {
        if (v.equals(STITLE_REGWORD)) {
            return "Registered words";
        }
        if (v.equals(STITLE_FREQWORD)) {
            return "Frequent words";
        }
        if (v.equals(STITLE_RECENTWORD)) {
            return "Recent words";
        }
        return null;
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.regAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SmartText.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.textctrl);
        this.textctrl.setMenu(menu);
    }

    private String getSelectedText(Text textctrl) {
        int location = textctrl.getCaretPosition();
        String text = textctrl.getText();
        int start = 0;
        int end = text.length() - 1;
        int i = location - 1;
        while (i >= 0) {
            if (text.charAt(i) == ',') {
                start = i + 1;
                break;
            }
            --i;
        }
        i = location;
        while (i < text.length()) {
            if (text.charAt(i) == ',') {
                end = i - 1;
                break;
            }
            ++i;
        }
        return text.substring(start, end + 1);
    }

    private void replaceText(Text textctrl, String oldstr, String newstr) {
        int location = textctrl.getCaretPosition();
        String text = textctrl.getText();
        int start = 0;
        int end = text.length() - 1;
        int i = location - 1;
        while (i >= 0) {
            if (text.charAt(i) == ',') {
                start = i + 1;
                break;
            }
            --i;
        }
        i = location;
        while (i < text.length()) {
            if (text.charAt(i) == ',') {
                end = i - 1;
                break;
            }
            ++i;
        }
        String pstr = start > 0 ? text.substring(0, start) : "";
        String tstr = text.substring(start, end + 1).replace(oldstr, newstr);
        String nstr = end > text.length() - 1 ? "" : text.substring(end, text.length() - 1);
        textctrl.setText(String.valueOf(pstr) + tstr + nstr);
    }

    public SmartText(Composite parent, int style) {
        super(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        this.textctrl = new Text((Composite)this, style);
        this.textctrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textctrl.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String t = SmartText.this.textctrl.getText();
                String[] words = t.split(",");
                WordList.addWords(words);
            }
        });
        this.ktadapter = new KeywordTextAdapter(this.textctrl);
        this.ktadapter.adapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
            }

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
            }
        });
        this.ktadapter.adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                String t = SmartText.this.textctrl.getText();
                String[] words = t.split(",");
                WordList.addWords(words);
            }
        });
        this.regAction = new Action(){

            public void run() {
                String text = SmartText.this.getSelectedText(SmartText.this.textctrl);
                if (text == null) {
                    return;
                }
                if ((text = text.trim()).length() == 0) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)SmartText.this.textctrl.getShell(), (String)"Register word", (String)("Registering word '" + text + "', OK?"))) {
                    return;
                }
                WordList.addWordAsRegistered(text);
            }
        };
        this.regAction.setText("Register as keyword");
        this.hookContextMenu();
    }

    public void addModifyListener(ModifyListener listener) {
        this.textctrl.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textctrl.removeModifyListener(listener);
    }

    public void setText(String text) {
        this.ktadapter.adapter.setEnabled(false);
        this.textctrl.setText(text);
        this.ktadapter.adapter.setEnabled(true);
    }

    public String getText() {
        return this.textctrl.getText();
    }

    public void save() {
        String t = this.textctrl.getText();
        String[] words = t.split(",");
        WordList.save(words);
    }

    private class KeywordProposal
    implements IContentProposal {
        private String value;

        public KeywordProposal(String v) {
            this.value = v;
        }

        public String getContent() {
            if (SmartText.this.isReservedValue(this.value)) {
                return null;
            }
            return this.value;
        }

        public int getCursorPosition() {
            if (SmartText.this.isReservedValue(this.value)) {
                return 0;
            }
            return this.value.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return null;
        }
    }

    private class KeywordTextAdapter {
        private ContentProposalAdapter adapter;

        protected void finalize() throws Throwable {
            this.adapter.getLabelProvider().dispose();
            super.finalize();
        }

        public KeywordTextAdapter(Text text) {
            SmartTextContentAdapter contentAdapter = new SmartTextContentAdapter();
            IContentProposalProvider provider = new IContentProposalProvider(){

                public IContentProposal[] getProposals(String content, int position) {
                    int i;
                    String keyword = SmartText.this.getSelectedText((Text)KeywordTextAdapter.this.adapter.getControl());
                    ArrayList<Word> rwords = null;
                    ArrayList<Word> nrwords = null;
                    ArrayList<KeywordProposal> kps = new ArrayList<KeywordProposal>();
                    if (keyword.length() == 0) {
                        return kps.toArray(new KeywordProposal[0]);
                    }
                    if ((keyword = keyword.trim()).length() == 0) {
                        rwords = WordList.getAllWords(true);
                        nrwords = WordList.getAllWords(false);
                    } else {
                        rwords = WordList.getWordsStartWith(keyword, true);
                        nrwords = WordList.getWordsStartWith(keyword, false);
                    }
                    if (rwords.size() > 0) {
                        kps.add(new KeywordProposal(SmartText.STITLE_REGWORD));
                        i = 0;
                        while (i < rwords.size()) {
                            kps.add(new KeywordProposal(rwords.get(i).getWord()));
                            ++i;
                        }
                    }
                    if (nrwords.size() > 0) {
                        kps.add(new KeywordProposal(SmartText.STITLE_FREQWORD));
                        i = 0;
                        while (i < nrwords.size()) {
                            kps.add(new KeywordProposal(nrwords.get(i).getWord()));
                            ++i;
                        }
                    }
                    return kps.toArray(new KeywordProposal[0]);
                }
            };
            this.adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)contentAdapter, provider, null, null);
            this.adapter.setLabelProvider(new ILabelProvider(){

                public Image getImage(Object element) {
                    if (SmartText.this.isReservedValue(((KeywordProposal)element).value)) {
                        return image;
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (SmartText.this.isReservedValue(((KeywordProposal)element).value)) {
                        return SmartText.this.getReservedValueTitle(((KeywordProposal)element).value);
                    }
                    return "      " + ((KeywordProposal)element).value;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
        }
    }

    private class SmartTextContentAdapter
    extends TextContentAdapter {
        private SmartTextContentAdapter() {
        }

        public Rectangle getInsertionBounds(Control control) {
            Rectangle r = super.getInsertionBounds(control);
            Text t = (Text)control;
            r.y = t.getLineHeight() + t.getBorderWidth();
            return r;
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            super.setControlContents(control, text, cursorPosition);
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
            String curtext = SmartText.this.getSelectedText((Text)control).trim();
            if (curtext.length() > 0 && text.startsWith(curtext)) {
                SmartText.this.replaceText((Text)control, curtext, text);
            } else {
                super.insertControlContents(control, text, cursorPosition);
            }
        }
    }
}

