/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ZipFileUtil {
    public static String separator = "/";

    public static boolean createZipFile(File srcFile, File dstFile, IProgressMonitor monitor) {
        boolean success;
        block23: {
            success = false;
            if (!srcFile.exists()) {
                return success;
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                try {
                    fos = new FileOutputStream(dstFile);
                    zos = new ZipOutputStream(fos);
                    ZipFileUtil.PutFileInZipOutputStream(zos, srcFile, "", monitor, true);
                    zos.finish();
                    success = true;
                }
                catch (Exception exception) {
                    if (zos != null) {
                        try {
                            zos.close();
                        }
                        catch (Exception exception2) {}
                        zos = null;
                    }
                    if (fos == null) break block23;
                    try {
                        fos.close();
                    }
                    catch (Exception exception3) {}
                    fos = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (Exception exception) {}
                    zos = null;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                    fos = null;
                }
                throw throwable;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
                zos = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
        return success;
    }

    public static void PutFileInZipOutputStream(ZipOutputStream zos, File srcFile, String entryPath, IProgressMonitor monitor, boolean useProgress) throws IOException, InterruptedException {
        block25: {
            block24: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Cancel has been requested.");
                }
                if (!srcFile.isFile()) break block24;
                if (monitor != null) {
                    monitor.subTask(srcFile.getAbsolutePath());
                }
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                try {
                    fis = new FileInputStream(srcFile);
                    bis = new BufferedInputStream(fis);
                    ZipEntry ze = ZipFileUtil.createTempZipEntry(String.valueOf(entryPath) + srcFile.getName(), bis, srcFile.lastModified(), monitor);
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {}
                        bis = null;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                        fis = null;
                    }
                    fis = new FileInputStream(srcFile);
                    bis = new BufferedInputStream(fis);
                    ZipFileUtil.writeZipOutputStream(zos, ze, bis, monitor);
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {}
                        bis = null;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                        fis = null;
                    }
                    throw throwable;
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                    bis = null;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                    fis = null;
                }
                if (monitor == null) break block25;
                if (monitor.isCanceled()) {
                    throw new InterruptedException("Cancel has been requested.");
                }
                if (!useProgress) break block25;
                monitor.worked(1);
                break block25;
            }
            ZipEntry zed = new ZipEntry(String.valueOf(entryPath) + srcFile.getName() + separator);
            zed.setTime(srcFile.lastModified());
            zos.putNextEntry(zed);
            zos.closeEntry();
            File[] files = srcFile.listFiles();
            int i = 0;
            while (i < files.length) {
                ZipFileUtil.PutFileInZipOutputStream(zos, files[i], String.valueOf(entryPath) + srcFile.getName() + separator, monitor, useProgress);
                ++i;
            }
        }
    }

    public static void writeZipOutputStream(ZipOutputStream zos, String entryName, InputStream is, long time, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            int count;
            ZipEntry ze = new ZipEntry(entryName);
            if (time != 0L) {
                ze.setTime(time);
            }
            zos.putNextEntry(ze);
            byte[] buf = new byte[8092];
            while ((count = is.read(buf, 0, 8092)) != -1) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Cancel has been requested.");
                }
                zos.write(buf, 0, count);
            }
            buf = null;
        }
        finally {
            zos.closeEntry();
        }
    }

    public static void writeZipOutputStream(ZipOutputStream zos, ZipEntry ze, InputStream is, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            int count;
            zos.putNextEntry(ze);
            byte[] buf = new byte[8092];
            while ((count = is.read(buf, 0, 8092)) != -1) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Cancel has been requested.");
                }
                zos.write(buf, 0, count);
            }
            buf = null;
        }
        finally {
            zos.closeEntry();
        }
    }

    public static ZipEntry createTempZipEntry(String entryName, InputStream is, long time, IProgressMonitor monitor) throws IOException, InterruptedException {
        ByteArrayOutputStream tos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(tos);
        ZipEntry ze = new ZipEntry(entryName);
        try {
            if (time != 0L) {
                ze.setTime(time);
            }
            zos.putNextEntry(ze);
            if (is != null) {
                int count;
                byte[] buf = new byte[8092];
                while ((count = is.read(buf, 0, 8092)) != -1) {
                    if (monitor != null && monitor.isCanceled()) {
                        throw new InterruptedException("Cancel has been requested.");
                    }
                    zos.write(buf, 0, count);
                }
                buf = null;
            }
        }
        catch (Throwable throwable) {
            zos.closeEntry();
            zos.finish();
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (Exception exception) {}
                tos = null;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
                zos = null;
            }
            throw throwable;
        }
        zos.closeEntry();
        zos.finish();
        if (tos != null) {
            try {
                tos.close();
            }
            catch (Exception exception) {}
            tos = null;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Exception exception) {}
            zos = null;
        }
        return ze;
    }

    public static void ByteArrayOutputStreamToZipFile(ByteArrayOutputStream baos, String entryName, File outFile) {
        block31: {
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            ByteArrayInputStream bais = null;
            try {
                try {
                    fos = new FileOutputStream(outFile);
                    zos = new ZipOutputStream(fos);
                    byte[] buf = baos.toByteArray();
                    bais = new ByteArrayInputStream(buf);
                    ZipFileUtil.writeZipOutputStream(zos, entryName, bais, 0L, null);
                    zos.finish();
                }
                catch (Exception exception) {
                    if (bais != null) {
                        try {
                            bais.close();
                        }
                        catch (Exception exception2) {}
                        bais = null;
                    }
                    if (zos != null) {
                        try {
                            zos.close();
                        }
                        catch (Exception exception3) {}
                        zos = null;
                    }
                    if (fos == null) break block31;
                    try {
                        fos.close();
                    }
                    catch (Exception exception4) {}
                    fos = null;
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {}
                    bais = null;
                }
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (Exception exception) {}
                    zos = null;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                    fos = null;
                }
                throw throwable;
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
                bais = null;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
                zos = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
    }

    public static void UnZipToLog(String filename) {
        try {
            ZipFile zipFile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                ZipEntry e = all.nextElement();
                if (e.isDirectory()) {
                    System.out.println("Directory = " + e.getName());
                    continue;
                }
                System.out.println("File = " + e.getName());
            }
        }
        catch (Exception exception) {}
    }

    public static void UnZip(String srcPath, String parentPath) {
        try {
            ZipFile zipFile = new ZipFile(srcPath);
            File parentFile = null;
            if (parentPath != null) {
                parentFile = new File(parentPath);
                if (!parentFile.exists()) {
                    parentFile = null;
                } else if (!parentFile.isDirectory()) {
                    parentFile = null;
                }
            }
            if (parentFile == null) {
                File srcFile = new File(srcPath);
                parentFile = srcFile.getParentFile();
            }
            File rootFile = ZipFileUtil.newFileWithNotExist(parentFile, FilenameUtils.getBaseName((String)zipFile.getName()));
            rootFile.mkdir();
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                File dstFile;
                ZipEntry e = all.nextElement();
                if (e.isDirectory()) {
                    System.out.println("Directory = " + e.getName());
                    dstFile = new File(rootFile, e.getName());
                    dstFile.mkdir();
                    dstFile.setLastModified(e.getTime());
                    continue;
                }
                System.out.println("File = " + e.getName());
                try {
                    dstFile = new File(rootFile, e.getName());
                    FileOutputStream os = new FileOutputStream(dstFile);
                    InputStream is = zipFile.getInputStream(e);
                    int n = 0;
                    byte[] b = new byte[8092];
                    while ((n = is.read(b)) > 0) {
                        os.write(b, 0, n);
                    }
                    is.close();
                    os.close();
                    dstFile.setLastModified(e.getTime());
                }
                catch (Exception exce) {
                    System.err.println(exce.getMessage());
                }
            }
        }
        catch (Exception exception) {}
    }

    public static File newFileWithNotExist(File parentFile, String filename) {
        int i = 2;
        File dstFile = new File(parentFile, filename);
        if (filename.endsWith("/")) {
            filename = FilenameUtils.getPathNoEndSeparator((String)filename);
        }
        while (dstFile.exists()) {
            dstFile = new File(parentFile, String.valueOf(filename) + " " + i);
        }
        return dstFile;
    }

    public static String SaveDialog(Shell shell, String filename, String dialogTitle) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{FrameworkPlugin.getString("ZipFileUtil.10"), FrameworkPlugin.getString("ZipFileUtil.11")});
        dialog.setFilterExtensions(new String[]{"*.zip", "."});
        if (filename == null) {
            filename = "";
        }
        if (filename.length() == 0) {
            Date dNow = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            filename = dateFormat.format(dNow);
        }
        dialog.setFileName(String.valueOf(filename) + ".zip");
        if (dialogTitle == null) {
            dialogTitle = FrameworkPlugin.getString("ZipFileUtil.17");
        }
        dialog.setText(dialogTitle);
        String resultPath = dialog.open();
        return resultPath;
    }

    public static String OpenDialog(Shell shell, String dialogTitle) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{".zip"});
        if (dialogTitle == null) {
            dialogTitle = FrameworkPlugin.getString("ZipFileUtil.19");
        }
        dialog.setText(dialogTitle);
        String resultPath = dialog.open();
        if (resultPath != null && !resultPath.endsWith(".zip")) {
            resultPath = null;
        }
        return resultPath;
    }

    public static int filesTotal(File srcFile) {
        int count = 0;
        if (srcFile.exists()) {
            if (srcFile.isFile()) {
                count = 1;
            } else if (srcFile.isDirectory()) {
                File[] files = srcFile.listFiles();
                int i = 0;
                while (i < files.length) {
                    count += ZipFileUtil.filesTotal(files[i]);
                    ++i;
                }
            }
        }
        return count;
    }
}

