/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.util.ZipFileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;

public class BackUpAction
extends Action {
    private IWorkbenchWindow workbenchWindow;

    public BackUpAction(IWorkbenchWindow workbenchWindow) {
        this.setText(FrameworkPlugin.getString("BackUpAction.0"));
        this.workbenchWindow = workbenchWindow;
    }

    public void run() {
        try {
            String dstPath = ZipFileUtil.SaveDialog(this.workbenchWindow.getShell(), null, FrameworkPlugin.getString("BackUpAction.1"));
            if (dstPath == null) {
                return;
            }
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.workbenchWindow.getShell());
            String srcPath = FrameworkPlugin.getLocalDatabaseDirectory();
            BackupWithProgress runnable = new BackupWithProgress(srcPath, dstPath);
            pmd.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {}
    }

    private class BackupWithProgress
    implements IRunnableWithProgress {
        private String srcPath = null;
        private String dstPath = null;

        public BackupWithProgress(String srcPath, String dstPath) {
            this.srcPath = srcPath;
            this.dstPath = dstPath;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int total = ZipFileUtil.filesTotal(new File(this.srcPath));
            monitor.beginTask(FrameworkPlugin.getString("BackUpAction.2"), total);
            File srcFile = new File(this.srcPath);
            File dstFile = new File(this.dstPath);
            boolean success = ZipFileUtil.createZipFile(srcFile, dstFile, monitor);
            if (!success && dstFile.exists()) {
                dstFile.delete();
            }
            monitor.done();
        }
    }
}

