/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.mdocument;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager {
    private static Hashtable<String, ArrayList<Document>> typedocs;

    private static Document getTypeDocument(ArrayList<Document> docs, String type) {
        int i = 0;
        while (i < docs.size()) {
            Document doc = docs.get(i);
            if (TypeDomImpl.getTypeName(doc).equals(type)) {
                return doc;
            }
            ++i;
        }
        return null;
    }

    public static void initializeTypeXML() {
        typedocs = new Hashtable();
        Request req = new Request();
        req.collection = "type";
        req.command = 4;
        req.options = 0;
        req.data = "/type";
        ArrayList<Document> tdocs = FrameworkPlugin.getDocumentsOfQuery(req);
        int i = 0;
        while (i < tdocs.size()) {
            Document tdoc = tdocs.get(i);
            String pid = TypeDomImpl.getPluginID(tdoc);
            ArrayList<Document> tarray = typedocs.get(pid);
            if (tarray == null) {
                tarray = new ArrayList();
                typedocs.put(pid, tarray);
            }
            tarray.add(tdoc);
            ++i;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("jp.sourceforge.concierge.framework.typeXML");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i2 = 0;
            while (i2 < extensions.length) {
                IConfigurationElement[] elements = extensions[i2].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    block14: {
                        if (elements[j].getName().equals("typeXML")) {
                            try {
                                String xmlPath = elements[j].getAttribute("xml");
                                if (xmlPath == null) break block14;
                                URL xmlUrl = Platform.getBundle((String)elements[j].getContributor().getName()).getEntry(xmlPath);
                                Document ntdoc = DomImpl.loadDocument(FileLocator.toFileURL((URL)xmlUrl).getPath());
                                String pid = TypeDomImpl.getPluginID(ntdoc);
                                String name = TypeDomImpl.getTypeName(ntdoc);
                                ArrayList<Document> otdocs = typedocs.get(pid);
                                Document otdoc = null;
                                if (otdocs == null) {
                                    otdocs = new ArrayList();
                                    typedocs.put(pid, otdocs);
                                } else {
                                    otdoc = TypeManager.getTypeDocument(otdocs, name);
                                    if (otdoc != null && !TypeManager.isNewer(otdoc, ntdoc)) break block14;
                                }
                                if (otdoc != null) {
                                    DomImpl.setID(ntdoc, DomImpl.getID(otdoc));
                                    DomImpl.setLastModifiedTime(ntdoc, DomImpl.getUniqueID());
                                    TypeManager.deleteodoc(otdoc);
                                } else {
                                    long id = DomImpl.getUniqueID();
                                    DomImpl.setID(ntdoc, id);
                                    DomImpl.setLastModifiedTime(ntdoc, id);
                                }
                                String iconPath = elements[j].getAttribute("icon");
                                if (iconPath != null) {
                                    URL iconUrl = Platform.getBundle((String)elements[j].getContributor().getName()).getEntry(iconPath);
                                    TypeDomImpl.setImage(ntdoc, FileLocator.toFileURL((URL)iconUrl).getPath());
                                }
                                TypeManager.register(ntdoc);
                                otdocs.add(ntdoc);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    private static boolean isNewer(Document olddoc, Document newdoc) {
        String[] oldv = TypeDomImpl.getVersion(olddoc).split(".");
        String[] newv = TypeDomImpl.getVersion(newdoc).split(".");
        if (oldv.length != 3 && newv.length == 3) {
            return true;
        }
        if (oldv.length != 3 && newv.length != 3) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            if (Integer.parseInt(newv[i]) > Integer.parseInt(oldv[i])) {
                return true;
            }
            if (Integer.parseInt(newv[i]) < Integer.parseInt(oldv[i])) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private static void deleteodoc(Document odoc) {
        Request req = new Request();
        req.collection = "type";
        req.command = 2;
        req.options = 0;
        req.data = odoc;
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(req);
        FrameworkPlugin.updateDocuments(reqs, null);
    }

    private static void register(Document tdoc) {
        Request req = new Request();
        req.collection = "type";
        req.command = 1;
        req.options = 0;
        req.data = tdoc;
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(req);
        FrameworkPlugin.updateDocuments(reqs, null);
    }

    public static Document getTypeDocument(String pluginid, String name) {
        ArrayList<Document> docs = typedocs.get(pluginid);
        return TypeManager.getTypeDocument(docs, name);
    }

    public static Document getTypeDocument(String name) {
        Enumeration<ArrayList<Document>> en = typedocs.elements();
        while (en.hasMoreElements()) {
            ArrayList<Document> docs = en.nextElement();
            Document doc = TypeManager.getTypeDocument(docs, name);
            if (doc == null) continue;
            return doc;
        }
        return null;
    }

    public static String getPluginIDByType(String name) {
        Enumeration<String> en = typedocs.keys();
        while (en.hasMoreElements()) {
            String pid = en.nextElement();
            ArrayList<Document> docs = typedocs.get(pid);
            Document doc = TypeManager.getTypeDocument(docs, name);
            if (doc == null) continue;
            return pid;
        }
        return null;
    }

    public static ArrayList<Document> getTypeDocumentsByPluginID(String pluginid) {
        return typedocs.get(pluginid);
    }

    private static ArrayList<Document> filterTypeDocuments(ArrayList<Document> tdocs, boolean showunclassified, boolean shownodialog, boolean showfolder) {
        ArrayList<Document> ntdocs = new ArrayList<Document>();
        int i = 0;
        while (i < tdocs.size()) {
            Document tdoc = tdocs.get(i);
            if (!(TypeDomImpl.getTypeName(tdoc).equals("Unclassified") && !showunclassified || !TypeDomImpl.getDialogMode(tdoc) && shownodialog || TypeDomImpl.getFolderType(tdoc) && !showfolder)) {
                ntdocs.add(tdoc);
            }
            ++i;
        }
        return ntdocs;
    }

    public static ArrayList<Document> getAllTypeDocuments(boolean showunclassified, boolean shownodialog, boolean showfolder) {
        ArrayList<Document> docs = new ArrayList<Document>();
        Enumeration<ArrayList<Document>> en = typedocs.elements();
        while (en.hasMoreElements()) {
            docs.addAll((Collection<Document>)en.nextElement());
        }
        return TypeManager.filterTypeDocuments(docs, showunclassified, shownodialog, showfolder);
    }

    public static ArrayList<Document> getSortedTypeDocuments(boolean showunclassified, boolean shownodialog, boolean showfolder) {
        ArrayList<Document> docs = TypeManager.getAllTypeDocuments(showunclassified, shownodialog, showfolder);
        Collections.sort(docs, new Comparator<Document>(){

            @Override
            public int compare(Document doc1, Document doc2) {
                String t1 = TypeDomImpl.getTypeName(doc1);
                if (t1.equals("Unclassified")) {
                    return -1;
                }
                String t2 = TypeDomImpl.getTypeName(doc2);
                if (t2.equals("Unclassified")) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
        return docs;
    }

    public static ArrayList<String> getAllTypeNames(boolean showunclassified, boolean shownodialog, boolean showfolder) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Document> docs = TypeManager.getAllTypeDocuments(showunclassified, shownodialog, showfolder);
        int i = 0;
        while (i < docs.size()) {
            names.add(TypeDomImpl.getTypeName(docs.get(i)));
            ++i;
        }
        return names;
    }

    public static ArrayList<String> getSortedTypeNames(boolean showunclassified, boolean shownodialog, boolean showfolder) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Document> docs = TypeManager.getSortedTypeDocuments(showunclassified, shownodialog, showfolder);
        int i = 0;
        while (i < docs.size()) {
            names.add(TypeDomImpl.getTypeName(docs.get(i)));
            ++i;
        }
        return names;
    }
}

