/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.editor.AdditionalInfoDialogArea;
import jp.sourceforge.concierge.editor.CommonDialogArea;
import jp.sourceforge.concierge.editor.DataDialogInput;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.CCGUpdateType;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.util.FileLauncher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDialog
extends Dialog {
    private static ArrayList<DataDialog> dialoglist = null;
    private static final int PREV = 10001;
    private static final int NEXT = 10002;
    private Composite droot = null;
    private Composite comroot = null;
    private Combo typecombo = null;
    private Object sender = null;
    private ArrayList<DataDialogInput> dialoginput = new ArrayList();
    private int currentindex = 0;
    private IConciergeDialogArea dialogarea = null;
    private IEditorEventListener elistener = new IEditorEventListener(){

        public void run(EditorEvent e) {
            if (e.event == 1) {
                DataDialogInput ddi = (DataDialogInput)DataDialog.this.dialoginput.get(DataDialog.this.currentindex);
                DataDialog.this.getShell().setText(String.valueOf(DataDomImpl.getFileName(ddi.getDocument())) + " *");
                ddi.setModified(true);
            }
        }
    };
    private IConciergeDialogArea commonarea = null;
    private static final Image openimg;
    private static final Image autofillimg;
    private static final Image tplusimg;
    private static final Image tminusimg;

    static {
        if (dialoglist == null) {
            dialoglist = new ArrayList();
            FrameworkPlugin.addDatabaseListener("data", new CCGUpdateThread(PlatformUI.getWorkbench().getDisplay(), new ICCGUpdateListener(){

                public void updated(CCGUpdateEvent ev) {
                    DataDialog.updateDialog(ev);
                }
            }));
        }
        openimg = FrameworkPlugin.getImageDescriptor("icons/openfile.png").createImage();
        autofillimg = FrameworkPlugin.getImageDescriptor("icons/autofill.png").createImage();
        tplusimg = FrameworkPlugin.getImageDescriptor("icons/plus.png").createImage();
        tminusimg = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE").createImage();
    }

    private Point getProperSize() {
        Point size = this.getShell().computeSize(-1, -1);
        return size;
    }

    private boolean saveConfirm() {
        MessageBox box = new MessageBox(this.getShell(), 200);
        box.setMessage("The metadata was modified. Save before leaving?");
        int ret = box.open();
        return ret == 64;
    }

    private boolean isUnclassified(String type) {
        return type.equals("Unclassified") || type.equals("none");
    }

    private void removeChildControls(Composite parent) {
        Control[] ctrls = parent.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            ctrls[i].dispose();
            ++i;
        }
    }

    private void dialogDataChanged(int index) {
        DataDialogInput nddi = this.dialoginput.get(index);
        String type = nddi.getType();
        if (this.isUnclassified(type)) {
            this.dialogarea = new CommonDialogArea();
        } else {
            this.dialogarea = this.getConciergeDialogArea(TypeManager.getPluginIDByType(type));
            if (this.dialogarea == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Error", (String)("To edit the item of this type, need to install " + type + " plugin."));
                this.dialogarea = new CommonDialogArea();
            }
        }
        this.currentindex = index;
        this.removeChildControls(this.droot);
        this.removeChildControls(this.comroot);
        this.dialogarea.setDocument(nddi.getDocument());
        this.dialogarea.createDialogArea(this.droot);
        this.dialogarea.setDocumentChangeListener(this.elistener);
        this.commonarea = new AdditionalInfoDialogArea();
        this.commonarea.setDocument(nddi.getDocument());
        this.commonarea.createDialogArea(this.comroot);
        this.commonarea.setDocumentChangeListener(this.elistener);
        this.getShell().setText(DataDomImpl.getFileName(nddi.getDocument()));
        this.getShell().setSize(this.getProperSize());
        type = this.dialogarea.getType();
        if (this.isUnclassified(type)) {
            this.typecombo.setText("Common");
            this.dialogarea.setEnabled(true);
        } else {
            this.typecombo.setText(type);
            if (DataDomImpl.hasTypeOf(nddi.getDocument(), type)) {
                this.dialogarea.setEnabled(true);
            } else {
                this.dialogarea.setEnabled(false);
            }
        }
        this.getShell().setSize(this.getProperSize());
        this.comroot.layout();
        this.droot.layout();
    }

    private void saveDocument() {
        DataDialogInput ddi = this.dialoginput.get(this.currentindex);
        this.commonarea.saveDocument();
        if (this.dialogarea.isEnabled()) {
            this.dialogarea.saveDocument();
            String type = this.dialogarea.getType();
            if (this.isUnclassified(type)) {
                DataDomImpl.setDefaultType(ddi.getDocument(), "Unclassified");
            } else {
                DataDomImpl.setDefaultType(ddi.getDocument(), type);
            }
        }
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request(ddi.isNewdoc() ? 1 : 3, ddi.getDocument(), "data");
        reqs.add(req);
        FrameworkPlugin.updateDocuments(reqs, this.sender);
        ddi.setNewdoc(false);
        this.getShell().setText(DataDomImpl.getFileName(ddi.getDocument()));
        ddi.setModified(false);
        ddi.setChanged(true);
        this.setReturnCode(0);
    }

    private void goPrev() {
        DataDialogInput ddi = this.dialoginput.get(this.currentindex);
        if (ddi.isModified() && this.saveConfirm()) {
            this.saveDocument();
            ddi.setModified(false);
        }
        this.currentindex = this.currentindex == 0 ? this.dialoginput.size() - 1 : --this.currentindex;
        this.dialogDataChanged(this.currentindex);
    }

    private void goNext() {
        DataDialogInput ddi = this.dialoginput.get(this.currentindex);
        if (ddi.isModified() && this.saveConfirm()) {
            this.saveDocument();
            ddi.setModified(false);
        }
        this.currentindex = this.currentindex == this.dialoginput.size() - 1 ? 0 : ++this.currentindex;
        this.dialogDataChanged(this.currentindex);
    }

    private String getTypeFromCombo() {
        String type = this.typecombo.getText();
        if (type.equals("Common")) {
            return "Unclassified";
        }
        return type;
    }

    public DataDialog(Shell shell, int style) {
        super(shell);
        dialoglist.add(this);
    }

    protected void handleShellCloseEvent() {
        DataDialogInput ddi = this.dialoginput.get(this.currentindex);
        if (ddi.isModified() && this.saveConfirm()) {
            this.saveDocument();
        }
        super.handleShellCloseEvent();
        this.sender = null;
        dialoglist.remove((Object)this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Composite toparea = new Composite(dialog, 0);
        toparea.setLayout((Layout)new GridLayout(2, false));
        toparea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.droot = new Composite(dialog, 0);
        GridData drgd = new GridData(4, 4, true, false);
        drgd.widthHint = 480;
        this.droot.setLayoutData((Object)drgd);
        this.typecombo = new Combo(toparea, 8);
        ArrayList<Document> typedocs = TypeManager.getSortedTypeDocuments(true, false, true);
        int i = 0;
        while (i < typedocs.size()) {
            block3: {
                String type;
                block5: {
                    block4: {
                        Document tdoc = typedocs.get(i);
                        if (!TypeDomImpl.getDialogMode(tdoc)) break block3;
                        type = TypeDomImpl.getTypeName(tdoc);
                        if (!this.isUnclassified(type)) break block4;
                        type = "Common";
                        break block5;
                    }
                    if (!this.hasConciergeDialogArea(TypeManager.getPluginIDByType(type))) break block3;
                }
                this.typecombo.add(type);
            }
            ++i;
        }
        ToolBar tb = new ToolBar(toparea, 0);
        tb.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(tplusimg);
        ti.setToolTipText("Add new item of the type");
        ti.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DataDialog.this.dialogarea.setEnabled(true);
            }
        });
        ti = new ToolItem(tb, 8);
        ti.setImage(tminusimg);
        ti.setToolTipText("Remove the item of the type");
        ti.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!DataDialog.this.dialogarea.isEnabled()) {
                    return;
                }
                if (DataDialog.this.isUnclassified(DataDialog.this.getTypeFromCombo())) {
                    return;
                }
                MessageBox box = new MessageBox(DataDialog.this.getShell(), 200);
                box.setMessage("The metadata will be deleted. OK?");
                if (box.open() == 64) {
                    DataDialogInput ddi = (DataDialogInput)DataDialog.this.dialoginput.get(DataDialog.this.currentindex);
                    DataDomImpl.removeDataOfType(ddi.getDocument(), DataDialog.this.getTypeFromCombo());
                    DataDialog.this.dialogarea.setEnabled(false);
                    ddi.setModified(true);
                }
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 8);
        ti.setImage(autofillimg);
        ti.setToolTipText("Auto fill out");
        ti.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DataDialog.this.dialogarea.fillout();
                DataDialog.this.dialogarea.setEnabled(true);
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 8);
        ti.setImage(openimg);
        ti.setToolTipText("Open file");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataDialog.this.dialogarea instanceof CommonDialogArea) {
                    FileLauncher.LaunchFile(new File(((CommonDialogArea)DataDialog.this.dialogarea).getCurrentFilePath()));
                } else {
                    FileLauncher.LaunchFile(((DataDialogInput)DataDialog.this.dialoginput.get(DataDialog.this.currentindex)).getDocument());
                }
            }
        });
        this.comroot = new Composite(dialog, 0);
        GridData kwdgd = new GridData(4, 4, true, true);
        kwdgd.widthHint = 480;
        this.comroot.setLayoutData((Object)kwdgd);
        this.dialogDataChanged(this.currentindex);
        this.typecombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = DataDialog.this.getTypeFromCombo();
                DataDialogInput ddi = (DataDialogInput)DataDialog.this.dialoginput.get(DataDialog.this.currentindex);
                if (DataDialog.this.dialogarea != null && !DataDialog.this.dialogarea.isDisposed() && DataDialog.this.dialogarea.isEnabled() && ddi.isModified() && DataDialog.this.saveConfirm()) {
                    DataDialog.this.saveDocument();
                }
                ddi.setType(text);
                DataDialog.this.dialogDataChanged(DataDialog.this.currentindex);
                DataDialog.this.droot.layout();
                if (DataDomImpl.hasTypeOf(ddi.getDocument(), text)) {
                    DataDialog.this.dialogarea.setEnabled(true);
                } else {
                    DataDialog.this.dialogarea.setEnabled(false);
                }
                if (DataDialog.this.isUnclassified(DataDialog.this.dialogarea.getType())) {
                    e.doit = false;
                    ((Combo)e.widget).setText("Common");
                }
            }
        });
        return dialog;
    }

    protected void initializeBounds() {
        this.getShell().setLocation(100, 100);
        this.getShell().setSize(this.getProperSize());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10001, "Prev", false);
        this.createButton(parent, 10002, "Next", false);
        this.createButton(parent, 64, "Close", false);
        this.createButton(parent, 8192, "Save", true);
    }

    protected void buttonPressed(int button) {
        if (button == 8192) {
            this.saveDocument();
            return;
        }
        if (button == 10001) {
            this.goPrev();
            return;
        }
        if (button == 10002) {
            this.goNext();
            return;
        }
        if (button == 64) {
            if (this.dialoginput.get(this.currentindex).isModified() && this.saveConfirm()) {
                this.saveDocument();
            }
            this.close();
        }
    }

    public void setDocument(Document metadata, String type, Object sender) {
        this.sender = sender;
        DataDialogInput ddi = new DataDialogInput(metadata, type, false);
        DataDomImpl.setDefaultType(metadata, type);
        this.dialoginput.clear();
        this.dialoginput.add(ddi);
        this.currentindex = 0;
    }

    public void setDocuments(ArrayList<DataDialogInput> dei, Object sender) {
        assert (dei.size() > 0);
        this.sender = sender;
        this.dialoginput.clear();
        this.dialoginput.addAll(dei);
        this.currentindex = 0;
    }

    public void setNewDocument(Document metadata, String type, Object sender) {
        this.sender = sender;
        if (metadata == null) {
            Document tdoc = TypeManager.getTypeDocument(type);
            metadata = DataDomImpl.createDocument(tdoc);
        }
        DataDialogInput ddi = new DataDialogInput(metadata, type, true);
        ddi.setModified(true);
        DataDomImpl.setDefaultType(metadata, type);
    }

    public boolean close() {
        dialoglist.remove((Object)this);
        return super.close();
    }

    public static void updateDialog(CCGUpdateEvent ev) {
        if (!ev.success.booleanValue() || ev.type == CCGUpdateType.ADD_DOCUMENT) {
            return;
        }
        int i = 0;
        while (i < dialoglist.size()) {
            DataDialog dd = dialoglist.get(i);
            if (!dd.sender.equals(ev.sender)) {
                ArrayList<DataDialogInput> ddil = new ArrayList<DataDialogInput>();
                ddil.addAll(dd.dialoginput);
                int j = 0;
                while (j < ddil.size()) {
                    DataDialogInput ddi = dd.dialoginput.get(j);
                    Document ndoc = DomImpl.findDocument(ev.documents, ddi.getDocument());
                    if (ndoc != null) {
                        ddi.setDocument(ndoc);
                        ddi.setNewdoc(false);
                        ddi.setType(DataDomImpl.getDefaultType(ddi.getDocument()));
                    }
                    ++j;
                }
                dd.setDocuments(ddil, dd.sender);
            }
            ++i;
        }
    }

    public IConciergeDialogArea getConciergeDialogArea(String pluginid) {
        IConciergeDialogArea conciergeDialogArea = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("jp.sourceforge.concierge.framework.ConciergeDialogArea");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("ConciergeDialogArea") && pluginid.equals(elements[j].getAttribute("pluginid"))) {
                        try {
                            conciergeDialogArea = (IConciergeDialogArea)elements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return conciergeDialogArea;
    }

    public boolean hasConciergeDialogArea(String pluginid) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("jp.sourceforge.concierge.framework.ConciergeDialogArea");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("ConciergeDialogArea") && pluginid.equals(elements[j].getAttribute("pluginid"))) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }
}

