/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.smartindexer.widget;

import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.smartindexer.widget.DocumentViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Element;

public class FolderInputDialog
extends Dialog {
    private static final String strNameLabel = "Name";
    private Composite base = null;
    private Text nameText = null;
    private DocumentViewer compDocList = null;
    private Element config = null;
    private boolean bModify;

    public FolderInputDialog(Shell shell, int style) {
        super(new Shell(shell, style));
        this.setShellStyle(style);
        this.base = null;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.base = null;
        this.nameText = null;
        this.bModify = false;
    }

    protected Control createDialogArea(Composite parent) {
        this.base = (Composite)super.createDialogArea(parent);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite(this.base, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(comp, 131072);
        nameLabel.setLayoutData((Object)new GridData());
        nameLabel.setText(strNameLabel);
        this.nameText = new Text(comp, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderInputDialog.this.bModify = true;
            }
        });
        Label seplatorLabel = new Label(this.base, 258);
        seplatorLabel.setLayoutData((Object)new GridData(768));
        this.compDocList = new DocumentViewer(this.base, 0);
        this.compDocList.setLayoutData(new GridData(1808));
        this.compDocList.setConfigure(this.config);
        Action modifyAction = new Action(){

            public void run() {
                FolderInputDialog.this.bModify = true;
            }
        };
        this.compDocList.setModifyAction(modifyAction);
        this.update();
        return this.base;
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 480);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int button) {
        if (button == 0) {
            this.save();
            this.setReturnCode(button);
            this.close();
        } else if (button == 1) {
            if (this.bModify && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Save", (String)"The condition was modified. Do you want to save before leaving?")) {
                this.save();
                this.bModify = false;
            }
            this.setReturnCode(button);
            this.close();
        }
    }

    protected void save() {
        String name = this.nameText.getText();
        if (name.trim().length() < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"name is empty.");
            return;
        }
        Configure.setName((Element)this.config, (String)name);
        if (this.compDocList != null) {
            this.compDocList.save();
        }
        this.bModify = false;
    }

    public void setElement(Element elem) {
        assert (elem != null);
        this.config = elem;
    }

    public void update() {
        if (this.config != null) {
            if (this.nameText != null) {
                String name = Configure.getName((Element)this.config);
                this.nameText.setText(name);
            }
            if (this.compDocList != null) {
                this.compDocList.update();
            }
        }
        this.bModify = false;
    }
}

