/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.smartindexer.widget;

import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.util.DataDomTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentViewer
extends Composite {
    private Element config = null;
    private TableViewer docTable = null;
    private Action modifyAction = null;

    public DocumentViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.docTable = new TableViewer((Composite)this, 268501762);
        Table tbl = this.docTable.getTable();
        tbl.setLayoutData((Object)new GridData(1808));
        tbl.setFont(new Font((Device)tbl.getDisplay(), "Vernada", 10, 0));
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn colFile = new TableColumn(tbl, 16384);
        colFile.setText("File");
        colFile.setWidth(100);
        TableColumn colTitle = new TableColumn(tbl, 16384);
        colTitle.setText("Title");
        colTitle.setWidth(100);
        ITypeParser parser = FrameworkPlugin.getParser((String)"text");
        colTitle.setData((Object)parser);
        TableColumn colID = new TableColumn(tbl, 16384);
        colID.setText("ID");
        colID.setWidth(100);
        TableColumn colCreate = new TableColumn(tbl, 16384);
        colCreate.setText("Created Date");
        colCreate.setWidth(100);
        TableColumn colMod = new TableColumn(tbl, 16384);
        colMod.setText("Last Modified Date");
        colMod.setWidth(100);
        this.docTable.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    DocumentViewer.this.deleteItem();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.docTable.setContentProvider((IContentProvider)new ItemContentProvider());
        this.docTable.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.docTable.setInput(new ArrayList());
        DropTarget target = new DropTarget((Control)tbl, 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), DataDomTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropListener());
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        MenuItem item0 = new MenuItem(menu, 8);
        item0.setText("Delete");
        item0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentViewer.this.deleteItem();
            }
        });
        tbl.setMenu(menu);
    }

    public void setConfigure(Element e) {
        this.config = e;
    }

    public void setModifyAction(Action act) {
        this.modifyAction = act;
    }

    public void update() {
        if (this.config != null) {
            this.docTable.getTable().clearAll();
            ArrayList docList = Configure.getBindedDocuments((Element)this.config);
            int size = docList.size();
            int i = 0;
            while (i < size) {
                Document doc = (Document)docList.get(i);
                this.addItem(doc);
                ++i;
            }
        }
        this.docTable.refresh();
    }

    public void save() {
        Configure.setBindedDocuments((Element)this.config, (ArrayList)((ArrayList)this.docTable.getInput()));
    }

    public void deleteItem() {
        IStructuredSelection sels = (IStructuredSelection)this.docTable.getSelection();
        ArrayList docs = (ArrayList)this.docTable.getInput();
        this.docTable.setInput(null);
        docs.removeAll(sels.toList());
        this.docTable.setInput((Object)docs);
        if (this.modifyAction != null) {
            this.modifyAction.run();
        }
    }

    public void addItem(Document doc) {
        ArrayList docs = (ArrayList)this.docTable.getInput();
        if (docs.contains(doc)) {
            return;
        }
        this.docTable.setInput(null);
        docs.add(doc);
        this.docTable.setInput((Object)docs);
        if (this.modifyAction != null) {
            this.modifyAction.run();
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent e) {
            if (e == null) {
                return;
            }
            TransferData tData = e.currentDataType;
            if (!LocalSelectionTransfer.getTransfer().isSupportedType(tData) && !FileTransfer.getInstance().isSupportedType(tData) && DataDomTransfer.getInstance().isSupportedType(tData)) {
                Document[] docs = (Document[])e.data;
                int i = 1;
                while (i < docs.length) {
                    DocumentViewer.this.addItem(docs[i]);
                    ++i;
                }
            }
        }

        public void dropAccept(DropTargetEvent e) {
        }
    }

    private class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object dataset) {
            return ((ArrayList)dataset).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ItemLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ItemLabelProvider() {
        }

        public boolean isLabelProperty(Object object, String property) {
            return false;
        }

        public String getColumnText(Object object, int index) {
            Document doc = (Document)object;
            Table tbl = DocumentViewer.this.docTable.getTable();
            TableColumn tc = tbl.getColumn(index);
            String title = tc.getText();
            if (title.compareTo("File") == 0) {
                return DataDomImpl.getFilePath((Document)doc);
            }
            if (title.compareTo("ID") == 0) {
                return String.valueOf(DomImpl.getID((Document)doc));
            }
            if (title.compareTo("Title") == 0) {
                return DataDomImpl.getTitle((Document)doc);
            }
            if (title.compareTo("Created Date") == 0) {
                return new Date(DomImpl.getID((Document)doc)).toString();
            }
            if (title.compareTo("Last Modified Date") == 0) {
                return new Date(DomImpl.getLastModifiedTime((Document)doc)).toString();
            }
            return null;
        }

        public Image getColumnImage(Object object, int index) {
            return null;
        }

        public Color getForeground(Object element, int index) {
            return null;
        }

        public Color getBackground(Object element, int index) {
            return null;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

