/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;

public class XPathString {
    public static final String AND = " and ";
    public static final String OR = " or ";
    private static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";

    public static String getElementContainsPredicate(String value, boolean recursive) {
        String pos = recursive ? "descendant-or-self::node()" : ".";
        return "contains(translate(" + pos + ",'" + UPPERCASE + "', '" + LOWERCASE + "'), '" + value.toLowerCase() + "')";
    }

    public static String getElementStartsWithPredicate(String value) {
        return "starts-with(translate(.,'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + value.toLowerCase() + "')";
    }

    public static String getElementEqualsPredicate(String value) {
        return "translate(.,'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')='" + value.toLowerCase() + "')";
    }

    public static String getAttributeContainsPredicate(String attr, String value) {
        return "contains(translate(@" + attr + ",'" + UPPERCASE + "', '" + LOWERCASE + "'), '" + value.toLowerCase() + "')";
    }

    public static String getAttributeStartsWithPredicate(String attr, String value) {
        return "starts-with(translate(@" + attr + ",'" + UPPERCASE + "', '" + LOWERCASE + "'), '" + value.toLowerCase() + "')";
    }

    public static String getAttributeEqualsPredicate(String attr, String value) {
        return "translate(@" + attr + ",'" + UPPERCASE + "', '" + LOWERCASE + "')='" + value.toLowerCase() + "'";
    }

    public static String getElementBetweenPredicate(String max, String min) {
        return String.valueOf(min) + "<=. and .<=" + max;
    }

    public static String getElementLEPredicate(String max) {
        return ".<=" + max;
    }

    public static String getElementGEPredicate(String min) {
        return String.valueOf(min) + "<=.";
    }

    public static String getAttributeBetweenPredicate(String attr, String max, String min) {
        return String.valueOf(min) + "<=@" + attr + " and @" + attr + "<=" + max;
    }

    public static String getAttributeLEPredicate(String attr, String max) {
        return "@" + attr + "<=" + max;
    }

    public static String getAttributeGEPredicate(String attr, String min) {
        return String.valueOf(min) + "<=@" + attr;
    }

    public static String getElementContainsPredicate(ArrayList<String> values, String con, boolean recursive, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getElementContainsPredicate(values.get(0), recursive);
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + con + XPathString.getElementContainsPredicate(values.get(i), recursive);
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }

    public static String getElementStartsWithPredicate(ArrayList<String> values, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getElementStartsWithPredicate(values.get(0));
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + OR + XPathString.getElementStartsWithPredicate(values.get(i));
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }

    public static String getElementEqualsPredicate(ArrayList<String> values, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getElementEqualsPredicate(values.get(0));
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + OR + XPathString.getElementEqualsPredicate(values.get(i));
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }

    public static String getAttributeContainsPredicate(String attr, ArrayList<String> values, String con, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getAttributeContainsPredicate(attr, values.get(0));
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + con + XPathString.getAttributeContainsPredicate(attr, values.get(i));
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }

    public static String getAttributeStartsWithPredicate(String attr, ArrayList<String> values, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getAttributeStartsWithPredicate(attr, values.get(0));
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + OR + XPathString.getAttributeStartsWithPredicate(attr, values.get(i));
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }

    public static String getAttributeEqualsPredicate(String attr, ArrayList<String> values, boolean not) {
        assert (values.size() > 0);
        String val = XPathString.getAttributeEqualsPredicate(attr, values.get(0));
        int i = 1;
        while (i < values.size()) {
            val = String.valueOf(val) + OR + XPathString.getAttributeEqualsPredicate(attr, values.get(i));
            ++i;
        }
        return not ? "not(" + val + ")" : val;
    }
}

