/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.Hashtable;
import jp.sourceforge.concierge.parser.ITypeParser;

public class ParserManager {
    private static final String[] parsers = new String[]{"AuthorsParser", "DateParser", "HTMLDocumentParser", "IdentifiersParser", "KeywordsParser", "LogParser", "RangeParser", "TextParser", "UrlParser"};
    private static final String[] parserids = new String[]{"authors", "date", "htmldocument", "identifiers", "keywords", "log", "range", "text", "url"};
    private static Hashtable<String, String> ptable = new Hashtable();

    static {
        int i = 0;
        while (i < parserids.length) {
            ptable.put(parserids[i], parsers[i]);
            ++i;
        }
    }

    public static ITypeParser getInstance(String parserid) {
        try {
            Class<?> c = Class.forName("jp.sourceforge.concierge.parser." + ptable.get(parserid));
            return (ITypeParser)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getAllParserTypes() {
        return parsers;
    }

    public static boolean contains(String parserid) {
        return ptable.containsKey(parserid);
    }
}

