/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.mdocument;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.ParserManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDomConverter {
    private static String getFilePath(Document odoc) {
        return DomImpl.getAttribute(odoc.getDocumentElement(), "filename");
    }

    private static long getLastModDate(Document odoc) {
        return Long.parseLong(DomImpl.getAttribute(odoc.getDocumentElement(), "lastmod"));
    }

    private static long getID(Document odoc) {
        return Long.parseLong(DomImpl.getAttribute(odoc.getDocumentElement(), "id"));
    }

    private static void removeAttributes(Element oelem) {
        oelem.removeAttribute("id");
        oelem.removeAttribute("filebase");
        oelem.removeAttribute("filename");
        oelem.removeAttribute("filepath");
        oelem.removeAttribute("lastmod");
        oelem.removeAttribute("tid");
    }

    private static String getOldText(Element oelem) {
        String pname = DomImpl.getAttribute(oelem, "parser");
        ITypeParser parser = ParserManager.getInstance(pname);
        return parser.getSingleText(oelem);
    }

    public static ArrayList<Document> convert(ArrayList<Document> olddocs) {
        ArrayList<Document> newdocs = new ArrayList<Document>();
        int i = 0;
        while (i < olddocs.size()) {
            Document odoc = olddocs.get(i);
            Document ndoc = DataDomImpl.createDocument();
            DataDomImpl.setFilePath(ndoc, DataDomConverter.getFilePath(odoc));
            DomImpl.setLastModifiedTime(ndoc, DataDomConverter.getLastModDate(odoc));
            DomImpl.setID(ndoc, DataDomConverter.getID(odoc));
            String type = DomImpl.getAttribute(DomImpl.getRootElement(odoc), "name");
            if (type.equals("Misc")) {
                ArrayList<Element> elems = DomImpl.getElements(odoc, "Title");
                assert (elems.size() == 1);
                DataDomImpl.setTitle(ndoc, DataDomConverter.getOldText(elems.get(0)));
                elems = DomImpl.getElements(odoc, "Keywords");
                assert (elems.size() == 1);
                DataDomImpl.setKeywords(ndoc, DataDomConverter.getOldText(elems.get(0)));
                elems = DomImpl.getElements(odoc, "Comment");
                assert (elems.size() == 1);
                DataDomImpl.setComment(ndoc, DataDomConverter.getOldText(elems.get(0)));
                DataDomImpl.setDefaultType(ndoc, "Unclassified");
            } else {
                Element ielem = (Element)ndoc.importNode(odoc.getDocumentElement(), true);
                ndoc.getDocumentElement().appendChild(ielem);
                DataDomConverter.removeAttributes(ielem);
                DataDomImpl.setDefaultType(ndoc, type);
            }
            ++i;
        }
        return newdocs;
    }
}

