/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class TargetSiteDialog
extends Dialog {
    protected static final String MOST_RECEANTLY_USED_SITE_URL = "mostReceantlyUsedSiteURL";
    private TableViewer siteViewer;
    private IInstallConfiguration config;
    private Button addButton;
    private Button deleteButton;
    private IInstallFeatureOperation[] jobs;
    private WorkingCopy workingCopy;

    public TargetSiteDialog(Shell parentShell, IInstallConfiguration config, IInstallFeatureOperation[] jobs) {
        super(parentShell);
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect((Object)this);
        this.jobs = jobs;
        this.workingCopy = new WorkingCopy();
    }

    public boolean close() {
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    public Control createDialogArea(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Composite leftPanel = new Composite(client, 0);
        GridLayout centerLayout = new GridLayout();
        centerLayout.numColumns = 1;
        centerLayout.marginHeight = 0;
        centerLayout.marginWidth = 0;
        leftPanel.setLayout((Layout)centerLayout);
        leftPanel.setLayoutData((Object)new GridData(1808));
        Label label = new Label(leftPanel, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_siteLabel);
        this.createSiteViewer(leftPanel);
        Composite rightPanel = new Composite(client, 0);
        GridLayout rightLayout = new GridLayout();
        rightLayout.numColumns = 1;
        rightLayout.marginHeight = 0;
        rightLayout.marginWidth = 0;
        rightPanel.setLayout((Layout)rightLayout);
        rightPanel.setLayoutData((Object)new GridData(1040));
        new Label(rightPanel, 0);
        Composite buttonContainer = new Composite(rightPanel, 0);
        GridLayout blayout = new GridLayout();
        blayout.marginHeight = 0;
        blayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)blayout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonContainer, 8);
        this.addButton.setText(UpdateUIMessages.InstallWizard_TargetPage_new);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetSiteDialog.this.addTargetLocation();
            }
        });
        this.addButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addButton);
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setText(UpdateUIMessages.InstallWizard_TargetPage_delete);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TargetSiteDialog.this.removeSelection();
                }
                catch (CoreException ex) {
                    UpdateUI.logException(ex);
                }
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.deleteButton);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.update.ui.MultiTargetPage2");
        Dialog.applyDialogFont((Control)parent);
        this.siteViewer.setInput((Object)this.jobs[0]);
        IConfiguredSite affinitySite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)this.config, (IInstallFeatureOperation)this.jobs[0], (boolean)true);
        if (this.jobs[0].getTargetSite() != null) {
            this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)this.jobs[0].getTargetSite()));
        }
        this.addButton.setEnabled(affinitySite == null);
        return client;
    }

    private void createSiteViewer(Composite parent) {
        this.siteViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        this.siteViewer.getTable().setLayoutData((Object)gd);
        this.siteViewer.setContentProvider((IContentProvider)new SitesContentProvider());
        this.siteViewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.siteViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object obj) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)TargetSiteDialog.this.siteViewer.getInput();
                return TargetSiteDialog.this.getSiteVisibility((IConfiguredSite)obj, job);
            }
        });
        this.siteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                TargetSiteDialog.this.selectTargetSite(ssel);
                TargetSiteDialog.this.updateButtons(ssel);
            }
        });
        this.workingCopy.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                TargetSiteDialog.this.siteViewer.refresh();
            }
        });
    }

    protected void okPressed() {
        this.workingCopy.commit();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons((IStructuredSelection)this.siteViewer.getSelection());
    }

    private void updateButtons(IStructuredSelection selection) {
        this.deleteButton.setEnabled(this.canDelete(selection));
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!selection.isEmpty());
        }
    }

    private boolean canDelete(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (IConfiguredSite site : selection) {
            if (this.workingCopy.isNewlyAdded(site)) continue;
            return false;
        }
        return true;
    }

    private void selectTargetSite(IStructuredSelection selection) {
        IConfiguredSite site = (IConfiguredSite)selection.getFirstElement();
        if (site != null) {
            IDialogSettings master = UpdateUI.getDefault().getDialogSettings();
            IDialogSettings section = master.getSection(MOST_RECEANTLY_USED_SITE_URL);
            if (section == null) {
                section = master.addNewSection(MOST_RECEANTLY_USED_SITE_URL);
            }
            section.put(MOST_RECEANTLY_USED_SITE_URL, site.getSite().getURL().toExternalForm());
            this.workingCopy.setTargetSite(site);
        }
    }

    private void addTargetLocation() {
        DirectoryDialog dd = new DirectoryDialog(this.getShell());
        dd.setMessage(UpdateUIMessages.InstallWizard_TargetPage_location_message);
        String path = dd.open();
        if (path != null) {
            this.addConfiguredSite(this.getShell(), this.config, new File(path));
        }
    }

    private void removeSelection() throws CoreException {
        IStructuredSelection selection = (IStructuredSelection)this.siteViewer.getSelection();
        for (IConfiguredSite targetSite : selection) {
            this.workingCopy.removeSite(targetSite);
        }
        this.siteViewer.refresh();
    }

    private IConfiguredSite addConfiguredSite(Shell shell, IInstallConfiguration config, File file) {
        try {
            IConfiguredSite csite = config.createConfiguredSite(file);
            IStatus status = csite.verifyUpdatableStatus();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            this.workingCopy.addSite(csite);
            this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)csite));
            this.siteViewer.getControl().setFocus();
            return csite;
        }
        catch (CoreException e) {
            String title = UpdateUIMessages.InstallWizard_TargetPage_location_error_title;
            ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)e.getStatus());
            UpdateUI.logException(e, false);
            return null;
        }
    }

    private boolean getSiteVisibility(IConfiguredSite site, IInstallFeatureOperation job) {
        if (!site.isUpdatable()) {
            return false;
        }
        IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)job.getFeature());
        if (affinitySite != null) {
            return site.getSite().equals(affinitySite.getSite());
        }
        if (job.getOldFeature() != null) {
            IConfiguredSite oldSite = UpdateUtils.getSiteWithFeature((IInstallConfiguration)this.config, (String)job.getOldFeature().getVersionedIdentifier().getIdentifier());
            return site == oldSite;
        }
        return true;
    }

    public IConfiguredSite[] getAddedSites() {
        return this.workingCopy.getAddedSites();
    }

    class SitesContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        SitesContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetSiteDialog.this.workingCopy.getSites();
        }
    }

    class SitesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SitesLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            return provider.getLocalSiteImage((IConfiguredSite)obj);
        }

        public String getColumnText(Object obj, int col) {
            if (col == 0) {
                ISite site = ((IConfiguredSite)obj).getSite();
                return new File(site.getURL().getFile()).toString();
            }
            return null;
        }
    }

    class WorkingCopy
    extends Observable {
        private ArrayList sites = new ArrayList();
        private ArrayList added = new ArrayList();
        private IConfiguredSite targetSite;

        public WorkingCopy() {
            IConfiguredSite[] initial = TargetSiteDialog.this.config.getConfiguredSites();
            int i = 0;
            while (i < initial.length) {
                this.sites.add(initial[i]);
                ++i;
            }
            i = 0;
            while (i < TargetSiteDialog.this.jobs.length) {
                IConfiguredSite jsite = TargetSiteDialog.this.jobs[i].getTargetSite();
                if (this.targetSite == null) {
                    this.targetSite = jsite;
                } else if (!this.targetSite.equals(jsite)) {
                    this.targetSite = null;
                }
                ++i;
            }
        }

        public void addSite(IConfiguredSite site) {
            this.sites.add(site);
            this.added.add(site);
            this.setChanged();
            this.notifyObservers(site);
            this.clearChanged();
        }

        public void removeSite(IConfiguredSite site) {
            this.sites.remove(site);
            this.added.remove(site);
            this.setChanged();
            this.notifyObservers(site);
            this.clearChanged();
        }

        public boolean isNewlyAdded(IConfiguredSite site) {
            return this.added.contains(site);
        }

        public void commit() {
            int i = 0;
            while (i < this.added.size()) {
                TargetSiteDialog.this.config.addConfiguredSite((IConfiguredSite)this.added.get(i));
                ++i;
            }
            i = 0;
            while (i < TargetSiteDialog.this.jobs.length) {
                TargetSiteDialog.this.jobs[i].setTargetSite(this.targetSite);
                ++i;
            }
        }

        public IConfiguredSite[] getSites() {
            return this.sites.toArray(new IConfiguredSite[this.sites.size()]);
        }

        public IConfiguredSite[] getAddedSites() {
            return this.added.toArray(new IConfiguredSite[this.added.size()]);
        }

        public IConfiguredSite getTargetSite() {
            return this.targetSite;
        }

        public void setTargetSite(IConfiguredSite site) {
            this.targetSite = site;
        }
    }
}

