/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.ui.ConfigurationManagerWindow;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.ui.UpdateJob;

public class FindUpdatesAction
extends Action {
    private IFeature feature;
    private ConfigurationManagerWindow window;

    public FindUpdatesAction(ConfigurationManagerWindow window, String text) {
        super(text);
        this.window = window;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public void run() {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            ErrorDialog.openError((Shell)this.window.getShell(), null, null, (IStatus)status);
            return;
        }
        if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
            return;
        }
        if (InstallWizard.isRunning()) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)UpdateUIMessages.InstallWizard_isRunningTitle, (String)UpdateUIMessages.InstallWizard_isRunningInfo);
            return;
        }
        IFeature[] features = null;
        if (this.feature != null) {
            features = new IFeature[]{this.feature};
        }
        TrackedUpdateJob job = new TrackedUpdateJob(UpdateUIMessages.InstallWizard_jobName, false, false, features);
        job.setUser(true);
        job.setPriority(10);
        String name = this.feature != null ? this.feature.getLabel() : UpdateUIMessages.FindUpdatesAction_allFeaturesSearch;
        this.window.trackUpdateJob(job, name);
        InstallWizardOperation operation = new InstallWizardOperation();
        operation.run(this.window.getShell(), job);
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)this.window.getShell(), (String)UpdateUIMessages.FeatureStateAction_dialogTitle, (String)message);
    }

    private class TrackedUpdateJob
    extends UpdateJob {
        public TrackedUpdateJob(String name, boolean isAutomatic, boolean download, IFeature[] features) {
            super(name, isAutomatic, download, features);
        }

        @Override
        public IStatus run(IProgressMonitor monitor) {
            return super.run((IProgressMonitor)new TrackingProgressMonitor(monitor));
        }
    }

    private class TrackingProgressMonitor
    extends ProgressMonitorWrapper {
        private String name;
        private String subname;
        private int totalWork;
        private double workSoFar;

        protected TrackingProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public void beginTask(String name, int totalWork) {
            this.name = name;
            this.totalWork = totalWork;
            super.beginTask(name, totalWork);
            this.updateStatus();
        }

        public void internalWorked(double ticks) {
            super.internalWorked(ticks);
            this.workSoFar += ticks;
            this.updateStatus();
        }

        public void subTask(String subTask) {
            this.subname = subTask;
            super.subTask(subTask);
            this.updateStatus();
        }

        private void updateStatus() {
            if (FindUpdatesAction.this.window.getShell() == null || FindUpdatesAction.this.window.getShell().isDisposed()) {
                return;
            }
            if (FindUpdatesAction.this.window.isProgressCanceled()) {
                this.setCanceled(true);
            }
            String perc = String.valueOf((int)(this.workSoFar * 100.0) / this.totalWork);
            final String message = NLS.bind((String)UpdateUIMessages.FindUpdatesAction_trackedProgress, (Object[])new String[]{this.name, this.subname, perc});
            Shell shell = FindUpdatesAction.this.window.getShell();
            if (shell == null || shell.isDisposed()) {
                return;
            }
            FindUpdatesAction.this.window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindUpdatesAction.this.window.updateStatusLine(message, null);
                }
            });
        }
    }
}

