/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class InstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private URL remoteSiteURL;
    private String featureId;
    private String version;

    public InstallCommand(String featureId, String version, String fromSite, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            int i;
            IConfiguredSite[] sites;
            this.featureId = featureId;
            this.version = version;
            this.remoteSiteURL = new URL(UpdateURLDecoder.decode((String)fromSite, (String)"UTF-8"));
            this.targetSite = this.getTargetSite(toSite);
            if (this.targetSite == null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), featureId);
            }
            if (this.targetSite == null) {
                sites = this.getConfiguration().getConfiguredSites();
                i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite() && sites[i].isUpdatable()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.targetSite == null) {
                sites = this.getConfiguration().getConfiguredSites();
                i = 0;
                while (i < sites.length) {
                    if (sites[i].isUpdatable()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.targetSite == null) {
                throw Utilities.newCoreException(String.valueOf(Messages.Standalone_cannotInstall) + featureId + " " + version, null);
            }
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite(NLS.bind((String)Messages.InstallCommand_site, (Object)this.remoteSiteURL.toExternalForm()), this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            VersionedIdentifier vid = new VersionedIdentifier(featureId, version);
            this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{vid}));
            this.searchRequest.addFilter(new EnvironmentFilter());
            this.searchRequest.addFilter(new BackLevelFilter());
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    @Override
    public boolean run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.Standalone_installing, 4);
            this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IInstallFeatureOperation[] operations = this.collector.getOperations();
            if (operations == null || operations.length == 0) {
                throw Utilities.newCoreException(String.valueOf(Messages.Standalone_feature) + this.featureId + " " + this.version + Messages.Standalone_notFound + this.remoteSiteURL + Messages.Standalone_newerInstalled, null);
            }
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(operations, this.getConfiguration());
            if (conflicts != null) {
                throw Utilities.newCoreException(Messages.Standalone_duplicate, null);
            }
            if (this.isVerifyOnly()) {
                if (operations == null || operations.length == 0) {
                    return false;
                }
                IStatus status = OperationsManager.getValidator().validatePendingChanges(operations);
                if (status != null && status.getCode() == 4) {
                    throw new CoreException(status);
                }
                return true;
            }
            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
            try {
                installOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 3), this);
                System.out.println(String.valueOf(Messages.Standalone_feature) + this.featureId + " " + this.version + Messages.Standalone_installed);
                return true;
            }
            catch (Exception e) {
                try {
                    throw Utilities.newCoreException(String.valueOf(Messages.Standalone_cannotInstall) + this.featureId + " " + this.version, e);
                }
                catch (CoreException ce) {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(ce);
                    return false;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return true;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private IConfiguredSite getTargetSite(String toSite) throws Exception {
        URL toSiteURL;
        ISite site;
        if (toSite == null) {
            return null;
        }
        IConfiguredSite[] configuredSites = this.getConfiguration().getConfiguredSites();
        File sitePath = new File(toSite);
        File secondaryPath = sitePath.getName().equals("eclipse") ? null : new File(sitePath, "eclipse");
        int i = 0;
        while (i < configuredSites.length) {
            IConfiguredSite csite = configuredSites[i];
            if (UpdateManagerUtils.sameURL(csite.getSite().getURL(), sitePath.toURL())) {
                return csite;
            }
            if (secondaryPath != null && UpdateManagerUtils.sameURL(csite.getSite().getURL(), secondaryPath.toURL())) {
                return csite;
            }
            ++i;
        }
        if (!sitePath.exists()) {
            sitePath.mkdirs();
        }
        if ((site = SiteManager.getSite(toSiteURL = sitePath.toURL(), null)) == null) {
            throw new Exception(String.valueOf(Messages.Standalone_noSite) + toSite);
        }
        IConfiguredSite csite = site.getCurrentConfiguredSite();
        if (csite == null) {
            csite = this.getConfiguration().createConfiguredSite(sitePath);
            IStatus status = csite.verifyUpdatableStatus();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            this.getConfiguration().addConfiguredSite(csite);
            return csite;
        }
        return csite;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        @Override
        public void accept(IFeature feature) {
            if (feature.getVersionedIdentifier().getIdentifier().equals(InstallCommand.this.featureId) && feature.getVersionedIdentifier().getVersion().toString().equals(InstallCommand.this.version)) {
                this.operations.add(OperationsManager.getOperationFactory().createInstallOperation(InstallCommand.this.targetSite, feature, null, null, null));
            }
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

