/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IConfiguredSiteChangedListener;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.UpdateUtils;

public class PatchCleaner {
    private IConfiguredSite csite;
    private SiteListener listener;

    public PatchCleaner(IConfiguredSite csite, IFeature root) {
        this.csite = csite;
        this.listener = new SiteListener();
        csite.addConfiguredSiteChangedListener(this.listener);
    }

    public void dispose() {
        this.csite.removeConfiguredSiteChangedListener(this.listener);
    }

    private void cleanSavedConfigs(IFeature feature) {
        IInstallConfiguration backupConfig;
        if (feature.isPatch() && (backupConfig = UpdateUtils.getBackupConfigurationFor(feature)) != null) {
            this.remove(backupConfig);
        }
    }

    private void remove(IInstallConfiguration config) {
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            localSite.removeFromPreservedConfigurations(config);
        }
        catch (CoreException coreException) {}
    }

    class SiteListener
    implements IConfiguredSiteChangedListener {
        SiteListener() {
        }

        @Override
        public void featureInstalled(IFeature feature) {
        }

        @Override
        public void featureRemoved(IFeature feature) {
            PatchCleaner.this.cleanSavedConfigs(feature);
        }

        @Override
        public void featureConfigured(IFeature feature) {
        }

        @Override
        public void featureUnconfigured(IFeature feature) {
            PatchCleaner.this.cleanSavedConfigs(feature);
        }
    }
}

