/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.InstallHandlerEntryModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.UpdateCore;

public class FeatureModel
extends ModelObject {
    private String featureId;
    private String featureVersion;
    private String label;
    private String localizedLabel;
    private String provider;
    private String localizedProvider;
    private String imageURLString;
    private URL imageURL;
    private String os;
    private String ws;
    private String nl;
    private String arch;
    private boolean primary = false;
    private boolean exclusive = false;
    private String primaryPluginID;
    private String application;
    private String affinity;
    private InstallHandlerEntryModel installHandler;
    private URLEntryModel description;
    private URLEntryModel copyright;
    private URLEntryModel license;
    private URLEntryModel updateSiteInfo;
    private List discoverySiteInfo;
    private List imports;
    private List pluginEntries;
    private List featureIncludes;
    private List nonPluginEntries;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureModel)) {
            return false;
        }
        FeatureModel model = (FeatureModel)((Object)obj);
        return this.featureId.toLowerCase().equals(model.getFeatureIdentifier()) && this.featureVersion.toLowerCase().equals(model.getFeatureVersion());
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public String getLabel() {
        this.delayedResolve();
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public String getProvider() {
        this.delayedResolve();
        if (this.localizedProvider != null) {
            return this.localizedProvider;
        }
        return this.provider;
    }

    public String getProviderNonLocalized() {
        return this.provider;
    }

    public String getImageURLString() {
        this.delayedResolve();
        return this.imageURLString;
    }

    public URL getImageURL() {
        this.delayedResolve();
        return this.imageURL;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getApplication() {
        return this.application;
    }

    public String getAffinityFeature() {
        return this.affinity;
    }

    public InstallHandlerEntryModel getInstallHandlerModel() {
        return this.installHandler;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public URLEntryModel getCopyrightModel() {
        return this.copyright;
    }

    public URLEntryModel getLicenseModel() {
        return this.license;
    }

    public URLEntryModel getUpdateSiteEntryModel() {
        return this.updateSiteInfo;
    }

    public URLEntryModel[] getDiscoverySiteEntryModels() {
        if (this.discoverySiteInfo == null || this.discoverySiteInfo.size() == 0) {
            return new URLEntryModel[0];
        }
        return (URLEntryModel[])this.discoverySiteInfo.toArray(this.arrayTypeFor(this.discoverySiteInfo));
    }

    public ImportModel[] getImportModels() {
        if (this.imports == null || this.imports.size() == 0) {
            return new ImportModel[0];
        }
        return (ImportModel[])this.imports.toArray(this.arrayTypeFor(this.imports));
    }

    public PluginEntryModel[] getPluginEntryModels() {
        if (this.pluginEntries == null || this.pluginEntries.size() == 0) {
            return new PluginEntryModel[0];
        }
        return (PluginEntryModel[])this.pluginEntries.toArray(this.arrayTypeFor(this.pluginEntries));
    }

    public VersionedIdentifier[] getFeatureIncludeVersionedIdentifier() {
        if (this.featureIncludes == null) {
            return new VersionedIdentifier[0];
        }
        Iterator iter = this.featureIncludes.iterator();
        VersionedIdentifier[] versionIncluded = new VersionedIdentifier[this.featureIncludes.size()];
        int index = 0;
        while (iter.hasNext()) {
            IncludedFeatureReferenceModel model = (IncludedFeatureReferenceModel)iter.next();
            versionIncluded[index] = model.getVersionedIdentifier();
            ++index;
        }
        return versionIncluded;
    }

    public IIncludedFeatureReference[] getFeatureIncluded() {
        if (this.featureIncludes == null || this.featureIncludes.size() == 0) {
            return new IIncludedFeatureReference[0];
        }
        return (IIncludedFeatureReference[])this.featureIncludes.toArray(this.arrayTypeFor(this.featureIncludes));
    }

    public NonPluginEntryModel[] getNonPluginEntryModels() {
        if (this.nonPluginEntries == null || this.nonPluginEntries.size() == 0) {
            return new NonPluginEntryModel[0];
        }
        return (NonPluginEntryModel[])this.nonPluginEntries.toArray(this.arrayTypeFor(this.nonPluginEntries));
    }

    public void setFeatureIdentifier(String featureId) {
        this.assertIsWriteable();
        this.featureId = featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.assertIsWriteable();
        this.featureVersion = featureVersion;
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
        this.localizedLabel = null;
    }

    public void setProvider(String provider) {
        this.assertIsWriteable();
        this.provider = provider;
        this.localizedProvider = null;
    }

    public void setImageURLString(String imageURLString) {
        this.assertIsWriteable();
        this.imageURLString = imageURLString;
        this.imageURL = null;
    }

    public void setOS(String os) {
        this.assertIsWriteable();
        this.os = os;
    }

    public void setWS(String ws) {
        this.assertIsWriteable();
        this.ws = ws;
    }

    public void setNL(String nl) {
        this.assertIsWriteable();
        this.nl = nl;
    }

    public void setArch(String arch) {
        this.assertIsWriteable();
        this.arch = arch;
    }

    public void setPrimary(boolean primary) {
        this.assertIsWriteable();
        this.primary = primary;
    }

    public void setExclusive(boolean exclusive) {
        this.assertIsWriteable();
        this.exclusive = exclusive;
    }

    public void setApplication(String application) {
        this.assertIsWriteable();
        this.application = application;
    }

    public void setAffinityFeature(String affinity) {
        this.assertIsWriteable();
        this.affinity = affinity;
    }

    public void setInstallHandlerModel(InstallHandlerEntryModel installHandler) {
        this.assertIsWriteable();
        this.installHandler = installHandler;
    }

    public void setDescriptionModel(URLEntryModel description) {
        this.assertIsWriteable();
        this.description = description;
    }

    public void setCopyrightModel(URLEntryModel copyright) {
        this.assertIsWriteable();
        this.copyright = copyright;
    }

    public void setLicenseModel(URLEntryModel license) {
        this.assertIsWriteable();
        this.license = license;
    }

    public void setUpdateSiteEntryModel(URLEntryModel updateSiteInfo) {
        this.assertIsWriteable();
        this.updateSiteInfo = updateSiteInfo;
    }

    public void setDiscoverySiteEntryModels(URLEntryModel[] discoverySiteInfo) {
        this.assertIsWriteable();
        this.discoverySiteInfo = discoverySiteInfo == null ? null : new ArrayList(Arrays.asList(discoverySiteInfo));
    }

    public void setImportModels(ImportModel[] imports) {
        this.assertIsWriteable();
        this.imports = imports == null ? null : new ArrayList(Arrays.asList(imports));
    }

    public void setPluginEntryModels(PluginEntryModel[] pluginEntries) {
        this.assertIsWriteable();
        this.pluginEntries = pluginEntries == null ? null : new ArrayList(Arrays.asList(pluginEntries));
    }

    public void setNonPluginEntryModels(NonPluginEntryModel[] nonPluginEntries) {
        this.assertIsWriteable();
        this.nonPluginEntries = nonPluginEntries == null ? null : new ArrayList(Arrays.asList(nonPluginEntries));
    }

    public void addDiscoverySiteEntryModel(URLEntryModel discoverySiteInfo) {
        this.assertIsWriteable();
        if (this.discoverySiteInfo == null) {
            this.discoverySiteInfo = new ArrayList();
        }
        if (!this.discoverySiteInfo.contains((Object)discoverySiteInfo)) {
            this.discoverySiteInfo.add(discoverySiteInfo);
        }
    }

    public void addImportModel(ImportModel importEntry) {
        this.assertIsWriteable();
        if (this.imports == null) {
            this.imports = new ArrayList();
        }
        if (!this.imports.contains((Object)importEntry)) {
            this.imports.add(importEntry);
        }
    }

    public void addPluginEntryModel(PluginEntryModel pluginEntry) {
        this.assertIsWriteable();
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(pluginEntry);
    }

    public void addIncludedFeatureReferenceModel(IncludedFeatureReferenceModel include) {
        this.assertIsWriteable();
        if (this.featureIncludes == null) {
            this.featureIncludes = new ArrayList();
        }
        this.featureIncludes.add(new IncludedFeatureReference(include));
    }

    public void addNonPluginEntryModel(NonPluginEntryModel nonPluginEntry) {
        this.assertIsWriteable();
        if (this.nonPluginEntries == null) {
            this.nonPluginEntries = new ArrayList();
        }
        this.nonPluginEntries.add(nonPluginEntry);
    }

    public void removeDiscoverySiteEntryModel(URLEntryModel discoverySiteInfo) {
        this.assertIsWriteable();
        if (this.discoverySiteInfo != null) {
            this.discoverySiteInfo.remove((Object)discoverySiteInfo);
        }
    }

    public void removeImportModel(ImportModel importEntry) {
        this.assertIsWriteable();
        if (this.imports != null) {
            this.imports.remove((Object)importEntry);
        }
    }

    public void removePluginEntryModel(PluginEntryModel pluginEntry) {
        this.assertIsWriteable();
        if (this.pluginEntries != null) {
            this.pluginEntries.remove((Object)pluginEntry);
        }
    }

    public void removeNonPluginEntryModel(NonPluginEntryModel nonPluginEntry) {
        this.assertIsWriteable();
        if (this.nonPluginEntries != null) {
            this.nonPluginEntries.remove((Object)nonPluginEntry);
        }
    }

    @Override
    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
        this.markReferenceReadOnly(this.getCopyrightModel());
        this.markReferenceReadOnly(this.getLicenseModel());
        this.markReferenceReadOnly(this.getUpdateSiteEntryModel());
        this.markListReferenceReadOnly(this.getDiscoverySiteEntryModels());
        this.markListReferenceReadOnly(this.getImportModels());
        this.markListReferenceReadOnly(this.getPluginEntryModels());
        this.markListReferenceReadOnly(this.getNonPluginEntryModels());
    }

    @Override
    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.bundleURL = bundleURL;
        this.base = base;
        this.resolveListReference(this.getPluginEntryModels(), base, bundleURL);
        this.resolveListReference(this.getNonPluginEntryModels(), base, bundleURL);
        this.resolveReference(this.getDescriptionModel(), base, bundleURL);
        this.resolveReference(this.getCopyrightModel(), base, bundleURL);
        this.resolveReference(this.getLicenseModel(), base, bundleURL);
        this.resolveReference(this.getUpdateSiteEntryModel(), base, bundleURL);
        this.resolveListReference(this.getDiscoverySiteEntryModels(), base, bundleURL);
        this.resolveListReference(this.getImportModels(), base, bundleURL);
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.localizedLabel = this.resolveNLString(this.bundleURL, this.label);
        this.localizedProvider = this.resolveNLString(this.bundleURL, this.provider);
        try {
            this.imageURL = this.resolveURL(this.base, this.bundleURL, this.imageURLString);
            this.resolved = true;
        }
        catch (MalformedURLException e) {
            UpdateCore.warn("", e);
        }
    }

    public void setPrimaryPluginID(String plugin) {
        if (this.primary && this.primaryPluginID == null) {
            this.primaryPluginID = this.featureId;
        }
        this.primaryPluginID = plugin;
    }

    public String getPrimaryPluginID() {
        return this.primaryPluginID;
    }

    public boolean isPatch() {
        ImportModel[] imports = this.getImportModels();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

