/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    static PrinterData[] printerList;
    PrinterData data;
    long printer;
    long printJob;
    long settings;
    long pageSetup;
    long surface;
    long cairo;
    boolean isGCCreated = false;
    Font systemFont;
    static byte[] settingsData;
    static int start;
    static int end;
    static final String GTK_LPR_BACKEND = "GtkPrintBackendLpr";
    static boolean disablePrinting;

    static {
        disablePrinting = System.getProperty("org.eclipse.swt.internal.gtk.disablePrinting") != null;
    }

    public static PrinterData[] getPrinterList() {
        Callback printerCallback;
        long GtkPrinterFunc_List;
        printerList = new PrinterData[0];
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            return printerList;
        }
        if (!OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        OS.gtk_set_locale();
        if (!OS.gtk_init_check(new long[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if ((GtkPrinterFunc_List = (printerCallback = new Callback(Printer.class, "GtkPrinterFunc_List", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(GtkPrinterFunc_List, 0L, 0L, true);
        printerCallback.dispose();
        return printerList;
    }

    static long GtkPrinterFunc_List(long printer, long user_data) {
        int length = printerList.length;
        PrinterData[] newList = new PrinterData[length + 1];
        System.arraycopy(printerList, 0, newList, 0, length);
        printerList = newList;
        Printer.printerList[length] = Printer.printerDataFromGtkPrinter(printer);
        if (Printer.printerList[length].driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    public static PrinterData getDefaultPrinterData() {
        Callback printerCallback;
        long GtkPrinterFunc_Default;
        printerList = new PrinterData[1];
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            return null;
        }
        if (!OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        OS.gtk_set_locale();
        if (!OS.gtk_init_check(new long[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if ((GtkPrinterFunc_Default = (printerCallback = new Callback(Printer.class, "GtkPrinterFunc_Default", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(GtkPrinterFunc_Default, 0L, 0L, true);
        printerCallback.dispose();
        return printerList[0];
    }

    static long GtkPrinterFunc_Default(long printer, long user_data) {
        if (OS.gtk_printer_is_default(printer)) {
            Printer.printerList[0] = Printer.printerDataFromGtkPrinter(printer);
            return 1L;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && Printer.printerDataFromGtkPrinter((long)printer).driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    long gtkPrinterFromPrinterData() {
        Callback printerCallback = new Callback(this, "GtkPrinterFunc_FindNamedPrinter", 2);
        long GtkPrinterFunc_FindNamedPrinter = printerCallback.getAddress();
        if (GtkPrinterFunc_FindNamedPrinter == 0L) {
            SWT.error(3);
        }
        this.printer = 0L;
        OS.gtk_enumerate_printers(GtkPrinterFunc_FindNamedPrinter, 0L, 0L, true);
        printerCallback.dispose();
        return this.printer;
    }

    long GtkPrinterFunc_FindNamedPrinter(long printer, long user_data) {
        PrinterData pd = Printer.printerDataFromGtkPrinter(printer);
        if (pd.driver.equals(this.data.driver) && pd.name.equals(this.data.name)) {
            this.printer = printer;
            OS.g_object_ref(printer);
            return 1L;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && pd.driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    static PrinterData printerDataFromGtkPrinter(long printer) {
        long backend = OS.gtk_printer_get_backend(printer);
        long address = OS.G_OBJECT_TYPE_NAME(backend);
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, (long)length);
        String backendType = new String(Converter.mbcsToWcs(null, buffer));
        address = OS.gtk_printer_get_name(printer);
        length = OS.strlen(address);
        buffer = new byte[length];
        OS.memmove(buffer, address, (long)length);
        String name = new String(Converter.mbcsToWcs(null, buffer));
        return new PrinterData(backendType, name);
    }

    static void restore(byte[] data, long settings, long page_setup) {
        settingsData = data;
        end = 0;
        start = 0;
        while (end < settingsData.length && settingsData[end] != 0) {
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] keyBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] valueBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, valueBuffer, 0, valueBuffer.length);
            OS.gtk_print_settings_set(settings, keyBuffer, valueBuffer);
            if (!DEBUG) continue;
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, keyBuffer))) + ": " + new String(Converter.mbcsToWcs(null, valueBuffer)));
        }
        ++end;
        OS.gtk_page_setup_set_orientation(page_setup, Printer.restoreInt("orientation"));
        OS.gtk_page_setup_set_top_margin(page_setup, Printer.restoreDouble("top_margin"), 3);
        OS.gtk_page_setup_set_bottom_margin(page_setup, Printer.restoreDouble("bottom_margin"), 3);
        OS.gtk_page_setup_set_left_margin(page_setup, Printer.restoreDouble("left_margin"), 3);
        OS.gtk_page_setup_set_right_margin(page_setup, Printer.restoreDouble("right_margin"), 3);
        byte[] name = Printer.restoreBytes("paper_size_name", true);
        byte[] display_name = Printer.restoreBytes("paper_size_display_name", true);
        byte[] ppd_name = Printer.restoreBytes("paper_size_ppd_name", true);
        double width = Printer.restoreDouble("paper_size_width");
        double height = Printer.restoreDouble("paper_size_height");
        boolean custom = Printer.restoreBoolean("paper_size_is_custom");
        long paper_size = 0L;
        paper_size = custom ? (ppd_name.length > 0 ? OS.gtk_paper_size_new_from_ppd(ppd_name, display_name, width, height) : OS.gtk_paper_size_new_custom(name, display_name, width, height, 3)) : OS.gtk_paper_size_new(name);
        OS.gtk_page_setup_set_paper_size(page_setup, paper_size);
        OS.gtk_paper_size_free(paper_size);
    }

    static void setScope(long settings, int scope, int startPage, int endPage) {
        switch (scope) {
            case 0: {
                OS.gtk_print_settings_set_print_pages(settings, 0);
                break;
            }
            case 1: {
                OS.gtk_print_settings_set_print_pages(settings, 2);
                int[] pageRange = new int[]{startPage - 1, endPage - 1};
                OS.gtk_print_settings_set_page_ranges(settings, pageRange, 1);
                break;
            }
            case 2: {
                OS.gtk_print_settings_set_print_pages(settings, 0);
            }
        }
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            PrinterData defaultPrinter = Printer.getDefaultPrinterData();
            if (defaultPrinter == null) {
                SWT.error(2);
            }
            data.driver = defaultPrinter.driver;
            data.name = defaultPrinter.name;
        }
        return data;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    static int restoreInt(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Integer.parseInt(new String(value));
    }

    static double restoreDouble(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Double.parseDouble(new String(value));
    }

    static boolean restoreBoolean(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Boolean.valueOf(new String(value));
    }

    static byte[] restoreBytes(String key, boolean nullTerminate) {
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        byte[] keyBuffer = new byte[++end - start];
        System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        int length = end - start;
        ++end;
        if (nullTerminate) {
            ++length;
        }
        byte[] valueBuffer = new byte[length];
        System.arraycopy(settingsData, start, valueBuffer, 0, length);
        if (DEBUG) {
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, keyBuffer))) + ": " + new String(Converter.mbcsToWcs(null, valueBuffer)));
        }
        return valueBuffer;
    }

    @Override
    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        long style = OS.gtk_widget_get_default_style();
        long defaultFont = OS.pango_font_description_copy(OS.gtk_style_get_font_desc(style));
        this.systemFont = Font.gtk_new(this, defaultFont);
        return this.systemFont;
    }

    @Override
    public long internal_new_GC(GCData data) {
        long drawable = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), 1, 1, 1);
        long gdkGC = OS.gdk_gc_new(drawable);
        if (gdkGC == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((data.style & (mask = 0x6000000)) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = drawable;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
            data.width = (int)OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
            data.height = (int)OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
            if (this.cairo == 0L) {
                SWT.error(2);
            }
            data.cairo = this.cairo;
            this.isGCCreated = true;
        }
        return gdkGC;
    }

    @Override
    public void internal_dispose_GC(long gdkGC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
        OS.g_object_unref(gdkGC);
        if (data != null) {
            if (data.drawable != 0L) {
                OS.g_object_unref(data.drawable);
            }
            data.cairo = 0L;
            data.drawable = 0L;
        }
    }

    @Override
    protected void release() {
        super.release();
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        byte[] buffer = Converter.wcsToMbcs(null, jobName, true);
        this.printJob = OS.gtk_print_job_new(buffer, this.printer, this.settings, this.pageSetup);
        if (this.printJob == 0L) {
            return false;
        }
        this.surface = OS.gtk_print_job_get_surface(this.printJob, null);
        if (this.surface == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        return true;
    }

    @Override
    protected void destroy() {
        if (this.printer != 0L) {
            OS.g_object_unref(this.printer);
        }
        if (this.settings != 0L) {
            OS.g_object_unref(this.settings);
        }
        if (this.pageSetup != 0L) {
            OS.g_object_unref(this.pageSetup);
        }
        if (this.cairo != 0L) {
            Cairo.cairo_destroy(this.cairo);
        }
        if (this.printJob != 0L) {
            OS.g_object_unref(this.printJob);
        }
        this.printJob = 0L;
        this.cairo = 0L;
        this.pageSetup = 0L;
        this.settings = 0L;
        this.printer = 0L;
    }

    public void endJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.gtk_print_job_send(this.printJob, 0L, 0L, 0L);
    }

    public void cancelJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
    }

    public boolean startPage() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return false;
        }
        double width = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double height = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        int type = Cairo.cairo_surface_get_type(this.surface);
        switch (type) {
            case 2: {
                Cairo.cairo_ps_surface_set_size(this.surface, width, height);
                break;
            }
            case 1: {
                Cairo.cairo_pdf_surface_set_size(this.surface, width, height);
            }
        }
        return true;
    }

    public void endPage() {
        this.checkDevice();
        if (this.cairo != 0L) {
            Cairo.cairo_show_page(this.cairo);
        }
    }

    @Override
    public Point getDPI() {
        this.checkDevice();
        int resolution = OS.gtk_print_settings_get_resolution(this.settings);
        if (DEBUG) {
            System.out.println("print_settings.resolution=" + resolution);
        }
        return new Point(72, 72);
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        double width = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double height = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        double width = OS.gtk_page_setup_get_page_width(this.pageSetup, 1);
        double height = OS.gtk_page_setup_get_page_height(this.pageSetup, 1);
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        double printWidth = OS.gtk_page_setup_get_page_width(this.pageSetup, 1);
        double printHeight = OS.gtk_page_setup_get_page_height(this.pageSetup, 1);
        double paperWidth = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double paperHeight = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        double printX = -OS.gtk_page_setup_get_left_margin(this.pageSetup, 1);
        double printY = -OS.gtk_page_setup_get_top_margin(this.pageSetup, 1);
        double hTrim = paperWidth - printWidth;
        double vTrim = paperHeight - printHeight;
        return new Rectangle(x + (int)printX, y + (int)printY, width + (int)hTrim, height + (int)vTrim);
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            SWT.error(2);
        }
        this.printer = this.gtkPrinterFromPrinterData();
        if (this.printer == 0L) {
            SWT.error(2);
        }
    }

    @Override
    protected void init() {
        byte[] buffer;
        super.init();
        this.settings = OS.gtk_print_settings_new();
        this.pageSetup = OS.gtk_page_setup_new();
        if (this.data.otherData != null) {
            Printer.restore(this.data.otherData, this.settings, this.pageSetup);
        }
        Printer.setScope(this.settings, this.data.scope, this.data.startPage, this.data.endPage);
        if (this.data.printToFile) {
            buffer = Converter.wcsToMbcs(null, this.data.fileName, true);
            OS.gtk_print_settings_set(this.settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, buffer);
        }
        if (this.data.driver.equals("GtkPrintBackendFile") && this.data.name.equals("Print to File")) {
            buffer = Converter.wcsToMbcs(null, this.data.fileName, true);
            OS.gtk_print_settings_set(this.settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, buffer);
        }
        OS.gtk_print_settings_set_n_copies(this.settings, this.data.copyCount);
        OS.gtk_print_settings_set_collate(this.settings, this.data.collate);
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

