/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.help.IAnchor;
import org.eclipse.help.ICommandLink;
import org.eclipse.help.IContentExtension;
import org.eclipse.help.IContext;
import org.eclipse.help.IInclude;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.ILink;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.Anchor;
import org.eclipse.help.internal.CommandLink;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.Include;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.extension.ContentExtension;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.toc.Link;
import org.eclipse.help.internal.toc.Toc;
import org.w3c.dom.Element;

public class UAElementFactory {
    private static final Class[][] interfaceTable = new Class[][]{{ITopic.class, Topic.class}, {IIndexEntry.class, IndexEntry.class}, {IContext.class, Context.class}, {IAnchor.class, Anchor.class}, {IInclude.class, Include.class}, {ILink.class, Link.class}, {IToc.class, Toc.class}, {ICommandLink.class, CommandLink.class}, {IIndex.class, Index.class}, {IContentExtension.class, ContentExtension.class}};
    private static final Map classByElementName = Collections.synchronizedMap(new HashMap());

    static {
        classByElementName.put("anchor", Anchor.class);
        classByElementName.put("include", Include.class);
        classByElementName.put("toc", Toc.class);
        classByElementName.put("topic", Topic.class);
        classByElementName.put("index", Index.class);
        classByElementName.put("entry", IndexEntry.class);
        classByElementName.put("context", Context.class);
        classByElementName.put("command", CommandLink.class);
        classByElementName.put("link", Link.class);
        classByElementName.put("contribution", ContentExtension.class);
        classByElementName.put("topicExtension", ContentExtension.class);
        classByElementName.put("replacement", ContentExtension.class);
        classByElementName.put("topicReplace", ContentExtension.class);
    }

    public static UAElement newElement(Element element) {
        String name = element.getNodeName();
        Class clazz = (Class)classByElementName.get(name);
        if (clazz != null) {
            try {
                Constructor constructor = clazz.getConstructor(Element.class);
                return (UAElement)constructor.newInstance(element);
            }
            catch (Exception e) {
                String msg = "Error creating document model element";
                HelpPlugin.logError(msg, e);
            }
        }
        return new UAElement(element);
    }

    public static UAElement newElement(IUAElement src) {
        int i = 0;
        while (i < interfaceTable.length) {
            Class interfaze = interfaceTable[i][0];
            Class clazz = interfaceTable[i][1];
            if (interfaze.isAssignableFrom(src.getClass())) {
                try {
                    Constructor constructor = clazz.getConstructor(interfaze);
                    return (UAElement)constructor.newInstance(src);
                }
                catch (Exception e) {
                    String msg = "Error creating document model element";
                    HelpPlugin.logError(msg, e);
                }
            }
            ++i;
        }
        return null;
    }
}

