/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.registry.PreferenceTransferRegistryReader;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferenceTransferElement
extends WorkbenchAdapter
implements IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private IConfigurationElement configurationElement;
    private IPreferenceFilter filter;

    public PreferenceTransferElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.id = configurationElement.getAttribute("id");
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IPreferenceFilter getFilter() throws CoreException {
        if (this.filter == null) {
            IConfigurationElement[] mappings = PreferenceTransferRegistryReader.getMappings(this.configurationElement);
            PreferenceFilter prefFilter = new PreferenceFilter();
            prefFilter.scopes = new String[mappings.length];
            prefFilter.maps = new Map[mappings.length];
            int i = 0;
            while (i < mappings.length) {
                prefFilter.scopes[i] = PreferenceTransferRegistryReader.getScope(mappings[i]);
                prefFilter.maps[i] = PreferenceTransferRegistryReader.getEntry(mappings[i]);
                ++i;
            }
            this.filter = prefFilter;
        }
        return this.filter;
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.configurationElement);
    }

    public String getID() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconName = this.configurationElement.getAttribute("icon");
            if (iconName == null) {
                return null;
            }
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespace(), iconName);
        }
        return this.imageDescriptor;
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    @Override
    public String getLocalId() {
        return this.getID();
    }

    @Override
    public String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getNamespace() : null;
    }

    class PreferenceFilter
    implements IPreferenceFilter {
        protected String[] scopes;
        protected Map[] maps;

        PreferenceFilter() {
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public Map getMapping(String scope) {
            int i = 0;
            while (i < this.scopes.length) {
                String item = this.scopes[i];
                if (item.equals(scope)) {
                    return this.maps[i];
                }
                ++i;
            }
            return null;
        }
    }
}

