/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;

public class BidirectionalMap
extends ObservableMap {
    private Map valueToElements = new HashMap();
    private IMapChangeListener mapListener = new IMapChangeListener(){

        @Override
        public void handleMapChange(MapChangeEvent event) {
            MapDiff diff = event.diff;
            for (Object addedKey : diff.getAddedKeys()) {
                BidirectionalMap.this.addMapping(addedKey, diff.getNewValue(addedKey));
            }
            for (Object changedKey : diff.getChangedKeys()) {
                BidirectionalMap.this.removeMapping(changedKey, diff.getOldValue(changedKey));
                BidirectionalMap.this.addMapping(changedKey, diff.getNewValue(changedKey));
            }
            for (Object removedKey : diff.getRemovedKeys()) {
                BidirectionalMap.this.removeMapping(removedKey, diff.getOldValue(removedKey));
            }
            BidirectionalMap.this.fireMapChange(diff);
        }
    };

    public BidirectionalMap(IObservableMap wrappedMap) {
        super(wrappedMap.getRealm(), wrappedMap);
        wrappedMap.addMapChangeListener(this.mapListener);
        for (Map.Entry entry : wrappedMap.entrySet()) {
            this.addMapping(entry.getKey(), entry.getValue());
        }
    }

    private void addMapping(Object key, Object value) {
        Object elementOrSet = this.valueToElements.get(value);
        if (elementOrSet == null) {
            this.valueToElements.put(value, key);
            return;
        }
        if (!(elementOrSet instanceof Set)) {
            elementOrSet = new HashSet(Collections.singleton(elementOrSet));
            this.valueToElements.put(value, elementOrSet);
        }
        Set set = (Set)elementOrSet;
        set.add(key);
    }

    private void removeMapping(Object functionValue, Object element) {
        Object elementOrSet = this.valueToElements.get(functionValue);
        if (elementOrSet instanceof Set) {
            Set set = (Set)elementOrSet;
            set.remove(element);
            if (set.size() == 0) {
                this.valueToElements.remove(functionValue);
            }
        } else {
            this.valueToElements.remove(functionValue);
        }
    }
}

