/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;

public abstract class ObservableList
extends AbstractObservable
implements IObservableList {
    protected List wrappedList;
    private boolean stale = false;
    private Object elementType;

    protected ObservableList(List wrappedList, Object elementType) {
        this(Realm.getDefault(), wrappedList, elementType);
    }

    protected ObservableList(Realm realm, List wrappedList, Object elementType) {
        super(realm);
        this.wrappedList = wrappedList;
        this.elementType = elementType;
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener listener) {
        this.addListener(ListChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener listener) {
        this.removeListener(ListChangeEvent.TYPE, listener);
    }

    protected void fireListChange(ListDiff diff) {
        super.fireChange();
        this.fireEvent(new ListChangeEvent(this, diff));
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        this.getterCalled();
        return this.wrappedList.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        this.getterCalled();
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            return this.wrappedList.equals(((ObservableList)o).wrappedList);
        }
        return this.wrappedList.equals(o);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrappedList.hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedList.isEmpty();
    }

    @Override
    public Iterator iterator() {
        this.getterCalled();
        final Iterator wrappedIterator = this.wrappedList.iterator();
        return new Iterator(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            public Object next() {
                return wrappedIterator.next();
            }
        };
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrappedList.size();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return this.wrappedList.toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.wrappedList.toString();
    }

    @Override
    public Object get(int index) {
        this.getterCalled();
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        this.getterCalled();
        final ListIterator wrappedIterator = this.wrappedList.listIterator(index);
        return new ListIterator(){

            @Override
            public int nextIndex() {
                return wrappedIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return wrappedIterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return wrappedIterator.hasPrevious();
            }

            @Override
            public Object next() {
                return wrappedIterator.next();
            }

            public Object previous() {
                return wrappedIterator.previous();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List subList(final int fromIndex, final int toIndex) {
        this.getterCalled();
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractObservableList(this.getRealm()){

            @Override
            public Object getElementType() {
                return ObservableList.this.getElementType();
            }

            @Override
            public Object get(int location) {
                return ObservableList.this.get(fromIndex + location);
            }

            @Override
            protected int doGetSize() {
                return toIndex - fromIndex;
            }
        };
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        int size = this.wrappedList.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        Object element = this.remove(oldIndex);
        this.add(newIndex, element);
        return element;
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    protected void updateWrappedList(List newList) {
        List oldList = this.wrappedList;
        ListDiff listDiff = Diffs.computeListDiff(oldList, newList);
        this.wrappedList = newList;
        this.fireListChange(listDiff);
    }
}

