/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.internal.databinding.Pair;

public class ObservablesManager {
    private Set managedObservables = new HashSet();
    private Set excludedObservables = new HashSet();
    private Map contexts = new HashMap();

    public void addObservable(IObservable observable) {
        this.managedObservables.add(observable);
    }

    public void excludeObservable(IObservable observable) {
        this.excludedObservables.add(observable);
    }

    public void addObservablesFromContext(DataBindingContext context, boolean trackTargets, boolean trackModels) {
        if (trackTargets || trackModels) {
            this.contexts.put(context, new Pair(new Boolean(trackTargets), new Boolean(trackModels)));
        }
    }

    public void dispose() {
        HashSet<IObservable> observables = new HashSet<IObservable>();
        observables.addAll(this.managedObservables);
        for (DataBindingContext context : this.contexts.keySet()) {
            Pair trackModelsOrTargets = (Pair)this.contexts.get(context);
            boolean disposeTargets = (Boolean)trackModelsOrTargets.a;
            boolean disposeModels = (Boolean)trackModelsOrTargets.b;
            for (Binding binding : context.getBindings()) {
                if (disposeTargets) {
                    observables.add(binding.getTarget());
                }
                if (!disposeModels) continue;
                observables.add(binding.getModel());
            }
        }
        observables.removeAll(this.excludedObservables);
        for (IObservable observable : observables) {
            observable.dispose();
        }
    }
}

