/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher;

import java.util.GregorianCalendar;

public class SearchCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 1359395776008306016L;

    public boolean checkDate() {
        if (this.get(5) > this.getActualMaximum(5)) {
            return false;
        }
        if (this.get(5) < this.getActualMinimum(5)) {
            return false;
        }
        if (this.get(2) > this.getActualMaximum(2)) {
            return false;
        }
        return this.get(2) >= this.getActualMinimum(2);
    }

    public void setToday() {
        SearchCalendar cal = new SearchCalendar();
        this.set(cal.get(1), cal.get(2), cal.get(5));
    }

    public void setBeginTime() {
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
    }

    public void setEndTime() {
        this.set(11, 23);
        this.set(12, 59);
        this.set(13, 59);
    }

    public void setLastOneMonth() {
        this.setLastMonthStart(1);
    }

    public void setLastOneWeek() {
        this.setLastWeekStart(1);
    }

    public void setLastYear(int year) {
        this.setToday();
        this.add(1, -1 * year);
    }

    public void setLastMonthStart(int month) {
        this.setToday();
        int dofm = this.get(5);
        this.add(5, -1 * (dofm - 1));
        this.add(2, -1 * month);
    }

    public void setLastMonthEnd(int month) {
        this.setToday();
        this.setLastMonthStart(month);
        int max = this.getActualMaximum(5);
        this.add(5, max - 1);
    }

    public void setLastWeekStart(int week) {
        this.setToday();
        int dofw = this.get(7);
        int fdow = this.getFirstDayOfWeek();
        int diff = dofw < fdow ? 7 - (fdow - dofw) : dofw - fdow;
        this.add(5, -7 * week - 1 * diff);
    }

    public void setLastWeekEnd(int week) {
        this.setToday();
        this.setLastWeekStart(week);
        this.add(5, 6);
    }

    public void setLastDay(int day) {
        this.setToday();
        this.add(5, -1 * day);
    }
}

