/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.opengl.glx.GLX;
import org.eclipse.swt.internal.opengl.glx.XVisualInfo;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int context;
    int xWindow;
    int glWindow;
    XVisualInfo vinfo;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, style);
        if (data == null) {
            SWT.error(4);
        }
        int[] glxAttrib = new int[32];
        int pos = 0;
        glxAttrib[pos++] = 4;
        if (data.doubleBuffer) {
            glxAttrib[pos++] = 5;
        }
        if (data.stereo) {
            glxAttrib[pos++] = 6;
        }
        if (data.redSize > 0) {
            glxAttrib[pos++] = 8;
            glxAttrib[pos++] = data.redSize;
        }
        if (data.greenSize > 0) {
            glxAttrib[pos++] = 9;
            glxAttrib[pos++] = data.greenSize;
        }
        if (data.blueSize > 0) {
            glxAttrib[pos++] = 10;
            glxAttrib[pos++] = data.blueSize;
        }
        if (data.alphaSize > 0) {
            glxAttrib[pos++] = 11;
            glxAttrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            glxAttrib[pos++] = 12;
            glxAttrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            glxAttrib[pos++] = 13;
            glxAttrib[pos++] = data.stencilSize;
        }
        if (data.accumRedSize > 0) {
            glxAttrib[pos++] = 14;
            glxAttrib[pos++] = data.accumRedSize;
        }
        if (data.accumGreenSize > 0) {
            glxAttrib[pos++] = 15;
            glxAttrib[pos++] = data.accumGreenSize;
        }
        if (data.accumBlueSize > 0) {
            glxAttrib[pos++] = 16;
            glxAttrib[pos++] = data.accumBlueSize;
        }
        if (data.accumAlphaSize > 0) {
            glxAttrib[pos++] = 17;
            glxAttrib[pos++] = data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            glxAttrib[pos++] = 100000;
            glxAttrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            glxAttrib[pos++] = 100001;
            glxAttrib[pos++] = data.samples;
        }
        glxAttrib[pos++] = 0;
        OS.gtk_widget_realize(this.handle);
        int window = OS.GTK_WIDGET_WINDOW(this.handle);
        int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
        int infoPtr = GLX.glXChooseVisual(xDisplay, OS.XDefaultScreen(xDisplay), glxAttrib);
        if (infoPtr == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.vinfo = new XVisualInfo();
        GLX.memmove(this.vinfo, infoPtr, XVisualInfo.sizeof);
        OS.XFree(infoPtr);
        int screen = OS.gdk_screen_get_default();
        int gdkvisual = OS.gdk_x11_screen_lookup_visual(screen, this.vinfo.visualid);
        this.context = GLX.glXCreateContext(xDisplay, this.vinfo, 0, true);
        if (this.context == 0) {
            SWT.error(2);
        }
        GdkWindowAttr attrs = new GdkWindowAttr();
        attrs.width = 1;
        attrs.height = 1;
        attrs.event_mask = 163598;
        attrs.window_type = 2;
        attrs.visual = gdkvisual;
        this.glWindow = OS.gdk_window_new(window, attrs, 64);
        OS.gdk_window_set_user_data(this.glWindow, this.handle);
        if ((style & 0x40000) != 0) {
            OS.gdk_window_set_back_pixmap(window, 0, false);
        }
        this.xWindow = OS.gdk_x11_drawable_get_xid(this.glWindow);
        OS.gdk_window_show(this.glWindow);
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        int[] viewport = new int[4];
                        GLX.glGetIntegerv(2978, viewport);
                        GLX.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
                        break;
                    }
                    case 11: {
                        Rectangle clientArea = GLCanvas.this.getClientArea();
                        OS.gdk_window_move(GLCanvas.this.glWindow, clientArea.x, clientArea.y);
                        OS.gdk_window_resize(GLCanvas.this.glWindow, clientArea.width, clientArea.height);
                        break;
                    }
                    case 12: {
                        int window = OS.GTK_WIDGET_WINDOW(GLCanvas.this.handle);
                        int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
                        if (GLCanvas.this.context != 0) {
                            if (GLX.glXGetCurrentContext() == GLCanvas.this.context) {
                                GLX.glXMakeCurrent(xDisplay, 0, 0);
                            }
                            GLX.glXDestroyContext(xDisplay, GLCanvas.this.context);
                            GLCanvas.this.context = 0;
                        }
                        if (GLCanvas.this.glWindow == 0) break;
                        OS.gdk_window_destroy(GLCanvas.this.glWindow);
                        GLCanvas.this.glWindow = 0;
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        int window = OS.GTK_WIDGET_WINDOW(this.handle);
        int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
        GLData data = new GLData();
        int[] value = new int[1];
        GLX.glXGetConfig(xDisplay, this.vinfo, 5, value);
        data.doubleBuffer = value[0] != 0;
        GLX.glXGetConfig(xDisplay, this.vinfo, 6, value);
        data.stereo = value[0] != 0;
        GLX.glXGetConfig(xDisplay, this.vinfo, 8, value);
        data.redSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 9, value);
        data.greenSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 10, value);
        data.blueSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 11, value);
        data.alphaSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 12, value);
        data.depthSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 13, value);
        data.stencilSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 14, value);
        data.accumRedSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 15, value);
        data.accumGreenSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 16, value);
        data.accumBlueSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 17, value);
        data.accumAlphaSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 100000, value);
        data.sampleBuffers = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 100001, value);
        data.samples = value[0];
        return data;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return GLX.glXGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (GLX.glXGetCurrentContext() == this.context) {
            return;
        }
        int window = OS.GTK_WIDGET_WINDOW(this.handle);
        int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
        GLX.glXMakeCurrent(xDisplay, this.xWindow, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        int window = OS.GTK_WIDGET_WINDOW(this.handle);
        int xDisplay = OS.gdk_x11_drawable_get_xdisplay(window);
        GLX.glXSwapBuffers(xDisplay, this.xWindow);
    }
}

