/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Color
extends Resource {
    public GdkColor handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue);
        this.init();
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue);
        this.init();
    }

    @Override
    void destroy() {
        int pixel = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n = pixel;
            this.device.colorRefCount[n] = this.device.colorRefCount[n] - 1;
            if (this.device.colorRefCount[n] == 0) {
                this.device.gdkColors[pixel] = null;
            }
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_free_colors(colormap, this.handle, 1);
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        GdkColor gdkColor = color.handle;
        if (this.handle == gdkColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == gdkColor.red && this.handle.green == gdkColor.green && this.handle.blue == gdkColor.blue;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color gtk_new(Device device, GdkColor gdkColor) {
        Color color = new Color(device);
        color.handle = gdkColor;
        return color;
    }

    void init(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(red & 0xFF | (red & 0xFF) << 8);
        gdkColor.green = (short)(green & 0xFF | (green & 0xFF) << 8);
        gdkColor.blue = (short)(blue & 0xFF | (blue & 0xFF) << 8);
        int colormap = OS.gdk_colormap_get_system();
        if (!OS.gdk_colormap_alloc_color(colormap, gdkColor, true, true)) {
            gdkColor = new GdkColor();
            OS.gdk_colormap_alloc_color(colormap, gdkColor, true, true);
        }
        this.handle = gdkColor;
        if (this.device.colorRefCount != null) {
            GdkColor colorCopy = new GdkColor();
            colorCopy.red = this.handle.red;
            colorCopy.green = this.handle.green;
            colorCopy.blue = this.handle.blue;
            colorCopy.pixel = this.handle.pixel;
            this.device.gdkColors[colorCopy.pixel] = colorCopy;
            int n = colorCopy.pixel;
            this.device.colorRefCount[n] = this.device.colorRefCount[n] + 1;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

