/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentProcessor;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.toc.HrefUtil;

public class IndexAssembler {
    private DocumentProcessor processor;
    private Comparator comparator;
    private String locale;

    public Index assemble(List contributions, String locale) {
        this.locale = locale;
        this.process(contributions);
        Index index = this.merge(contributions);
        this.sort(index);
        return index;
    }

    private Index merge(List contributions) {
        Index index = new Index();
        for (IndexContribution contribution : contributions) {
            this.mergeChildren(index, (Index)contribution.getIndex());
            contribution.setIndex(null);
        }
        return index;
    }

    private void mergeChildren(UAElement a, UAElement b) {
        HashMap<String, UAElement> entriesByKeyword = new HashMap<String, UAElement>();
        HashSet<String> topicHrefs = new HashSet<String>();
        IUAElement[] childrenA = a.getChildren();
        int i = 0;
        while (i < childrenA.length) {
            UAElement childA = (UAElement)childrenA[i];
            if (childA instanceof IndexEntry) {
                entriesByKeyword.put(childA.getAttribute("keyword"), childA);
            } else if (childA instanceof Topic) {
                topicHrefs.add(childA.getAttribute("href"));
            }
            ++i;
        }
        IUAElement[] childrenB = b.getChildren();
        int i2 = 0;
        while (i2 < childrenB.length) {
            String href;
            UAElement childB = (UAElement)childrenB[i2];
            if (childB instanceof IndexEntry) {
                String keyword = childB.getAttribute("keyword");
                if (entriesByKeyword.containsKey(keyword)) {
                    this.mergeChildren((IndexEntry)entriesByKeyword.get(keyword), childB);
                } else {
                    a.appendChild(childB);
                    entriesByKeyword.put(keyword, childB);
                }
            } else if (childB instanceof Topic && !topicHrefs.contains(href = childB.getAttribute("href"))) {
                a.appendChild(childB);
                topicHrefs.add(href);
            }
            ++i2;
        }
    }

    private void process(List contributions) {
        if (this.processor == null) {
            DocumentReader reader = new DocumentReader();
            this.processor = new DocumentProcessor(new ProcessorHandler[]{new NormalizeHandler(), new IncludeHandler(reader, this.locale), new ExtensionHandler(reader, this.locale)});
        }
        for (IndexContribution contribution : contributions) {
            this.processor.process((Index)contribution.getIndex(), contribution.getId());
        }
    }

    private void sort(UAElement element) {
        if (this.comparator == null) {
            this.comparator = new IndexComparator();
        }
        this.sort(element, this.comparator);
    }

    private void sort(UAElement element, Comparator comparator) {
        int i;
        IUAElement[] children = element.getChildren();
        if (children.length > 1) {
            i = 0;
            while (i < children.length) {
                element.removeChild((UAElement)children[i]);
                ++i;
            }
            Arrays.sort(children, comparator);
            i = 0;
            while (i < children.length) {
                element.appendChild((UAElement)children[i]);
                ++i;
            }
        }
        i = 0;
        while (i < children.length) {
            this.sort((UAElement)children[i], comparator);
            ++i;
        }
    }

    private class IndexComparator
    implements Comparator {
        private IndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            int c2;
            int c1 = this.getCategory((UAElement)o1);
            if (c1 == (c2 = this.getCategory((UAElement)o2))) {
                String s1 = this.getLabel((UAElement)o1).toLowerCase();
                String s2 = this.getLabel((UAElement)o2).toLowerCase();
                return s1.compareTo(s2);
            }
            return c1 - c2;
        }

        private int getCategory(UAElement element) {
            if (element instanceof Topic) {
                return 0;
            }
            if (element instanceof IndexEntry) {
                String keyword = ((IndexEntry)element).getKeyword();
                if (keyword != null && keyword.length() > 0) {
                    char c = keyword.charAt(0);
                    if (Character.isDigit(c)) {
                        return 2;
                    }
                    if (Character.isLetter(c)) {
                        return 3;
                    }
                    return 1;
                }
                return 4;
            }
            return 5;
        }

        private String getLabel(UAElement element) {
            if (element instanceof Topic) {
                Topic topic = (Topic)element;
                if (topic.getLabel() == null) {
                    Topic topic2 = HelpPlugin.getTocManager().getTopic(topic.getHref(), IndexAssembler.this.locale);
                    if (topic2 != null) {
                        topic.setLabel(topic2.getLabel());
                    } else {
                        String msg = "Unable to look up label for help keyword index topic \"" + topic.getHref() + "\" with missing \"" + "label" + "\" attribute (topic does not exist in table of contents; using href as label)";
                        HelpPlugin.logError(msg);
                        topic.setLabel(topic.getHref());
                    }
                }
                return topic.getLabel();
            }
            if (element instanceof IndexEntry) {
                return ((IndexEntry)element).getKeyword();
            }
            return null;
        }
    }

    private class NormalizeHandler
    extends ProcessorHandler {
        private NormalizeHandler() {
        }

        @Override
        public short handle(UAElement element, String id) {
            int index;
            Topic topic;
            String href;
            if (element instanceof Topic && (href = (topic = (Topic)element).getHref()) != null && (index = id.indexOf(47, 1)) != -1) {
                String pluginId = id.substring(1, index);
                topic.setHref(HrefUtil.normalizeHref(pluginId, href));
            }
            return 0;
        }
    }
}

