/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.Assert;

public class CompositeMap
extends ObservableMap {
    private Map valueToElements = new HashMap();
    private Set pendingAdds = new HashSet();
    private Map pendingRemoves = new HashMap();
    private Map pendingChanges = new HashMap();
    private IMapChangeListener firstMapListener = new IMapChangeListener(){

        @Override
        public void handleMapChange(MapChangeEvent event) {
            Object oldValue;
            MapDiff diff = event.diff;
            HashSet<Object> rangeSetAdditions = new HashSet<Object>();
            HashSet<Object> rangeSetRemovals = new HashSet<Object>();
            final HashSet adds = new HashSet();
            final HashSet changes = new HashSet();
            final HashSet removes = new HashSet();
            final HashMap oldValues = new HashMap();
            for (Object addedKey : diff.getAddedKeys()) {
                Object newValue = diff.getNewValue(addedKey);
                CompositeMap.this.addMapping(addedKey, newValue);
                if (!CompositeMap.this.rangeSet.contains(newValue)) {
                    CompositeMap.this.pendingAdds.add(newValue);
                    rangeSetAdditions.add(newValue);
                    continue;
                }
                adds.add(addedKey);
                CompositeMap.this.wrappedMap.put(addedKey, CompositeMap.this.secondMap.get(newValue));
            }
            for (Object changedKey : diff.getChangedKeys()) {
                boolean added;
                oldValue = diff.getOldValue(changedKey);
                Object newValue = diff.getNewValue(changedKey);
                boolean removed = CompositeMap.this.removeMapping(changedKey, oldValue);
                CompositeMap.this.addMapping(changedKey, newValue);
                boolean bl = added = !CompositeMap.this.rangeSet.contains(newValue);
                if (removed) {
                    CompositeMap.this.pendingRemoves.put(oldValue, changedKey);
                    rangeSetRemovals.add(oldValue);
                }
                if (added) {
                    CompositeMap.this.pendingAdds.add(newValue);
                    rangeSetAdditions.add(newValue);
                }
                if (added || removed) {
                    CompositeMap.this.pendingChanges.put(oldValue, newValue);
                    CompositeMap.this.pendingChanges.put(newValue, oldValue);
                    continue;
                }
                changes.add(changedKey);
                oldValues.put(changedKey, oldValue);
                CompositeMap.this.wrappedMap.put(changedKey, CompositeMap.this.secondMap.get(newValue));
            }
            for (Object removedKey : diff.getRemovedKeys()) {
                if (CompositeMap.this.removeMapping(removedKey, oldValue = diff.getOldValue(removedKey))) {
                    CompositeMap.this.pendingRemoves.put(oldValue, removedKey);
                    rangeSetRemovals.add(oldValue);
                    continue;
                }
                removes.add(removedKey);
                oldValues.put(removedKey, CompositeMap.this.secondMap.get(oldValue));
                CompositeMap.this.wrappedMap.remove(removedKey);
            }
            if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
                CompositeMap.this.fireMapChange(new MapDiff(){

                    @Override
                    public Set getAddedKeys() {
                        return adds;
                    }

                    @Override
                    public Set getChangedKeys() {
                        return changes;
                    }

                    @Override
                    public Object getNewValue(Object key) {
                        return (this).CompositeMap.this.wrappedMap.get(key);
                    }

                    @Override
                    public Object getOldValue(Object key) {
                        return oldValues.get(key);
                    }

                    @Override
                    public Set getRemovedKeys() {
                        return removes;
                    }
                });
            }
            if (rangeSetAdditions.size() > 0 || rangeSetRemovals.size() > 0) {
                CompositeMap.this.rangeSet.addAndRemove(rangeSetAdditions, rangeSetRemovals);
            }
        }
    };
    private IMapChangeListener secondMapListener = new IMapChangeListener(){

        @Override
        public void handleMapChange(MapChangeEvent event) {
            Set elements;
            MapDiff diff = event.diff;
            final HashSet adds = new HashSet();
            final HashSet<Object> changes = new HashSet<Object>();
            final HashSet removes = new HashSet();
            final HashMap oldValues = new HashMap();
            final HashMap<Object, Object> newValues = new HashMap<Object, Object>();
            HashSet addedKeys = new HashSet(diff.getAddedKeys());
            HashSet removedKeys = new HashSet(diff.getRemovedKeys());
            for (Object addedKey : addedKeys) {
                elements = CompositeMap.this.getElementsForValue(addedKey);
                Object newValue = diff.getNewValue(addedKey);
                if (CompositeMap.this.pendingChanges.containsKey(addedKey)) {
                    Object oldKey = CompositeMap.this.pendingChanges.remove(addedKey);
                    Object oldValue = removedKeys.remove(oldKey) ? diff.getOldValue(oldKey) : CompositeMap.this.secondMap.get(oldKey);
                    CompositeMap.this.pendingChanges.remove(oldKey);
                    CompositeMap.this.pendingAdds.remove(addedKey);
                    CompositeMap.this.pendingRemoves.remove(oldKey);
                    for (Object element : elements) {
                        changes.add(element);
                        oldValues.put(element, oldValue);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                    }
                    continue;
                }
                if (CompositeMap.this.pendingAdds.remove(addedKey)) {
                    for (Object element : elements) {
                        adds.add(element);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                    }
                    continue;
                }
                Assert.isTrue((boolean)false, (String)"unexpected case");
            }
            for (Object changedKey : diff.getChangedKeys()) {
                elements = CompositeMap.this.getElementsForValue(changedKey);
                for (Object element : elements) {
                    changes.add(element);
                    oldValues.put(element, diff.getOldValue(changedKey));
                    Object newValue = diff.getNewValue(changedKey);
                    newValues.put(element, newValue);
                    CompositeMap.this.wrappedMap.put(element, newValue);
                }
            }
            for (Object removedKey : removedKeys) {
                Object element = CompositeMap.this.pendingRemoves.remove(removedKey);
                if (element != null) {
                    if (CompositeMap.this.pendingChanges.containsKey(removedKey)) {
                        Object newKey = CompositeMap.this.pendingChanges.remove(removedKey);
                        CompositeMap.this.pendingChanges.remove(newKey);
                        CompositeMap.this.pendingAdds.remove(newKey);
                        CompositeMap.this.pendingRemoves.remove(removedKey);
                        changes.add(element);
                        oldValues.put(element, diff.getOldValue(removedKey));
                        Object newValue = CompositeMap.this.secondMap.get(newKey);
                        newValues.put(element, newValue);
                        CompositeMap.this.wrappedMap.put(element, newValue);
                        continue;
                    }
                    removes.add(element);
                    Object oldValue = diff.getOldValue(removedKey);
                    oldValues.put(element, oldValue);
                    CompositeMap.this.wrappedMap.remove(element);
                    continue;
                }
                Assert.isTrue((boolean)false, (String)"unexpected case");
            }
            if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
                CompositeMap.this.fireMapChange(new MapDiff(){

                    @Override
                    public Set getAddedKeys() {
                        return adds;
                    }

                    @Override
                    public Set getChangedKeys() {
                        return changes;
                    }

                    @Override
                    public Object getNewValue(Object key) {
                        return newValues.get(key);
                    }

                    @Override
                    public Object getOldValue(Object key) {
                        return oldValues.get(key);
                    }

                    @Override
                    public Set getRemovedKeys() {
                        return removes;
                    }
                });
            }
        }
    };
    private IObservableMap firstMap;
    private IObservableMap secondMap;
    private WritableSetPlus rangeSet = new WritableSetPlus();

    public CompositeMap(IObservableMap firstMap, IObservableFactory secondMapFactory) {
        super(firstMap.getRealm(), new HashMap());
        this.firstMap = firstMap;
        firstMap.addMapChangeListener(this.firstMapListener);
        for (Map.Entry entry : firstMap.entrySet()) {
            this.addMapping(entry.getKey(), entry.getValue());
            this.rangeSet.add(entry.getValue());
        }
        this.secondMap = (IObservableMap)secondMapFactory.createObservable(this.rangeSet);
        this.secondMap.addMapChangeListener(this.secondMapListener);
        for (Map.Entry entry : firstMap.entrySet()) {
            this.wrappedMap.put(entry.getKey(), this.secondMap.get(entry.getValue()));
        }
    }

    private void addMapping(Object key, Object value) {
        Object elementOrSet = this.valueToElements.get(value);
        if (elementOrSet == null) {
            this.valueToElements.put(value, key);
            return;
        }
        if (!(elementOrSet instanceof Set)) {
            elementOrSet = new HashSet(Collections.singleton(elementOrSet));
            this.valueToElements.put(value, elementOrSet);
        }
        Set set = (Set)elementOrSet;
        set.add(key);
    }

    private boolean removeMapping(Object key, Object value) {
        Object elementOrSet = this.valueToElements.get(value);
        if (elementOrSet instanceof Set) {
            Set set = (Set)elementOrSet;
            set.remove(key);
            if (set.size() == 0) {
                this.valueToElements.remove(value);
                return true;
            }
            return false;
        }
        this.valueToElements.remove(value);
        return true;
    }

    private Set getElementsForValue(Object value) {
        Object elementOrSet = this.valueToElements.get(value);
        if (elementOrSet instanceof Set) {
            return (Set)elementOrSet;
        }
        return elementOrSet == null ? Collections.EMPTY_SET : Collections.singleton(elementOrSet);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.firstMap.removeMapChangeListener(this.firstMapListener);
        this.firstMap = null;
        this.secondMap = null;
    }

    private static class WritableSetPlus
    extends WritableSet {
        private WritableSetPlus() {
        }

        void addAndRemove(Set additions, Set removals) {
            this.wrappedSet.removeAll(removals);
            this.wrappedSet.addAll(additions);
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    }
}

