/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.internal.databinding.IdentityWrapper;
import org.eclipse.core.runtime.Assert;

public class ObservableTracker {
    private static ThreadLocal currentChangeListener = new ThreadLocal();
    private static ThreadLocal currentStaleListener = new ThreadLocal();
    private static ThreadLocal currentObservableSet = new ThreadLocal();

    public static IObservable[] runAndMonitor(Runnable runnable, IChangeListener changeListener, IStaleListener staleListener) {
        Set lastObservableSet = (Set)currentObservableSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        HashSet observableSet = new HashSet();
        currentObservableSet.set(observableSet);
        currentChangeListener.set(changeListener);
        currentStaleListener.set(staleListener);
        try {
            runnable.run();
        }
        finally {
            currentObservableSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
        }
        int i = 0;
        IObservable[] result = new IObservable[observableSet.size()];
        for (IdentityWrapper wrapper : observableSet) {
            result[i++] = (IObservable)wrapper.unwrap();
        }
        return result;
    }

    public static void runAndIgnore(Runnable runnable) {
        Set lastObservableSet = (Set)currentObservableSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        currentObservableSet.set(null);
        currentChangeListener.set(null);
        currentStaleListener.set(null);
        try {
            runnable.run();
        }
        finally {
            currentObservableSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
        }
    }

    private static String toString(IObservable observable) {
        return String.valueOf(observable.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(observable));
    }

    public static void getterCalled(IObservable observable) {
        Set lastObservableSet;
        Realm realm = observable.getRealm();
        if (realm == null) {
            Assert.isTrue((boolean)false, (String)("Getter called on disposed observable " + ObservableTracker.toString(observable)));
        }
        if (!realm.isCurrent()) {
            Assert.isTrue((boolean)false, (String)("Getter called outside realm of observable " + ObservableTracker.toString(observable)));
        }
        if ((lastObservableSet = (Set)currentObservableSet.get()) == null) {
            return;
        }
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        boolean added = false;
        if (lastObservableSet != null) {
            added = lastObservableSet.add(new IdentityWrapper(observable));
        }
        if (added && lastChangeListener != null) {
            observable.addChangeListener(lastChangeListener);
        }
        if (added && lastStaleListener != null) {
            observable.addStaleListener(lastStaleListener);
        }
    }
}

