/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public abstract class Binding
extends ValidationStatusProvider {
    protected DataBindingContext context;
    private IObservable target;
    private IObservable model;

    public Binding(IObservable target, IObservable model) {
        this.target = target;
        this.model = model;
    }

    public final void init(DataBindingContext context) {
        this.context = context;
        this.preInit();
        context.addBinding(this);
        this.postInit();
    }

    protected abstract void preInit();

    protected abstract void postInit();

    @Override
    public abstract IObservableValue getValidationStatus();

    public abstract void updateTargetToModel();

    public abstract void updateModelToTarget();

    public abstract void validateTargetToModel();

    public abstract void validateModelToTarget();

    @Override
    public void dispose() {
        if (this.context != null) {
            this.context.removeBinding(this);
        }
        this.context = null;
        this.target = null;
        this.model = null;
        super.dispose();
    }

    void setDataBindingContext(DataBindingContext context) {
        this.context = context;
    }

    public IObservable getTarget() {
        return this.target;
    }

    @Override
    public IObservableList getTargets() {
        return Observables.staticObservableList(this.context.getValidationRealm(), Collections.singletonList(this.target));
    }

    public IObservable getModel() {
        return this.model;
    }

    @Override
    public IObservableList getModels() {
        return Observables.staticObservableList(this.context.getValidationRealm(), Collections.singletonList(this.model));
    }
}

