/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

public class ComboObservableValue
extends AbstractSWTObservableValue {
    private final Combo combo;
    private final String attribute;
    private boolean updating = false;
    private String currentValue;
    private ModifyListener modifyListener;

    public ComboObservableValue(Combo combo, String attribute) {
        super((Widget)combo);
        this.combo = combo;
        this.attribute = attribute;
        this.init();
    }

    public ComboObservableValue(Realm realm, Combo combo, String attribute) {
        super(realm, (Widget)combo);
        this.combo = combo;
        this.attribute = attribute;
        this.init();
    }

    private void init() {
        if (!this.attribute.equals("selection") && !this.attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        this.currentValue = this.combo.getText();
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ComboObservableValue.this.updating) {
                    String oldValue = ComboObservableValue.this.currentValue;
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                    ComboObservableValue.this.notifyIfChanged(oldValue, ComboObservableValue.this.currentValue);
                }
            }
        };
        this.combo.addModifyListener(this.modifyListener);
    }

    public void doSetValue(Object value) {
        String oldValue = this.combo.getText();
        try {
            this.updating = true;
            if (this.attribute.equals("text")) {
                String stringValue = value != null ? value.toString() : "";
                this.combo.setText(stringValue);
            } else if (this.attribute.equals("selection")) {
                String[] items = this.combo.getItems();
                int index = -1;
                if (items != null && value != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (value.equals(items[i])) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        this.combo.setText((String)value);
                    } else {
                        this.combo.select(index);
                    }
                }
            }
        }
        finally {
            this.updating = false;
            this.currentValue = this.combo.getText();
        }
        this.notifyIfChanged(oldValue, this.currentValue);
    }

    public Object doGetValue() {
        if (this.attribute.equals("text")) {
            return this.combo.getText();
        }
        Assert.isTrue((boolean)this.attribute.equals("selection"), (String)("unexpected attribute: " + this.attribute));
        return this.combo.getText();
    }

    public Object getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute: " + this.attribute));
        return String.class;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.modifyListener != null && !this.combo.isDisposed()) {
            this.combo.removeModifyListener(this.modifyListener);
        }
    }

    private void notifyIfChanged(String oldValue, String newValue) {
        if (!oldValue.equals(newValue)) {
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }
    }
}

