/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.propertytester;

import org.eclipse.core.internal.propertytester.ResourcePropertyTester;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class FilePropertyTester
extends ResourcePropertyTester {
    private static final String CONTENT_TYPE_ID = "contentTypeId";

    @Override
    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile && method.equals(CONTENT_TYPE_ID)) {
            return this.testContentType((IFile)receiver, this.toString(expectedValue));
        }
        return false;
    }

    private boolean testContentType(IFile file, String contentTypeId) {
        String expectedValue = contentTypeId.trim();
        String actualValue = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                actualValue = contentType.getId();
            }
        }
        catch (CoreException e) {
            Policy.log(4, "Core exception while retrieving the content description", e);
        }
        return expectedValue.equals(actualValue);
    }
}

