/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.concierge.plugin.filters.OfficeFilter;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ExcelFilter
extends OfficeFilter {
    HSSFWorkbook workbook;

    public ExcelFilter(String file) throws IOException {
        super(file);
        this.workbook = new HSSFWorkbook(this.poifs);
    }

    @Override
    public ArrayList<Image> getImages() {
        List pics = this.workbook.getAllPictures();
        ArrayList<Image> imgs = new ArrayList<Image>();
        for (HSSFPictureData pict : pics) {
            byte[] data = pict.getData();
            try {
                Image img = new Image((Device)PlatformUI.getWorkbench().getDisplay(), (InputStream)new ByteArrayInputStream(data));
                imgs.add(img);
            }
            catch (Exception exception) {}
        }
        return imgs;
    }

    @Override
    public String getText() {
        try {
            ExcelExtractor ext = new ExcelExtractor(this.poifs);
            return ext.getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

