/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;

public class DevClassLoadingHook
implements ClassLoadingHook,
HookConfigurator,
KeyedElement {
    public static final String KEY = DevClassLoadingHook.class.getName();
    public static final int HASHCODE = KEY.hashCode();

    @Override
    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    @Override
    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        String[] devClassPath;
        String[] stringArray = devClassPath = !DevClassPathHelper.inDevelopmentMode() ? null : DevClassPathHelper.getDevClassPath(sourcedata.getSymbolicName());
        if (devClassPath == null || devClassPath.length == 0) {
            return false;
        }
        if (cpEntries.size() > 0 && ((ClasspathEntry)cpEntries.get(0)).getUserObject(KEY) != null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < devClassPath.length) {
            if (ClasspathManager.addClassPathEntry(cpEntries, devClassPath[i], hostmanager, sourcedata, sourcedomain)) {
                result = true;
            } else {
                ClasspathEntry entry = hostmanager.getExternalClassPath(devClassPath[i], sourcedata, sourcedomain);
                if (entry != null) {
                    cpEntries.add(entry);
                    result = true;
                }
            }
            ++i;
        }
        if (result && cpEntries.size() > 0) {
            ((ClasspathEntry)cpEntries.get(0)).addUserObject(this);
        }
        return result;
    }

    @Override
    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    @Override
    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    @Override
    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    @Override
    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        if (DevClassPathHelper.inDevelopmentMode()) {
            hookRegistry.addClassLoadingHook(new DevClassLoadingHook());
        }
    }

    @Override
    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    @Override
    public Object getKey() {
        return KEY;
    }

    @Override
    public int getKeyHashCode() {
        return HASHCODE;
    }
}

