/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.FeatureReferenceAdapter;
import org.eclipse.update.internal.ui.model.ISiteAdapter;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteCategory;

public class SiteBookmark
extends NamedModelObject
implements ISiteAdapter {
    private static final long serialVersionUID = 1L;
    public static final String P_URL = "p_url";
    public static final String P_TYPE = "p_type";
    private URL url;
    private transient ISite site;
    private transient Vector catalog = new Vector();
    private transient SiteCategory otherCategory;
    private boolean webBookmark;
    private boolean selected;
    private String[] ignoredCategories = new String[0];
    private boolean readOnly = false;
    private boolean local = false;
    private boolean unavailable = false;
    private String description;

    public SiteBookmark() {
    }

    public SiteBookmark(String name, URL url, boolean webBookmark) {
        this(name, url, webBookmark, false);
    }

    public SiteBookmark(String name, URL url, boolean webBookmark, boolean selected) {
        super(name);
        this.url = url;
        this.webBookmark = webBookmark;
        this.selected = selected;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SiteBookmark)) {
            return false;
        }
        SiteBookmark b = (SiteBookmark)obj;
        if (this.url == null) {
            return false;
        }
        return this.url.equals(b.url);
    }

    public int hashCode() {
        if (this.url == null) {
            return super.hashCode();
        }
        return this.url.hashCode();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String[] getIgnoredCategories() {
        return this.ignoredCategories;
    }

    public void setIgnoredCategories(String[] categories) {
        this.ignoredCategories = categories;
    }

    public void setWebBookmark(boolean value) {
        if (this.isLocal()) {
            return;
        }
        this.webBookmark = value;
        this.notifyObjectChanged(P_TYPE);
    }

    public boolean isWebBookmark() {
        return this.webBookmark;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.site = null;
        this.notifyObjectChanged(P_URL);
    }

    @Override
    public ISite getSite(IProgressMonitor monitor) {
        return this.getSite(true, monitor);
    }

    public ISite getSite(boolean showDialogIfFailed, IProgressMonitor monitor) {
        if (this.site == null) {
            try {
                this.connect(monitor);
            }
            catch (CoreException e) {
                UpdateUI.logException(e, showDialogIfFailed);
            }
        }
        return this.site;
    }

    public boolean isSiteConnected() {
        return this.site != null;
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connect(true, monitor);
    }

    public void connect(boolean useCache, IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 2);
            monitor.subTask(NLS.bind((String)UpdateUIMessages.SiteBookmark_connecting, (Object)this.url.toString()));
            this.site = SiteManager.getSite((URL)this.url, (boolean)useCache, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.site != null) {
                this.createCatalog((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.unavailable = false;
            } else {
                this.catalog = new Vector();
                this.unavailable = true;
            }
        }
        catch (CoreException e) {
            this.unavailable = true;
            throw e;
        }
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public void setUnavailable(boolean value) {
        this.unavailable = value;
    }

    private void createCatalog(IProgressMonitor monitor) {
        IURLEntry descURL;
        this.catalog = new Vector();
        this.otherCategory = new SiteCategory(this, null, null);
        ICategory[] categories = this.site.getCategories();
        ISiteFeatureReference[] featureRefs = this.site.getRawFeatureReferences();
        monitor.beginTask("", featureRefs.length + categories.length);
        int i = 0;
        while (i < categories.length) {
            ICategory category = categories[i];
            this.addCategoryToCatalog(category);
            monitor.worked(1);
            ++i;
        }
        i = 0;
        while (i < featureRefs.length) {
            ISiteFeatureReference featureRef = featureRefs[i];
            this.addFeatureToCatalog(featureRef);
            monitor.worked(1);
            ++i;
        }
        if (this.otherCategory.getChildCount() > 0) {
            this.catalog.add(this.otherCategory);
        }
        if ((descURL = this.site.getDescription()) != null) {
            this.description = descURL.getAnnotation();
        }
    }

    public Object[] getCatalog(boolean withCategories, IProgressMonitor monitor) {
        if (withCategories) {
            return this.catalog.toArray();
        }
        Vector flatCatalog = new Vector();
        int i = 0;
        while (i < this.catalog.size()) {
            SiteCategory category = (SiteCategory)((Object)this.catalog.get(i));
            category.addFeaturesTo(flatCatalog);
            ++i;
        }
        return flatCatalog.toArray();
    }

    private void addCategoryToCatalog(ICategory category) {
        String name = category.getName();
        int loc = name.indexOf(47);
        if (loc == -1) {
            this.catalog.add(new SiteCategory(this, name, category));
        } else {
            Path path = new Path(name);
            name = path.lastSegment().toString();
            SiteCategory parentCategory = this.findCategory((IPath)(path = path.removeLastSegments(1)), this.catalog.toArray());
            if (parentCategory != null) {
                parentCategory.add((Object)new SiteCategory(this, name, category));
            }
        }
    }

    private void addFeatureToCatalog(ISiteFeatureReference feature) {
        ICategory[] categories = feature.getCategories();
        boolean orphan = true;
        int i = 0;
        while (i < categories.length) {
            ICategory category = categories[i];
            String name = category.getName();
            Path path = new Path(name);
            SiteCategory parentCategory = this.findCategory((IPath)path, this.catalog.toArray());
            if (parentCategory != null) {
                parentCategory.add(new FeatureReferenceAdapter((IFeatureReference)feature));
                orphan = false;
            }
            ++i;
        }
        if (orphan) {
            this.otherCategory.add(new FeatureReferenceAdapter((IFeatureReference)feature));
        }
    }

    private SiteCategory findCategory(IPath path, Object[] children) {
        int i = 0;
        while (i < children.length) {
            SiteCategory sc;
            Object child = children[i];
            if (child instanceof SiteCategory && (sc = (SiteCategory)((Object)child)).getName().equals(path.segment(0))) {
                if (path.segmentCount() == 1) {
                    return sc;
                }
                path = path.removeFirstSegments(1);
                return this.findCategory(path, sc.getChildren());
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        IURLEntry descURL;
        if (this.description == null && this.isSiteConnected() && (descURL = this.site.getDescription()) != null) {
            this.description = descURL.getAnnotation();
        }
        return this.description;
    }
}

