/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.RenameAction;
import jp.sourceforge.concierge.util.FileLauncher;
import jp.sourceforge.concierge.util.XPathString;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBrowser
extends ViewPart {
    private TableViewer projectview;
    private TableViewer contentview;
    private Action importAction;
    private Action deleteAction;
    private Action openAction;
    private Action renameAction;
    private ISelectionChangedListener sellistener = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        SashForm sf = new SashForm(parent, 256);
        sf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectview = new TableViewer((Composite)sf, 774);
        this.projectview.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectview.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectview.setSorter((ViewerSorter)new NameSorter());
        this.projectview.setInput(this.getProjects());
        this.projectview.getTable().setLinesVisible(true);
        this.projectview.getTable().setHeaderVisible(true);
        Table tbl = this.projectview.getTable();
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText("Project");
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(1000);
        this.sellistener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null) {
                    return;
                }
                Document doc = (Document)sel.getFirstElement();
                ArrayList docs = ProjectBrowser.this.getProjectFiles(doc);
                ProjectBrowser.this.contentview.setInput((Object)docs);
            }
        };
        this.projectview.addSelectionChangedListener(this.sellistener);
        this.contentview = new TableViewer((Composite)sf, 66306);
        this.contentview.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.contentview.setLabelProvider((IBaseLabelProvider)new ProjectFileLabelProvider());
        this.contentview.setSorter((ViewerSorter)new NameSorter());
        this.contentview.getTable().setLinesVisible(true);
        this.contentview.getTable().setHeaderVisible(true);
        sf.setWeights(new int[]{30, 70});
        tbl = this.contentview.getTable();
        tc = new TableColumn(tbl, 16384);
        tc.setText("File");
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(100);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Length");
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(100);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Last modified date");
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(300);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.projectview.getControl(), new ICCGUpdateListener(){

            private boolean contains(Document doc, ArrayList<Document> docs) {
                long did = DomImpl.getID((Document)doc);
                int i = 0;
                while (i < docs.size()) {
                    long id = DomImpl.getID((Document)docs.get(i));
                    if (did == id) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public void updated(CCGUpdateEvent ev) {
                if (!ev.collection.equals("data")) {
                    return;
                }
                if (!ev.success.booleanValue()) {
                    return;
                }
                ProjectBrowser.this.projectview.removeSelectionChangedListener(ProjectBrowser.this.sellistener);
                ArrayList pdocs = null;
                switch (ev.type) {
                    case DEL_DOCUMENT: {
                        IStructuredSelection sel;
                        pdocs = (ArrayList)ProjectBrowser.this.projectview.getInput();
                        if (pdocs != null && pdocs.size() > 0) {
                            ArrayList<Document> newpdocs = new ArrayList<Document>();
                            int i = 0;
                            while (i < pdocs.size()) {
                                if (!this.contains((Document)pdocs.get(i), ev.documents)) {
                                    newpdocs.add((Document)pdocs.get(i));
                                }
                                ++i;
                            }
                            ProjectBrowser.this.projectview.setInput(newpdocs);
                        }
                        if ((sel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection()) == null || sel.isEmpty()) {
                            ProjectBrowser.this.contentview.setInput(null);
                            break;
                        }
                        ArrayList cdocs = (ArrayList)ProjectBrowser.this.contentview.getInput();
                        if (cdocs == null || cdocs.size() <= 0) break;
                        ArrayList<Document> newcdocs = new ArrayList<Document>();
                        int i = 0;
                        while (i < cdocs.size()) {
                            if (!this.contains((Document)cdocs.get(i), ev.documents)) {
                                newcdocs.add((Document)cdocs.get(i));
                            }
                            ++i;
                        }
                        ProjectBrowser.this.contentview.setInput(newcdocs);
                        break;
                    }
                    case ADD_DOCUMENT: {
                        pdocs = (ArrayList)ProjectBrowser.this.projectview.getInput();
                        int i = 0;
                        while (i < ev.documents.size()) {
                            String path;
                            File fp;
                            Document doc = (Document)ev.documents.get(i);
                            Element prje = DataDomImpl.getDataOfType((Document)doc, (String)"Project");
                            if (prje != null && (fp = new File(path = DataDomImpl.getFilePath((Document)doc))).isDirectory()) {
                                pdocs.add(doc);
                            }
                            ++i;
                        }
                        ProjectBrowser.this.projectview.refresh();
                        break;
                    }
                    case UPD_DOCUMENT: {
                        ProjectBrowser.this.projectview.refresh();
                        ProjectBrowser.this.contentview.refresh();
                    }
                }
                ProjectBrowser.this.projectview.addSelectionChangedListener(ProjectBrowser.this.sellistener);
            }
        }));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#ProjectPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.projectview.getControl());
        this.projectview.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.projectview);
        menuMgr = new MenuManager("#FilePopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectBrowser.this.fillContextMenu(manager);
            }
        });
        menu = menuMgr.createContextMenu(this.contentview.getControl());
        this.contentview.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.contentview);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        String name = ((MenuManager)manager).getMenuText();
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        if (name.equals("#ProjectPopupMenu")) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.importAction);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
    }

    private void deleteDocuments(ArrayList<Document> docs) {
        Request r = new Request(2, docs, "data");
        ArrayList<Request> rs = new ArrayList<Request>();
        rs.add(r);
        FrameworkPlugin.updateDocuments(rs, (Object)"jp.sourceforge.concierge.plugin.projectbrowser");
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                if (ProjectBrowser.this.projectview.getControl().isFocusControl()) {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    Document doc = (Document)sel.getFirstElement();
                    FileLauncher.LaunchFile((Document)doc);
                } else {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.contentview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    for (Document doc : sel) {
                        FileLauncher.LaunchFile((Document)doc);
                    }
                }
            }
        };
        this.openAction.setText("Open files");
        this.openAction.setToolTipText("Open selected files");
        this.openAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
        this.deleteAction = new Action(){

            public void run() {
                if (ProjectBrowser.this.projectview.getControl().isFocusControl()) {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    if (!MessageDialog.openConfirm((Shell)ProjectBrowser.this.projectview.getTable().getShell(), (String)"Project Browser", (String)"Delete all project items(not delete files). OK?")) {
                        return;
                    }
                    Document doc = (Document)sel.getFirstElement();
                    ArrayList docs = ProjectBrowser.this.getProjectFiles(doc);
                    docs.add(doc);
                    ProjectBrowser.this.deleteDocuments(docs);
                } else {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.contentview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    if (!MessageDialog.openConfirm((Shell)ProjectBrowser.this.contentview.getTable().getShell(), (String)"Project Browser", (String)"Delete items(not delete files). OK?")) {
                        return;
                    }
                    ArrayList<Document> ndocs = new ArrayList<Document>();
                    Iterator it = sel.iterator();
                    while (it.hasNext()) {
                        ndocs.add((Document)it.next());
                    }
                    ProjectBrowser.this.deleteDocuments(ndocs);
                }
            }
        };
        this.deleteAction.setText("Delete items");
        this.deleteAction.setToolTipText("Delete selected items(not delete file)");
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.importAction = new Action(){

            public void run() {
                ProjectBrowser.this.showMessage("Import not implemented.");
            }
        };
        this.importAction.setText("Import");
        this.importAction.setToolTipText("Import from package explorer");
        this.importAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.renameAction = new RenameAction(this.projectview, this.contentview);
        this.renameAction.setText("Rename");
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.projectview.getControl().getShell(), (String)"Project Browser", (String)message);
    }

    public void setFocus() {
        this.projectview.getControl().setFocus();
    }

    private ArrayList<Document> getProjects() {
        String xpath = "/mdata/data[" + XPathString.getAttributeEqualsPredicate((String)"name", (String)"Project") + "]";
        Request r = new Request(4, (Object)xpath, "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
        ArrayList<Document> ndocs = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            String p = DataDomImpl.getFilePath((Document)((Document)docs.get(i)));
            File fp = new File(p);
            if (fp.isDirectory()) {
                ndocs.add((Document)docs.get(i));
            }
            ++i;
        }
        return ndocs;
    }

    private ArrayList<Document> getProjectFiles(Document pdoc) {
        String ppath = DataDomImpl.getFilePath((Document)pdoc);
        String xpath = "/mdata[" + XPathString.getAttributeStartsWithPredicate((String)"filepath", (String)ppath) + "]";
        Request r = new Request(4, (Object)xpath, "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
        long pdid = DomImpl.getID((Document)pdoc);
        int i = 0;
        while (i < docs.size()) {
            long did = DomImpl.getID((Document)((Document)docs.get(i)));
            if (did == pdid) {
                docs.remove(i);
                break;
            }
            ++i;
        }
        return docs;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ProjectContentProvider
    implements IStructuredContentProvider {
        ProjectContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ProjectFileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProjectFileLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Document doc = (Document)obj;
            Element e = DataDomImpl.getDataOfType((Document)doc, (String)"Project");
            if (e == null) {
                return null;
            }
            TableColumn tc = ProjectBrowser.this.contentview.getTable().getColumn(index);
            String title = tc.getText();
            if (title.equals("File")) {
                return DataDomImpl.getFileName((Document)doc);
            }
            if (title.equals("Length")) {
                String path = DataDomImpl.getFilePath((Document)doc);
                File f = new File(path);
                if (!f.exists()) {
                    return null;
                }
                return String.valueOf(f.length());
            }
            if (title.equals("Last modified date")) {
                String path = DataDomImpl.getFilePath((Document)doc);
                File f = new File(path);
                if (!f.exists()) {
                    return null;
                }
                return new Date(f.lastModified()).toString();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            TableColumn tc = ProjectBrowser.this.contentview.getTable().getColumn(index);
            String title = tc.getText();
            if (title.equals("File")) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProjectLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Document doc = (Document)obj;
            Element e = DataDomImpl.getDataOfType((Document)doc, (String)"Project");
            if (e == null) {
                return null;
            }
            return DataDomImpl.getFileName((Document)doc);
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

