/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabNoteDocumentImpl {
    public static Document createDocument(int year, int month, int day) {
        Document typedoc = TypeManager.getTypeDocument((String)"Note");
        Document doc = DataDomImpl.createDocument((Document)typedoc);
        LabNoteDocumentImpl.setCategory(doc, "<Unknown>");
        DataDomImpl.setDefaultType((Document)doc, (String)"Note");
        LabNoteDocumentImpl.setDate(doc, String.valueOf(String.valueOf(year)) + "-" + String.valueOf(month) + "-" + String.valueOf(day));
        return doc;
    }

    private static String getString(Document doc, String itemname, String type) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname, (String)"Note");
        if (elem == null) {
            return null;
        }
        ITypeParser parser = FrameworkPlugin.getParser((String)type);
        return parser.getSingleText(elem);
    }

    private static void setString(Document doc, String itemname, String type, String val) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname, (String)"Note");
        if (elem == null) {
            return;
        }
        ITypeParser parser = FrameworkPlugin.getParser((String)type);
        parser.putToElement(elem, val);
    }

    public static String getCategory(Document doc) {
        return LabNoteDocumentImpl.getString(doc, "Category", "text");
    }

    public static Document getContent(Document doc) {
        try {
            String xml = DataDomImpl.getFilePath((Document)doc);
            return DomImpl.loadDocument((String)xml);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDate(Document doc) {
        return LabNoteDocumentImpl.getString(doc, "Date", "date");
    }

    public static String getKeywords(Document doc) {
        return LabNoteDocumentImpl.getString(doc, "Keywords", "keywords");
    }

    public static String getTitle(Document doc) {
        return LabNoteDocumentImpl.getString(doc, "Title", "text");
    }

    public static void setCategory(Document doc, String name) {
        LabNoteDocumentImpl.setString(doc, "Category", "text", name);
    }

    public static void setContent(Document doc, Document xml) {
        try {
            String path = DataDomImpl.getFilePath((Document)doc);
            DomImpl.saveDocument((Document)xml, (String)path);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void setDate(Document doc, String val) {
        LabNoteDocumentImpl.setString(doc, "Date", "date", val);
    }

    public static void setKeywords(Document doc, String val) {
        LabNoteDocumentImpl.setString(doc, "Keywords", "keywords", val);
        DataDomImpl.setKeywords((Document)doc, (String)val);
    }

    public static void setTitle(Document doc, String val) {
        LabNoteDocumentImpl.setString(doc, "Title", "text", val);
        DataDomImpl.setTitle((Document)doc, (String)val);
    }

    public static boolean equalsByDate(Document doc, int year, int month, int day) {
        String datestr = LabNoteDocumentImpl.getDate(doc);
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            format.parse(datestr);
            Calendar c = format.getCalendar();
            return c.get(1) == year && c.get(2) + 1 == month && c.get(5) == day;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList<String> getAllImagePath(Document doc) {
        NodeList elems = doc.getElementsByTagName("img");
        ArrayList<String> imgs = new ArrayList<String>();
        int i = 0;
        while (i < elems.getLength()) {
            String path = DomImpl.getAttribute((Element)((Element)elems.item(i)), (String)"src");
            if (path != null && path.length() > 0) {
                imgs.add(path);
            }
            ++i;
        }
        return imgs;
    }

    public static void convert(Document doc) {
        String title = LabNoteDocumentImpl.getString(doc, "Title", "text");
        String keywd = LabNoteDocumentImpl.getString(doc, "Keywords", "keywords");
        if (title != null) {
            title = title.trim();
            LabNoteDocumentImpl.setTitle(doc, title);
            LabNoteDocumentImpl.setString(doc, "Title", "text", "");
        }
        if (keywd != null) {
            keywd = keywd.trim();
            LabNoteDocumentImpl.setKeywords(doc, keywd);
            LabNoteDocumentImpl.setString(doc, "Keywords", "keywords", "");
        }
    }
}

