/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.editor.DataDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciergeAdapter {
    public static final String TYPEDOCNAME = "Paper";
    public static final String REQUIRED_PARSERS = "text, authors, keywords, identifiers";

    public static boolean isReady(Object sender) {
        String[] request = REQUIRED_PARSERS.split(",");
        int i = 0;
        while (i < request.length) {
            if (!FrameworkPlugin.containsParser((String)request[i].trim())) {
                return false;
            }
            ++i;
        }
        Document tdoc = TypeManager.getTypeDocument((String)TYPEDOCNAME);
        if (tdoc == null) {
            tdoc = TypeDomImpl.createDocument((String)TYPEDOCNAME);
            TypeDomImpl.setImage((Document)tdoc, (String)IPapersPlugin.getPluginFilePath("icons/pubmed.png"));
            TypeDomImpl.appendElement((Document)tdoc, (String)"Author", (String)"authors", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Title", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Journal", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Volume", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Number", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Pages", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Year", (String)"text", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Abstract", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"IDs", (String)"identifiers", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Comment", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.setPluginID((Document)tdoc, (String)IPapersPlugin.getDefault().getBundle().getSymbolicName());
            Request rq = new Request(1, (Object)tdoc, "type");
            ArrayList<Request> rqs = new ArrayList<Request>();
            rqs.add(rq);
            FrameworkPlugin.updateDocuments(rqs, (Object)sender);
        }
        return true;
    }

    public static boolean saveArticle(PaperInfo info, Object sender) {
        String xpath = "/type[@name='Paper']";
        Request request = new Request(4, (Object)xpath, "type");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        boolean response = false;
        if (ret.size() > 0) {
            Document typedoc = (Document)ret.get(0);
            Document datadoc = DataDomImpl.createDocument((Document)typedoc);
            ConciergeAdapter.setArticleInfo(datadoc, typedoc, info, sender);
            Shell shell = IPapersPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            DataDialog dd = new DataDialog(shell, 0);
            dd.setNewDocument(datadoc, TYPEDOCNAME, sender);
            int result = dd.open();
            if (result == 0) {
                response = true;
            }
        }
        return response;
    }

    private static void setArticleInfo(Document datadoc, Document typedoc, PaperInfo info, Object sender) {
        String path = info.getFilepath();
        DataDomImpl.setFilePath((Document)datadoc, (String)path);
        Element delem = DataDomImpl.getDataOfType((Document)datadoc, (String)TYPEDOCNAME);
        Element data = DataDomImpl.getElement((Element)delem, (String)"Author");
        DataDomImpl.setElementContent((Element)data, (String)info.getAuthor());
        data = DataDomImpl.getElement((Element)delem, (String)"Title");
        DataDomImpl.setElementContent((Element)data, (String)info.getTitle());
        data = DataDomImpl.getElement((Element)delem, (String)"Journal");
        DataDomImpl.setElementContent((Element)data, (String)info.getJournal());
        data = DataDomImpl.getElement((Element)delem, (String)"Volume");
        DataDomImpl.setElementContent((Element)data, (String)info.getVolume());
        data = DataDomImpl.getElement((Element)delem, (String)"Number");
        DataDomImpl.setElementContent((Element)data, (String)info.getIssue());
        data = DataDomImpl.getElement((Element)delem, (String)"Pages");
        DataDomImpl.setElementContent((Element)data, (String)info.getPages());
        data = DataDomImpl.getElement((Element)delem, (String)"Year");
        DataDomImpl.setElementContent((Element)data, (String)info.getYear());
        data = DataDomImpl.getElement((Element)delem, (String)"Abstract");
        DataDomImpl.setElementContent((Element)data, (String)info.getAbstract());
        data = DataDomImpl.getElement((Element)delem, (String)"IDs");
        DataDomImpl.setElementContent((Element)data, (String)info.getFormattedIDs());
    }

    public static Set<String> authorsInConcierge() {
        Request request = new Request(4, (Object)"/mdata/data[@name='Paper']/Author", "data");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        TreeSet<String> authors = new TreeSet<String>();
        for (Document doc : ret) {
            Element delem = DataDomImpl.getDataOfType((Document)doc, (String)TYPEDOCNAME);
            Element author = DataDomImpl.getElement((Element)delem, (String)"Author");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParser((String)paserName);
            authors.addAll(parser.getMultiText(author));
        }
        return authors;
    }

    public static Set<String> journalInConcierge() {
        Request request = new Request(4, (Object)"/mdata/data[@name='Paper']/Journal", "data");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        TreeSet<String> journals = new TreeSet<String>();
        for (Document doc : ret) {
            Element delem = DataDomImpl.getDataOfType((Document)doc, (String)TYPEDOCNAME);
            Element author = DataDomImpl.getElement((Element)delem, (String)"Journal");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParser((String)paserName);
            journals.addAll(parser.getMultiText(author));
        }
        return journals;
    }

    public static Set<String> keywordsInConcierge() {
        Request request = new Request(4, (Object)"/mdata/data[@name='Paper']/Keywords", "data");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        TreeSet<String> keywords = new TreeSet<String>();
        for (Document doc : ret) {
            Element delem = DataDomImpl.getDataOfType((Document)doc, (String)TYPEDOCNAME);
            Element author = DataDomImpl.getElement((Element)delem, (String)"Keywords");
            String paserName = DataDomImpl.getParserName((Element)author);
            ITypeParser parser = FrameworkPlugin.getParser((String)paserName);
            keywords.addAll(parser.getMultiText(author));
        }
        return keywords;
    }

    public static ArrayList<Paper> papersBindToKeyword(String keyword) {
        String xpath = "/mdata/data[@name='Paper']/Keywords[contains(translate(., 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + keyword.toLowerCase() + "')]";
        Request request = new Request(4, (Object)xpath, "data");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        ArrayList<Paper> papers = new ArrayList<Paper>();
        block0: for (Document doc : ret) {
            ArticleInfo info = new ArticleInfo();
            Element delem = DataDomImpl.getDataOfType((Document)doc, (String)TYPEDOCNAME);
            Element element = DataDomImpl.getElement((Element)delem, (String)"Author");
            ArrayList data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)element)).getMultiText(element);
            if (data.size() > 0) {
                info.setAuthor((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Abstract")))).getMultiText(element)).size() > 0) {
                info.setAbstract((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Journal")))).getMultiText(element)).size() > 0) {
                info.setJournal((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Year")))).getMultiText(element)).size() > 0) {
                info.setYear((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Volume")))).getMultiText(element)).size() > 0) {
                info.setVolume((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Number")))).getMultiText(element)).size() > 0) {
                info.setIssue((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Pages")))).getMultiText(element)).size() > 0) {
                info.setPages((String)data.get(0));
            }
            if ((data = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)(element = DataDomImpl.getElement((Element)delem, (String)"Title")))).getMultiText(element)).size() > 0) {
                info.setTitle((String)data.get(0));
            }
            element = DataDomImpl.getElement((Element)delem, (String)"IDs");
            ArrayList ids = FrameworkPlugin.getParser((String)DataDomImpl.getParserName((Element)element)).getMultiText(element);
            Pattern pattern = Pattern.compile("pubmed:=(\\d+)");
            for (String id : ids) {
                Matcher matcher = pattern.matcher(id);
                if (!matcher.find(0)) continue;
                String pmid = matcher.group(1);
                String idtype = PubMedCore.IDTYPE;
                Paper newPaper = new Paper(pmid, idtype, info);
                papers.add(newPaper);
                continue block0;
            }
        }
        return papers;
    }

    public static Boolean hasPapers(String id, String idtype) {
        String xpath = "/mdata/data[@name='Paper']/IDs[contains(translate(., 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + id.toLowerCase() + "')]";
        Request request = new Request(4, (Object)xpath, "data");
        ArrayList ret = FrameworkPlugin.getDocumentsOfQuery((Request)request);
        Boolean result = false;
        if (ret.size() > 0) {
            result = true;
        }
        return result;
    }
}

