/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.iBooksPlugin;
import jp.sourceforge.concierge.plugin.ibooks.BookRegister;
import jp.sourceforge.concierge.plugin.ibooks.preferences.PreferenceConstants;
import jp.sourceforge.concierge.util.FileLauncher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class iBooks
extends ConciergeViewPart {
    private Combo urlPullDown = null;
    private Text queryText = null;
    private Composite m_parent = null;
    private CheckboxTableViewer tableViewer;
    private ScrolledComposite sc = null;
    private Composite albumViewer = null;
    private IMemento memento = null;
    private Action singleAddAction = null;
    private Action amazonUrlOpenAction = null;
    private Action openPreferenceAction = null;
    private String[] tableHeadMac = new String[]{"Regist", "Title", "Author", "Publisher", "Year", "Category", "Price", "ISBN", "Path"};
    private String[] tableHead = new String[]{"Check", "Regist", "Title", "Author", "Publisher", "Year", "Category", "Price", "ISBN", "Path"};
    private int registIndex = 1;
    private Object selectObj = null;
    private Image unregistImage = null;
    private static final String addActionName = "Import";

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.saveColumnWidth(memento);
    }

    private void saveColumnWidth(IMemento memento) {
        if (memento != null) {
            TableColumn[] columns = this.tableViewer.getTable().getColumns();
            int i = 0;
            while (i < columns.length) {
                memento.putInteger("TABLECOLUMNWIDTH" + this.tableHead[i], columns[i].getWidth());
                ++i;
            }
            int[] order = this.tableViewer.getTable().getColumnOrder();
            int i2 = 0;
            while (i2 < order.length) {
                memento.putInteger("TABLECOLUMNORDER" + this.tableHead[order[i2]], i2);
                ++i2;
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        ImageDescriptor imgDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ibooks", (String)"icons/concierge.png");
        this.unregistImage = imgDes.createImage();
        GridLayout gl = null;
        GridData data = null;
        int colnum = 3;
        gl = new GridLayout(colnum, false);
        parent.setLayout((Layout)gl);
        this.urlPullDown = new Combo(this.m_parent, 8);
        data = new GridData(32);
        this.urlPullDown.setLayoutData((Object)data);
        this.urlPullDown.setItems(PreferenceConstants.AMAZONURLS);
        String amazonurl = iBooksPlugin.getDefault().getPreferenceStore().getString("AMAZONURL");
        int i = 0;
        while (i < PreferenceConstants.AMAZONURLS.length) {
            if (amazonurl.equals(PreferenceConstants.AMAZONURLS[i])) {
                this.urlPullDown.select(i);
                break;
            }
            ++i;
        }
        this.urlPullDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                String value = combo.getText();
                if (value != null && value.length() > 0) {
                    iBooksPlugin.getDefault().getPreferenceStore().setValue("AMAZONURL", value);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.queryText = new Text(this.m_parent, 2048);
        data = new GridData(768);
        this.queryText.setLayoutData((Object)data);
        this.queryText.setText("");
        this.queryText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                iBooks.this.DoSearch();
            }
        });
        this.queryText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    e.detail = 0;
                }
            }
        });
        Button searchButton = new Button(this.m_parent, 8);
        data = new GridData(32);
        searchButton.setLayoutData((Object)data);
        searchButton.setText("Search");
        searchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                iBooks.this.DoSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator1 = new Label(this.m_parent, 258);
        data = new GridData(768);
        data.horizontalSpan = colnum;
        separator1.setLayoutData((Object)data);
        TabFolder tabFolder = new TabFolder(this.m_parent, 0);
        data = new GridData(1808);
        data.horizontalSpan = colnum;
        tabFolder.setLayoutData((Object)data);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (((TabItem)e.item).getText().equalsIgnoreCase("list")) {
                    iBooksPlugin.getDefault().getPreferenceStore().setValue("SELECTTABFOLDER", "LIST");
                } else if (((TabItem)e.item).getText().equalsIgnoreCase("image")) {
                    iBooksPlugin.getDefault().getPreferenceStore().setValue("SELECTTABFOLDER", "IMAGE");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText("List");
        this.createTableViewer((Composite)tabFolder);
        item1.setControl(this.tableViewer.getControl());
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText("Image");
        this.createAlbumViewer((Composite)tabFolder);
        item2.setControl((Control)this.sc);
        String selectTab = iBooksPlugin.getDefault().getPreferenceStore().getString("SELECTTABFOLDER");
        if (selectTab.equals("LIST")) {
            tabFolder.setSelection(item1);
        } else if (selectTab.equals("IMAGE")) {
            tabFolder.setSelection(item2);
        }
        Label separator2 = new Label(this.m_parent, 258);
        data = new GridData(768);
        data.horizontalSpan = colnum;
        separator2.setLayoutData((Object)data);
        Button mappingButton = new Button(this.m_parent, 0);
        mappingButton.setVisible(false);
        mappingButton.setText("Mapping");
        mappingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button addButton = new Button(this.m_parent, 8);
        data = new GridData(128);
        data.horizontalSpan = 2;
        addButton.setLayoutData((Object)data);
        addButton.setText(addActionName);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = false;
                ArrayList al = (ArrayList)iBooks.this.tableViewer.getInput();
                int i = 0;
                while (i < al.size()) {
                    Object obj = al.get(i);
                    if (obj instanceof BookRegister && ((BookRegister)obj).getChecked()) {
                        isChecked = true;
                        break;
                    }
                    ++i;
                }
                if (!isChecked) {
                    String msg = "item is not selected.";
                    MessageDialog.openInformation((Shell)iBooks.this.m_parent.getShell(), (String)"Book", (String)msg);
                    return;
                }
                String msg = "Press the 'YES' button to complete this registration process.";
                boolean ans = MessageDialog.openQuestion((Shell)iBooks.this.m_parent.getShell(), (String)"Confirmation", (String)msg);
                if (ans) {
                    iBooks.this.DoAdd();
                    int i2 = 0;
                    while (i2 < al.size()) {
                        Object obj = al.get(i2);
                        if (obj instanceof BookRegister) {
                            BookRegister br = (BookRegister)obj;
                            iBooks.this.tableViewer.update((Object)br, null);
                            iBooks.this.setCheckTableViewer(br);
                            iBooks.this.setCheckAlbumViewer(br);
                        }
                        ++i2;
                    }
                    msg = "Succeed!! (MetaData of Book were registered with Concierge database.)";
                    MessageDialog.openInformation((Shell)iBooks.this.m_parent.getShell(), (String)"Book", (String)msg);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.makeActions();
        this.hookContextMenu();
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (!ev.collection.equals("data")) {
                    return;
                }
                if (!ev.success.booleanValue()) {
                    return;
                }
                switch (ev.type) {
                    case DEL_DOCUMENT: {
                        int i = 0;
                        while (i < ev.documents.size()) {
                            String catchFileName;
                            File catchFile;
                            Document datadoc = (Document)ev.documents.get(i);
                            long id = DomImpl.getID((Document)datadoc);
                            String catchDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ibooks";
                            File catchFolder = new File(catchDirName);
                            if (!catchFolder.exists()) {
                                catchFolder.mkdir();
                            }
                            if ((catchFile = new File(catchFileName = String.valueOf(catchDirName) + System.getProperty("file.separator") + id + ".jpg")).exists()) {
                                catchFile.delete();
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
        });
    }

    private void createAlbumViewer(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setLayout((Layout)new FillLayout());
        this.sc.getVerticalBar().setIncrement(140);
        this.sc.setExpandHorizontal(true);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = iBooks.this.sc.getClientArea();
                iBooks.this.albumViewer.setSize(iBooks.this.albumViewer.computeSize(r.width, -1));
            }
        });
        this.albumViewer = new Composite((Composite)this.sc, 0);
        RowLayout rl = new RowLayout(256);
        rl.wrap = true;
        this.albumViewer.setLayout((Layout)rl);
        this.sc.setContent((Control)this.albumViewer);
        this.albumViewer.setSize(this.albumViewer.computeSize(-1, -1));
    }

    public Image createThumbnailWithURL(String imageURL) {
        Image newImage;
        block10: {
            newImage = null;
            if (imageURL != null && imageURL.length() > 0) {
                URL url = null;
                try {
                    url = new URL(imageURL);
                    InputStream is = url.openStream();
                    Image image = new Image((Device)this.m_parent.getDisplay(), is);
                    int width = 120;
                    int height = 120;
                    Rectangle r = image.getBounds();
                    if (r.width > 120 || r.height > 120) {
                        float a;
                        if (r.width > r.height) {
                            a = r.width;
                            float b = 120.0f;
                            float c = r.height;
                            float ans = a / b;
                            height = (int)(c / ans);
                        } else {
                            a = r.height;
                            float b = 120.0f;
                            float c = r.width;
                            float ans = a / b;
                            width = (int)(c / ans);
                        }
                        ImageData imgdata = image.getImageData().scaledTo(width, height);
                        newImage = new Image((Device)this.m_parent.getDisplay(), imgdata);
                        image.dispose();
                        image = null;
                    } else {
                        newImage = image;
                    }
                    is.close();
                }
                catch (Exception exception) {
                    if (newImage == null) break block10;
                    newImage.dispose();
                    newImage = null;
                }
            }
        }
        if (newImage == null) {
            ImageDescriptor imgDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ibooks", (String)"icons/NoImage.jpg");
            Image image = imgDes.createImage();
            Rectangle r = image.getBounds();
            if (r.width > 120 || r.height > 120) {
                ImageData imgdata = image.getImageData().scaledTo(120, 120);
                newImage = new Image((Device)this.m_parent.getDisplay(), imgdata);
                image.dispose();
                image = null;
            } else {
                newImage = image;
            }
        }
        return newImage;
    }

    public Image createCatchThumbnail(String imageURL) {
        String filename = "catchthumbnail.jpg";
        iBooksPlugin.getDefault().saveCatchThumbnailFile(imageURL, filename);
        return iBooksPlugin.getDefault().loadCatchThumbnailFile(filename);
    }

    public void addThumbnailControl(BookRegister br, Image image) {
        Composite item = new Composite(this.albumViewer, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        item.setLayout((Layout)gl);
        item.setData((Object)br);
        GridData data = null;
        Label thumbnail = new Label(item, 0x1000000);
        thumbnail.setImage(image);
        thumbnail.setAlignment(0x1000000);
        thumbnail.setToolTipText(String.valueOf(br.getTitle()) + "\n" + br.getAuthor() + "\n" + br.getPublisher() + "\n" + br.getPrice());
        data = new GridData(1808);
        thumbnail.setLayoutData((Object)data);
        Button titleButton = new Button(item, 32);
        titleButton.setText(br.getTitle());
        titleButton.setSelection(br.getChecked());
        data = new GridData(768);
        titleButton.setLayoutData((Object)data);
        titleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                BookRegister br = (BookRegister)button.getParent().getData();
                br.setChecked(button.getSelection());
                iBooks.this.setCheckTableViewer(br);
            }
        });
        br.setAlbumCheckButton(titleButton);
        item.setLayoutData((Object)new RowData(120, 140));
        thumbnail.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BookRegister br;
                Label label = (Label)e.getSource();
                br.setChecked(!(br = (BookRegister)label.getParent().getData()).getChecked());
                iBooks.this.setCheckAlbumViewer(br);
                iBooks.this.setCheckTableViewer(br);
            }
        });
        Menu menu = new Menu((Decorations)thumbnail.getShell(), 8);
        MenuItem menuitem3 = new MenuItem(menu, 8);
        menuitem3.setData((Object)br);
        menuitem3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuitem = (MenuItem)e.getSource();
                Object obj = menuitem.getData();
                if (obj != null && obj instanceof BookRegister) {
                    BookRegister br = (BookRegister)obj;
                    iBooks.this.DoAdd(br);
                    iBooks.this.tableViewer.update((Object)br, null);
                    br.getAlbumCheckButton().setSelection(br.getChecked());
                    iBooks.this.tableViewer.setChecked((Object)br, br.getChecked());
                    String msg = "Succeed!! (MetaData of Book were registered with Concierge database.)";
                    MessageDialog.openInformation((Shell)iBooks.this.m_parent.getShell(), (String)"Book", (String)msg);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        menuitem3.setText(addActionName);
        new MenuItem(menu, 2);
        MenuItem menuitem1 = new MenuItem(menu, 8);
        menuitem1.setData((Object)br);
        menuitem1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuitem = (MenuItem)e.getSource();
                Object obj = menuitem.getData();
                if (obj != null && obj instanceof BookRegister) {
                    FileLauncher.LaunchBrowser((String)((BookRegister)obj).getURL());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        menuitem1.setText("Open Amazon Site");
        thumbnail.setMenu(menu);
    }

    public void layoutAlbumView() {
        Rectangle r = this.sc.getClientArea();
        this.albumViewer.setSize(this.albumViewer.computeSize(r.width, -1));
        this.albumViewer.layout();
    }

    public void clearAlbumView() {
        this.disposeAlbumViewer();
        Rectangle r = this.sc.getClientArea();
        this.albumViewer.setSize(this.albumViewer.computeSize(r.width, -1));
        this.albumViewer.layout();
    }

    public void setAlbumView(ArrayList al) {
        int i = 0;
        while (i < al.size()) {
            BookRegister br = (BookRegister)al.get(i);
            Image image = this.createCatchThumbnail(br.getIMAGEURL());
            this.addThumbnailControl(br, image);
            ++i;
        }
        Rectangle r = this.sc.getClientArea();
        this.albumViewer.setSize(this.albumViewer.computeSize(r.width, -1));
        this.albumViewer.layout();
    }

    private void disposeAlbumViewer() {
        Control[] children = this.albumViewer.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Control[] controls = ((Composite)children[i]).getChildren();
                int j = 0;
                while (j < controls.length) {
                    Image image;
                    if (controls[j] instanceof Label && (image = ((Label)controls[j]).getImage()) != null) {
                        ((Label)controls[j]).setImage(null);
                        image.dispose();
                        image = null;
                    }
                    controls[j].dispose();
                    controls[j] = null;
                    ++j;
                }
            }
            children[i].dispose();
            children[i] = null;
            ++i;
        }
    }

    private void setCheckTableViewer(BookRegister br) {
        this.tableViewer.setChecked((Object)br, br.getChecked());
    }

    private void setCheckAlbumViewer(BookRegister br) {
        if (br.getAlbumCheckButton() != null) {
            Button button = br.getAlbumCheckButton();
            button.setSelection(br.getChecked());
        }
    }

    private void refreshCheckTableViewer() {
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            TableItem item = this.tableViewer.getTable().getItem(i);
            Object obj = item.getData();
            if (obj instanceof BookRegister) {
                item.setChecked(((BookRegister)obj).getChecked());
            }
            ++i;
        }
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68384);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.getTable().setLinesVisible(true);
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Mac")) {
            if (this.tableHead != null) {
                this.tableHead = null;
            }
            this.tableHead = this.tableHeadMac;
            this.registIndex = 0;
        }
        this.tableViewer.getTable().setHeaderVisible(true);
        int[] orders = new int[this.tableHead.length];
        boolean isOrders = true;
        int i = 0;
        while (i < this.tableHead.length) {
            TableColumn tc = new TableColumn(this.tableViewer.getTable(), 16384, i);
            Integer widthInt = null;
            if (i > this.registIndex) {
                if (this.memento != null) {
                    widthInt = this.memento.getInteger("TABLECOLUMNWIDTH" + this.tableHead[i]);
                }
                if (widthInt == null) {
                    tc.setWidth(150);
                } else {
                    tc.setWidth(widthInt.intValue());
                }
            } else {
                tc.setWidth(24);
            }
            Integer orderInt = null;
            if (this.memento != null) {
                orderInt = this.memento.getInteger("TABLECOLUMNORDER" + this.tableHead[i]);
            }
            if (orderInt == null) {
                isOrders = false;
            } else {
                orders[i] = orderInt;
            }
            if (i > this.registIndex) {
                tc.setText(this.tableHead[i]);
            }
            if (i > this.registIndex) {
                tc.setMoveable(true);
            } else {
                tc.setMoveable(false);
            }
            if (i > this.registIndex) {
                tc.setResizable(true);
            } else {
                tc.setResizable(false);
            }
            if (i > this.registIndex) {
                tc.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        TableColumn column = (TableColumn)e.getSource();
                        int colNum = iBooks.this.tableViewer.getTable().indexOf(column);
                        BookSorter newSorter = new BookSorter();
                        BookSorter nowSorter = (BookSorter)iBooks.this.tableViewer.getSorter();
                        if (nowSorter != null) {
                            newSorter.setSortUp(!nowSorter.getSortUp());
                        }
                        newSorter.setColumnIndex(colNum);
                        iBooks.this.tableViewer.setSorter((ViewerSorter)newSorter);
                        iBooks.this.tableViewer.getTable().setSortColumn(column);
                        int direction = 1024;
                        if (newSorter.getSortUp()) {
                            direction = 128;
                        }
                        iBooks.this.tableViewer.getTable().setSortDirection(direction);
                        iBooks.this.refreshCheckTableViewer();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            ++i;
        }
        if (isOrders) {
            this.tableViewer.getTable().setColumnOrder(orders);
        }
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem item = (TableItem)event.item;
                    Object obj = item.getData();
                    if (obj instanceof BookRegister) {
                        ((BookRegister)obj).setChecked(item.getChecked());
                    }
                    iBooks.this.setCheckAlbumViewer((BookRegister)obj);
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
            }
        });
        this.tableViewer.setColumnProperties(this.tableHead);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable())};
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier((TableViewer)this.tableViewer));
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer};
        DropTarget target = new DropTarget((Control)this.tableViewer.getTable(), 19);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTableAdapter());
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    public void Update(ArrayList reqs, Object sender) {
        int r = 0;
        while (r < reqs.size()) {
            Request req = (Request)reqs.get(r);
            if (req.collection.compareTo("data") == 0) {
                Document datadoc = (Document)req.data;
                if (req.command == 2) {
                    String catchFileName;
                    File catchFile;
                    long id = DomImpl.getID((Document)datadoc);
                    String catchDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ibooks";
                    File catchFolder = new File(catchDirName);
                    if (!catchFolder.exists()) {
                        catchFolder.mkdir();
                    }
                    if ((catchFile = new File(catchFileName = String.valueOf(catchDirName) + System.getProperty("file.separator") + id + ".jpg")).exists()) {
                        catchFile.delete();
                    }
                }
            }
            ++r;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                iBooks.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.singleAddAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.amazonUrlOpenAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.singleAddAction = new Action(){

            public void run() {
                ISelection selection = iBooks.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && obj instanceof BookRegister) {
                    BookRegister br = (BookRegister)obj;
                    iBooks.this.DoAdd(br);
                    iBooks.this.tableViewer.update((Object)br, null);
                    iBooks.this.setCheckTableViewer(br);
                    iBooks.this.setCheckAlbumViewer(br);
                    String msg = "Succeed!! (MetaData of Book were registered with Concierge database.)";
                    MessageDialog.openInformation((Shell)iBooks.this.m_parent.getShell(), (String)"Book", (String)msg);
                }
            }
        };
        this.singleAddAction.setText(addActionName);
        this.singleAddAction.setToolTipText(addActionName);
        this.amazonUrlOpenAction = new Action(){

            public void run() {
                ISelection selection = iBooks.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && obj instanceof BookRegister) {
                    BookRegister br = (BookRegister)obj;
                    FileLauncher.LaunchBrowser((String)br.getURL());
                }
            }
        };
        this.amazonUrlOpenAction.setText("Open Amazon Site");
        this.openPreferenceAction = new Action(){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"jp.sourceforge.concierge.plugin.iBooks", null, null);
                dialog.open();
            }
        };
    }

    public void setFocus() {
        this.queryText.setFocus();
    }

    public void DoSearch() {
        String urlAddress = null;
        urlAddress = this.urlPullDown.getSelectionIndex() == 1 ? "http://webservices.amazon.co.jp/" : "http://webservices.amazon.com/";
        urlAddress = "http://webservices." + this.urlPullDown.getText() + "/";
        ArrayList<BookRegister> al = new ArrayList<BookRegister>();
        this.tableViewer.setInput(al);
        this.clearAlbumView();
        searchJob job = new searchJob("iBooks", this.queryText.getText(), urlAddress, al, this.m_parent.getDisplay());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    Control control;
                    System.out.println("iBooks searchJob done");
                    if (iBooks.this.tableViewer != null && (control = iBooks.this.tableViewer.getControl()) != null && !control.isDisposed()) {
                        control.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                iBooks.this.tableViewer.refresh();
                            }
                        });
                    }
                    if (iBooks.this.albumViewer != null) {
                        iBooks.this.albumViewer.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                iBooks.this.layoutAlbumView();
                            }
                        });
                    }
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }

    public ArrayList Search(String query, int page) {
        if (query == null) {
            return null;
        }
        if (query.length() == 0) {
            return null;
        }
        ArrayList<BookRegister> booklist = null;
        URL url = null;
        try {
            String urlAddress = null;
            urlAddress = this.urlPullDown.getSelectionIndex() == 1 ? "http://webservices.amazon.co.jp/" : "http://webservices.amazon.com/";
            urlAddress = "http://webservices." + this.urlPullDown.getText() + "/";
            String en = URLEncoder.encode(query, "UTF-8");
            urlAddress = String.valueOf(urlAddress) + "onca/xml?Service=AWSECommerceService&";
            urlAddress = String.valueOf(urlAddress) + "SubscriptionId=" + iBooksPlugin.getDefault().getPreferenceStore().getString("SUBSCRIPTIONID");
            urlAddress = String.valueOf(urlAddress) + "&Operation=ItemSearch&SearchIndex=Books&Keywords=" + en;
            urlAddress = String.valueOf(urlAddress) + "&ResponseGroup=Medium";
            if (page > 0) {
                urlAddress = String.valueOf(urlAddress) + "&ItemPage=" + String.valueOf(page);
            }
            System.out.println("iBooks URL:" + urlAddress);
            url = new URL(urlAddress);
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            XmlSAX xs = new XmlSAX();
            saxParser.parse(inputSource, (DefaultHandler)xs);
            booklist = xs.getList();
            is.close();
        }
        catch (Exception exception) {}
        return booklist;
    }

    private XmlSAX SearchKeyword(String query, String baseUrlAddress, IProgressMonitor monitor, int page) {
        try {
            URL url = null;
            String en = URLEncoder.encode(query, "UTF-8");
            String urlAddress = String.valueOf(baseUrlAddress) + "onca/xml?Service=AWSECommerceService&";
            urlAddress = String.valueOf(urlAddress) + "SubscriptionId=" + iBooksPlugin.getDefault().getPreferenceStore().getString("SUBSCRIPTIONID");
            urlAddress = String.valueOf(urlAddress) + "&Operation=ItemSearch&SearchIndex=Books&Keywords=" + en;
            urlAddress = String.valueOf(urlAddress) + "&ResponseGroup=Medium";
            if (page > 0) {
                urlAddress = String.valueOf(urlAddress) + "&ItemPage=" + String.valueOf(page);
            }
            System.out.println("iBooks URL:" + urlAddress);
            if (monitor != null) {
                monitor.worked(0);
            }
            url = new URL(urlAddress);
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            XmlSAX xs = new XmlSAX(monitor);
            saxParser.parse(inputSource, (DefaultHandler)xs);
            is.close();
            return xs;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XmlSAX SearchASIN(String query, String baseUrlAddress, IProgressMonitor monitor) {
        try {
            URL url = null;
            String asin = "";
            int i = 0;
            while (true) {
                if (i >= query.length()) {
                    if (asin.length() != 0) break;
                    return null;
                }
                char c = query.charAt(i);
                if ('0' <= c && c <= '9') {
                    asin = String.valueOf(asin) + c;
                } else if (c != '-') {
                    return null;
                }
                ++i;
            }
            String en = URLEncoder.encode(asin, "UTF-8");
            String urlAddress = String.valueOf(baseUrlAddress) + "onca/xml?Service=AWSECommerceService&";
            urlAddress = String.valueOf(urlAddress) + "SubscriptionId=" + iBooksPlugin.getDefault().getPreferenceStore().getString("SUBSCRIPTIONID");
            urlAddress = String.valueOf(urlAddress) + "&Operation=ItemLookup&IdType=ASIN&ItemId=" + en;
            urlAddress = String.valueOf(urlAddress) + "&ResponseGroup=Medium";
            System.out.println("iBooks URL:" + urlAddress);
            if (monitor != null) {
                monitor.worked(0);
            }
            url = new URL(urlAddress);
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            XmlSAX xs = new XmlSAX("ItemLookupResponse", monitor);
            saxParser.parse(inputSource, (DefaultHandler)xs);
            is.close();
            return xs;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (SAXException sAXException) {}
        return null;
    }

    protected ArrayList<Document> getDocumentsWithPath(String path) {
        File file = new File(path);
        Document doc = FrameworkPlugin.getDocumentByFilePath((String)file.getAbsolutePath());
        ArrayList<Document> docs = new ArrayList<Document>();
        if (doc != null) {
            docs.add(doc);
        }
        return docs;
    }

    protected void addIBooksToDataDoc(Document datadoc, ArrayList typeelems, BookRegister br) {
        String imageURL;
        int i = 0;
        while (i < typeelems.size()) {
            String value;
            Element typeelem = (Element)typeelems.get(i);
            String pluginname = TypeDomImpl.getParser((Element)typeelem);
            String itemname = TypeDomImpl.getElementName((Element)typeelem);
            ITypeParser parser = FrameworkPlugin.getParser((String)pluginname);
            if (parser != null && (value = br.get(itemname)) != null) {
                try {
                    Element elem = DataDomImpl.getElement((Document)datadoc, (String)itemname, (String)"Book");
                    if (elem != null) {
                        parser.putToElement(elem, value);
                    }
                }
                catch (Exception e) {
                    System.out.print(e.getMessage());
                }
                parser = null;
            }
            ++i;
        }
        String path = br.getPath();
        if (path == null) {
            path = "";
        }
        if (path.length() > 0) {
            try {
                File file = new File(path);
                if (file.exists()) {
                    DataDomImpl.setFilePath((Document)datadoc, (String)file.getAbsolutePath());
                }
            }
            catch (Exception exception) {}
        }
        if ((imageURL = br.getIMAGEURL()) != null && imageURL.length() > 0) {
            long id = DomImpl.getID((Document)datadoc);
            iBooksPlugin.getDefault().saveThumbnailFile(imageURL, id);
        }
    }

    public void DoAdd(BookRegister br) {
        ArrayList<BookRegister> targetList = new ArrayList<BookRegister>();
        if (br != null) {
            targetList.add(br);
        }
        if (targetList.size() > 0) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.m_parent.getShell());
            AddIBooksWithProgress addThread = new AddIBooksWithProgress(targetList);
            try {
                dialog.run(true, true, (IRunnableWithProgress)addThread);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {}
            addThread.addDB();
        }
    }

    public void DoAdd() {
        ArrayList<BookRegister> targetList = new ArrayList<BookRegister>();
        ArrayList al = (ArrayList)this.tableViewer.getInput();
        int i = 0;
        while (i < al.size()) {
            Object obj = al.get(i);
            if (obj instanceof BookRegister && ((BookRegister)obj).getChecked()) {
                targetList.add((BookRegister)obj);
            }
            ++i;
        }
        if (targetList.size() > 0) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.m_parent.getShell());
            AddIBooksWithProgress addThread = new AddIBooksWithProgress(targetList);
            try {
                dialog.run(true, true, (IRunnableWithProgress)addThread);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {}
            addThread.addDB();
        }
    }

    private class AddIBooksWithProgress
    implements IRunnableWithProgress {
        private ArrayList _targetList = null;
        private ArrayList<Request> _reqs = null;

        public AddIBooksWithProgress(ArrayList targetList) {
            this._targetList = targetList;
        }

        public void addDB() {
            if (this._reqs != null && this._reqs.size() > 0) {
                FrameworkPlugin.updateDocuments(this._reqs, (Object)iBooksPlugin.getDefault().getBundle().getSymbolicName());
                this._reqs.clear();
            }
            this._reqs = null;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask("Add MetaData of Book to Concierge database...", this._targetList.size());
                monitor.worked(0);
                this._reqs = new ArrayList();
                Document typedoc = TypeManager.getTypeDocument((String)"Book");
                ArrayList typeelems = TypeDomImpl.getAllElements((Document)typedoc);
                ArrayList<Document> newDataDocs = new ArrayList<Document>();
                int i = 0;
                while (i < this._targetList.size()) {
                    ArrayList<Document> docs;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("Cancel has been requested.");
                    }
                    BookRegister br = (BookRegister)this._targetList.get(i);
                    String value = "";
                    value = br.getTitle();
                    monitor.subTask("Create MetaData of Book: " + value);
                    monitor.worked(1);
                    String path = br.getPath();
                    if (path != null && path.length() > 0 && (docs = iBooks.this.getDocumentsWithPath(path)).size() > 0) {
                        this._reqs.add(new Request(2, docs, "data"));
                    }
                    Document datadoc = DataDomImpl.createDocument((Document)typedoc);
                    DataDomImpl.setDefaultType((Document)datadoc, (String)"Book");
                    iBooks.this.addIBooksToDataDoc(datadoc, typeelems, br);
                    newDataDocs.add(datadoc);
                    br.setRegist(true);
                    br.setChecked(false);
                    ++i;
                }
                this._reqs.add(new Request(1, newDataDocs, "data"));
                monitor.subTask("Add MetaData of Book to Concierge database...");
                monitor.worked(0);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException("Cancel has been requested.");
            }
            monitor.worked(0);
            monitor.done();
        }
    }

    class BookSorter
    extends ViewerSorter {
        private int sortKey_ = 0;
        private boolean sortUp_ = true;

        BookSorter() {
        }

        public boolean getSortUp() {
            return this.sortUp_;
        }

        public void setSortUp(boolean sortUp) {
            this.sortUp_ = sortUp;
        }

        public void setColumnIndex(int sortKey) {
            this.sortKey_ = sortKey;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s1 = null;
            String s2 = null;
            BookRegister br1 = (BookRegister)e1;
            BookRegister br2 = (BookRegister)e2;
            if (this.sortUp_) {
                s1 = br1.get(iBooks.this.tableHead[this.sortKey_]);
                s2 = br2.get(iBooks.this.tableHead[this.sortKey_]);
            } else {
                s2 = br1.get(iBooks.this.tableHead[this.sortKey_]);
                s1 = br2.get(iBooks.this.tableHead[this.sortKey_]);
            }
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        }
    }

    private class DropTableAdapter
    extends DropTargetAdapter {
        private DropTableAdapter() {
        }

        public void drop(DropTargetEvent e) {
            System.out.println("iBooks drop");
            String[] paths = (String[])e.data;
            TableItem item = (TableItem)e.item;
            if (item != null) {
                BookRegister br = (BookRegister)item.getData();
                br.setPath(paths[0]);
                iBooks.this.tableViewer.update((Object)br, new String[]{"Path"});
            }
        }

        public void dragOver(DropTargetEvent e) {
            e.feedback |= 9;
            iBooks.this.tableViewer.getTable().update();
        }

        public void dragEnter(DropTargetEvent e) {
            System.out.println("iBooks dragEnter");
        }

        public void dragLeave(DropTargetEvent e) {
            System.out.println("iBooks dropLeave");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchUIJob
    extends UIJob {
        private String query;
        private String baseUrlAddress;

        public SearchUIJob(Display jobDisplay, String name, String query, String baseUrlAddress) {
            super(jobDisplay, name);
            this.query = null;
            this.baseUrlAddress = null;
            this.query = query;
            this.baseUrlAddress = baseUrlAddress;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            int resultTotalPages = 0;
            monitor.beginTask("Search \"" + this.query + "\"", 100);
            monitor.worked(1);
            XmlSAX xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, 0);
            if (xs != null) {
                resultTotalPages = xs.getTotalPages();
                ArrayList<BookRegister> list = xs.getList();
                if (list != null && list.size() > 0) {
                    this.refreshTableViewer(list);
                    this.refreshAlbumViewer(list);
                    monitor.beginTask("Search \"" + this.query + "\"", resultTotalPages);
                    monitor.worked(1);
                    int i = 2;
                    while (i <= resultTotalPages) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, i);
                        if (xs != null && (list = xs.getList()) != null) {
                            this.refreshTableViewer(list);
                            this.refreshAlbumViewer(list);
                            monitor.worked(1);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                xs = iBooks.this.SearchASIN(this.query, this.baseUrlAddress, monitor);
                if (xs != null) {
                    resultTotalPages = xs.getTotalPages();
                    this.refreshTableViewer(xs.getList());
                    this.refreshAlbumViewer(xs.getList());
                }
            }
            monitor.worked(resultTotalPages);
            monitor.done();
            return Status.OK_STATUS;
        }

        private void refreshAlbumViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            int i = 0;
            while (i < newList.size()) {
                BookRegister br = newList.get(i);
                Image image = iBooks.this.createCatchThumbnail(br.getIMAGEURL());
                iBooks.this.addThumbnailControl(br, image);
                iBooks.this.layoutAlbumView();
                ++i;
            }
        }

        private void refreshTableViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            ArrayList allList = (ArrayList)iBooks.this.tableViewer.getInput();
            if (allList != null) {
                allList.addAll(newList);
            }
            iBooks.this.tableViewer.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchWithProgress
    implements IRunnableWithProgress {
        private String query = null;
        private String baseUrlAddress = null;
        private ArrayList<BookRegister> allList = null;
        private Display display = null;
        private List<BookRegister> fifo = null;

        public SearchWithProgress(String query, String baseUrlAddress, ArrayList<BookRegister> allList, Display display) {
            this.query = query;
            this.baseUrlAddress = baseUrlAddress;
            this.allList = allList;
            this.display = display;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int resultTotalPages = 0;
            monitor.beginTask("Book Search \"" + this.query + "\"", 100);
            monitor.worked(1);
            XmlSAX xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, 0);
            if (xs != null) {
                resultTotalPages = xs.getTotalPages();
                ArrayList<BookRegister> list = xs.getList();
                if (list != null && list.size() > 0) {
                    this.refreshTableViewer(list);
                    this.refreshAlbumViewer(list);
                    monitor.beginTask("Book Search \"" + this.query + "\"", resultTotalPages);
                    monitor.worked(1);
                    int i = 2;
                    while (i <= resultTotalPages) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException("Cancel has been requested.");
                        }
                        xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, i);
                        if (xs != null && (list = xs.getList()) != null) {
                            this.refreshTableViewer(list);
                            this.refreshAlbumViewer(list);
                            monitor.worked(1);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                xs = iBooks.this.SearchASIN(this.query, this.baseUrlAddress, monitor);
                if (xs != null) {
                    resultTotalPages = xs.getTotalPages();
                    this.refreshTableViewer(xs.getList());
                    this.refreshAlbumViewer(xs.getList());
                }
            }
            monitor.worked(resultTotalPages);
            monitor.done();
        }

        private void refreshAlbumViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            if (this.fifo == null) {
                this.fifo = Collections.synchronizedList(new ArrayList());
            }
            this.fifo.addAll(newList);
            this.display.asyncExec(new Runnable(){

                public void run() {
                    while (SearchWithProgress.this.fifo.size() != 0) {
                        BookRegister br = (BookRegister)SearchWithProgress.this.fifo.get(0);
                        SearchWithProgress.this.fifo.remove(0);
                        Image image = iBooks.this.createThumbnailWithURL(br.getIMAGEURL());
                        iBooks.this.addThumbnailControl(br, image);
                        iBooks.this.layoutAlbumView();
                    }
                }
            });
        }

        private void refreshTableViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            if (this.allList != null) {
                this.allList.addAll(newList);
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    iBooks.this.tableViewer.refresh();
                }
            });
        }
    }

    public class TableCellModifier
    implements ICellModifier {
        private TableViewer viewer_;

        public TableCellModifier(TableViewer viewer) {
            this.viewer_ = viewer;
        }

        public boolean canModify(Object element, String property) {
            return iBooks.this.selectObj != null && iBooks.this.selectObj == element;
        }

        public Object getValue(Object element, String property) {
            BookRegister br = (BookRegister)element;
            String result = null;
            result = br.get(property);
            return result;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            BookRegister br = (BookRegister)tableItem.getData();
            br.put(property, (String)value);
            this.viewer_.update((Object)br, new String[]{property});
        }
    }

    class TableMouseAdapter
    extends MouseAdapter {
        private TableViewer viewer_;

        public TableMouseAdapter(TableViewer viewer) {
            this.viewer_ = viewer;
        }

        public void mouseDown(MouseEvent e) {
            System.out.println("iBooks mouseDown");
            int x = e.x;
            int y = e.y;
            Point clickPoint = new Point(x, y);
            Table table = this.viewer_.getTable();
            int startRow = table.getTopIndex();
            int endRow = table.getItemCount();
            int columnCount = table.getColumnCount();
            TableItem targetItem = null;
            int column = 0;
            int i = startRow;
            while (i < endRow) {
                TableItem item = table.getItem(i);
                int j = 0;
                while (j <= columnCount) {
                    Rectangle rect = item.getBounds(j);
                    if (rect.contains(clickPoint)) {
                        column = j;
                        targetItem = item;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (targetItem != null) {
                this.viewer_.editElement(targetItem.getData(), column);
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            BookRegister br = (BookRegister)element;
            if (index <= iBooks.this.registIndex) {
                return null;
            }
            return br.get(iBooks.this.tableHead[index]);
        }

        public Image getColumnImage(Object element, int index) {
            BookRegister br;
            if (index == iBooks.this.registIndex && (br = (BookRegister)element).getRegist()) {
                return this.getImage(element);
            }
            return null;
        }

        public Image getImage(Object element) {
            return iBooks.this.unregistImage;
        }

        public Color getForeground(Object element, int index) {
            return null;
        }

        public Color getBackground(Object element, int index) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XmlSAX
    extends DefaultHandler {
        private String elementpath = null;
        private int totalPages_ = 0;
        private int totalResults_ = 0;
        private ArrayList<BookRegister> list = null;
        private BookRegister br = null;
        private String rootTag = null;
        private IProgressMonitor monitor = null;

        public XmlSAX() {
        }

        public XmlSAX(IProgressMonitor monitor) {
            this.rootTag = "ItemSearchResponse";
            this.monitor = monitor;
        }

        public XmlSAX(String rootTag, IProgressMonitor monitor) {
            this.rootTag = rootTag;
            this.monitor = monitor;
        }

        public int getTotalPages() {
            return this.totalPages_;
        }

        public int getTotalResults() {
            return this.totalResults_;
        }

        @Override
        public void startDocument() {
            System.out.println("iBooks ===>startDocument");
            this.list = new ArrayList();
        }

        public ArrayList<BookRegister> getList() {
            return this.list;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
            if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item")) {
                this.br = new BookRegister();
                if (this.monitor != null) {
                    this.monitor.worked(0);
                }
            }
            if (this.monitor != null) {
                this.monitor.worked(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/TotalResults")) {
                String value = new String(ch, start, length);
                this.totalResults_ = Integer.valueOf(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/TotalPages")) {
                String value = new String(ch, start, length);
                this.totalPages_ = Integer.valueOf(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/MediumImage/URL")) {
                String value = this.br.getIMAGEURL();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setIMAGEURL(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ASIN")) {
                String value = this.br.getISBN();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setISBN(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/DetailPageURL")) {
                String value = this.br.getURL();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setURL(value);
            } else if (this.elementpath.startsWith(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes")) {
                if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Title")) {
                    String value = this.br.getTitle();
                    value = String.valueOf(value) + new String(ch, start, length);
                    this.br.setTitle(value);
                    this.monitor.subTask(value);
                } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Author")) {
                    String value = this.br.getAuthor();
                    value = value.length() == 0 ? new String(ch, start, length) : String.valueOf(value) + ", " + new String(ch, start, length);
                    this.br.setAuthor(value);
                } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Publisher")) {
                    String value = this.br.getPublisher();
                    value = String.valueOf(value) + new String(ch, start, length);
                    this.br.setPublisher(value);
                } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/PublicationDate")) {
                    String value = this.br.getYear();
                    value = String.valueOf(value) + new String(ch, start, length);
                    this.br.setYear(value);
                } else if (!this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/ISBN")) {
                    if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Binding")) {
                        String value = this.br.getCategory();
                        value = String.valueOf(value) + new String(ch, start, length);
                        this.br.setCategory(value);
                    } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/ListPrice/Amount")) {
                        String value = this.br.getPrice();
                        value = String.valueOf(value) + new String(ch, start, length);
                        this.br.setPrice(value);
                    }
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item")) {
                if (this.br != null && !this.br.isEmpty()) {
                    boolean hasBook = this.hasBookDataIntoConciergeDatabase(this.br.getISBN());
                    this.br.setRegist(hasBook);
                    this.list.add(this.br);
                }
                this.br = null;
            }
            String[] values = this.elementpath.split("/");
            this.elementpath = "";
            int i = 0;
            while (i < values.length - 1) {
                this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
                ++i;
            }
        }

        @Override
        public void endDocument() {
            System.out.println("iBooks ===>endDocument");
        }

        protected boolean hasBookDataIntoConciergeDatabase(String value) {
            String xpath = "/mdata/data[@name='Book']/ISBN[txt:body='" + value + "']";
            Request req = new Request(4, (Object)xpath, "data");
            ArrayList list = FrameworkPlugin.getDocumentsOfQuery((Request)req);
            return list != null && list.size() > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class searchJob
    extends Job {
        private String query;
        private String baseUrlAddress;
        private ArrayList<BookRegister> allList;
        private Display display;
        private List<BookRegister> fifo;

        public searchJob(String name, String query, String baseUrlAddress, ArrayList<BookRegister> allList, Display display) {
            super(name);
            this.query = null;
            this.baseUrlAddress = null;
            this.allList = null;
            this.display = null;
            this.fifo = null;
            this.query = query;
            this.baseUrlAddress = baseUrlAddress;
            this.allList = allList;
            this.display = display;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int resultTotalPages = 0;
            monitor.beginTask("Search \"" + this.query + "\"", 100);
            monitor.worked(1);
            XmlSAX xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, 0);
            if (xs != null) {
                resultTotalPages = xs.getTotalPages();
                ArrayList<BookRegister> list = xs.getList();
                if (list != null && list.size() > 0) {
                    this.refreshTableViewer(list);
                    this.refreshAlbumViewer(list);
                    monitor.beginTask("Search \"" + this.query + "\"", resultTotalPages);
                    monitor.worked(1);
                    int i = 2;
                    while (i <= resultTotalPages) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        xs = iBooks.this.SearchKeyword(this.query, this.baseUrlAddress, monitor, i);
                        if (xs != null && (list = xs.getList()) != null) {
                            this.refreshTableViewer(list);
                            this.refreshAlbumViewer(list);
                            monitor.worked(1);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                xs = iBooks.this.SearchASIN(this.query, this.baseUrlAddress, monitor);
                if (xs != null) {
                    resultTotalPages = xs.getTotalPages();
                    this.refreshTableViewer(xs.getList());
                    this.refreshAlbumViewer(xs.getList());
                }
            }
            monitor.worked(resultTotalPages);
            monitor.done();
            return Status.OK_STATUS;
        }

        private void refreshAlbumViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            if (this.fifo == null) {
                this.fifo = Collections.synchronizedList(new ArrayList());
            }
            this.fifo.addAll(newList);
            this.display.syncExec(new Runnable(){

                public void run() {
                    while (searchJob.this.fifo.size() != 0) {
                        BookRegister br = (BookRegister)searchJob.this.fifo.get(0);
                        searchJob.this.fifo.remove(0);
                        Image image = iBooks.this.createCatchThumbnail(br.getIMAGEURL());
                        iBooks.this.addThumbnailControl(br, image);
                        iBooks.this.layoutAlbumView();
                    }
                }
            });
        }

        private void refreshTableViewer(ArrayList<BookRegister> newList) {
            if (newList == null) {
                return;
            }
            if (this.allList != null) {
                this.allList.addAll(newList);
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    iBooks.this.tableViewer.refresh();
                }
            });
        }
    }
}

