/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.sourceforge.concierge.framework.FrameworkPlugin;

public class CalendarUtil {
    private static Locale locale = new Locale(FrameworkPlugin.getString("CalendarUtil.16"));
    private static int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    private static boolean isleapyear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static int getNumberOfDays(int year, int month) {
        if (month == 2) {
            return CalendarUtil.isleapyear(year) ? days[1] + 1 : days[1];
        }
        return days[month - 1];
    }

    public static int getDayOfWeek(int year, int month, int date) {
        Calendar cd = Calendar.getInstance(locale);
        cd.set(year, month - 1, date);
        return cd.get(7);
    }

    public static String getWeekString(int index) {
        Calendar cd = Calendar.getInstance(locale);
        cd.set(2000, 0, 2 + index);
        return String.format(locale, FrameworkPlugin.getString("CalendarUtil.17"), cd);
    }

    public static String getDateString(Date date) {
        Calendar cd = Calendar.getInstance(locale);
        if (date != null) {
            cd.setTime(date);
        }
        return String.format(locale, FrameworkPlugin.getString("CalendarUtil.19"), cd);
    }

    public static String getDateString(int year, int month) {
        Calendar c = Calendar.getInstance(locale);
        c.set(year, month - 1, 1);
        return String.format(locale, FrameworkPlugin.getString("CalendarUtil.15"), c);
    }

    public static String getTodaysString() {
        return CalendarUtil.getDateString(null);
    }

    public static Locale getLocale() {
        return locale;
    }
}

