/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import jp.sourceforge.concierge.widget.SmartText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class AdditionalInfoDialogArea
implements IConciergeDialogArea {
    private SmartText keywordtext = null;
    private Text commenttext = null;
    private Document document;
    private IEditorEventListener elistener;
    private Group group1 = null;

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void setCommonData(Document doc) {
        String keywords;
        String file = DataDomImpl.getFilePath(doc);
        if (this.isEmpty(file)) {
            return;
        }
        String comment = DataDomImpl.getComment(doc);
        if (this.isEmpty(comment) && !this.isEmpty(comment = DataExtractorPlugin.getFileProperty((String)file, (String)"comment"))) {
            this.commenttext.setText(comment);
        }
        if (this.isEmpty(keywords = DataDomImpl.getKeywords(doc)) && !this.isEmpty(keywords = DataExtractorPlugin.getFileProperty((String)file, (String)"keywords"))) {
            this.keywordtext.setText(keywords);
        }
    }

    private void setLabelAndText(Composite parent, String lt, boolean tmulti) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int mlt = tmulti ? 2 : 4;
        this.commenttext = new Text(parent, mlt | 0x800);
        if (tmulti) {
            this.commenttext.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            this.commenttext.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        }
        this.commenttext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AdditionalInfoDialogArea.this.elistener != null) {
                    AdditionalInfoDialogArea.this.elistener.run(new EditorEvent(1, e.widget, AdditionalInfoDialogArea.this.document));
                }
            }
        });
    }

    private void setLabelAndSmartText(Composite parent, String lt, boolean tmulti) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int mlt = tmulti ? 2 : 4;
        this.keywordtext = new SmartText(parent, mlt | 0x800);
        if (tmulti) {
            this.keywordtext.setLayoutData(new GridData(4, 4, true, true));
        } else {
            this.keywordtext.setLayoutData(new GridData(4, 0x1000000, true, true));
        }
        this.keywordtext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AdditionalInfoDialogArea.this.elistener != null) {
                    AdditionalInfoDialogArea.this.elistener.run(new EditorEvent(1, e.widget, AdditionalInfoDialogArea.this.document));
                }
            }
        });
    }

    public Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group1 = new Group(parent, 16);
        this.group1.setLayout((Layout)new GridLayout(2, false));
        this.group1.setLayoutData((Object)new GridData(4, 4, true, true));
        this.group1.setText("Additional Information");
        this.setLabelAndSmartText((Composite)this.group1, "keywords", false);
        this.setLabelAndText((Composite)this.group1, "comment", true);
        this.refresh();
        this.setCommonData(this.document);
        return parent;
    }

    public void refresh() {
        if (this.document == null) {
            return;
        }
        this.keywordtext.setText(DataDomImpl.getKeywords(this.document));
        this.commenttext.setText(DataDomImpl.getComment(this.document));
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public Document saveDocument() {
        if (this.document == null) {
            return null;
        }
        DataDomImpl.setComment(this.document, this.commenttext.getText());
        DataDomImpl.setKeywords(this.document, this.keywordtext.getText());
        this.keywordtext.save();
        return this.document;
    }

    public String getType() {
        return "Unclassified";
    }

    public void setEnabled(boolean enabled) {
        Color lc = null;
        lc = enabled ? this.group1.getDisplay().getSystemColor(2) : this.group1.getDisplay().getSystemColor(15);
        Control[] ctrls = this.group1.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            if (ctrls[i] instanceof Label) {
                ctrls[i].setForeground(lc);
            }
            ctrls[i].setEnabled(enabled);
            ++i;
        }
        this.group1.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.group1.isEnabled();
    }

    public void fillout() {
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.group1.isDisposed();
    }
}

