/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer.preferences;

import java.util.ArrayList;
import java.util.Collections;
import jp.sourceforge.concierge.plugin.registerer.preferences.DistCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirEntry
implements Comparable<DirEntry> {
    public String dirname;
    public boolean subdir;
    public boolean monitor;
    public ArrayList<DistCondition> condition;

    DirEntry(String name, boolean subdir, boolean monitor) {
        this.dirname = name;
        this.subdir = subdir;
        this.monitor = monitor;
        this.condition = new ArrayList();
    }

    @Override
    public int compareTo(DirEntry de) {
        return this.dirname.compareTo(de.dirname);
    }

    public void setCondition(String regex, String type) {
        int i = 0;
        while (i < this.condition.size()) {
            if (this.condition.get((int)i).regex == regex) {
                this.condition.set(i, new DistCondition(regex, type, this));
                return;
            }
            ++i;
        }
        this.condition.add(new DistCondition(regex, type, this));
    }

    public ArrayList<DistCondition> getCondition() {
        return this.condition;
    }

    public void removeCondition(String regex) {
        int i = 0;
        while (i < this.condition.size()) {
            if (this.condition.get((int)i).regex == regex) {
                this.condition.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeCondition(DistCondition dc) {
        this.condition.remove(dc);
    }

    private static boolean contains(DirEntry dent, ArrayList<DirEntry> delist) {
        int i = 0;
        while (i < delist.size()) {
            DirEntry de = delist.get(i);
            if (dent.dirname.startsWith(de.dirname) && de.subdir) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ArrayList<DirEntry> getValidatedList(ArrayList<DirEntry> dirs) {
        Collections.sort(dirs);
        ArrayList<DirEntry> ndes = new ArrayList<DirEntry>();
        int i = 0;
        while (i < dirs.size()) {
            DirEntry de = dirs.get(i);
            if (!DirEntry.contains(de, ndes)) {
                ndes.add(de);
            }
            ++i;
        }
        return ndes;
    }
}

