/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.exportreference.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.MappingData;
import jp.sourceforge.concierge.plugin.MappingDataList;
import jp.sourceforge.concierge.plugin.MappingField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;

public class MappingTablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Shell shell = null;
    protected TableViewer typeTableView = null;
    protected ComboViewer datasetListCombo = null;
    protected Button datasetEditButton = null;
    protected Label dataNameLabel = null;
    protected Label dstTypeNameLabel = null;
    protected TableViewer mappingTableViewer = null;
    protected ComboBoxCellEditor comboBoxCellEditor = null;
    protected ImageRegistry imageReg = null;

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.imageReg != null) {
            this.imageReg.dispose();
            this.imageReg = null;
        }
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingTablePreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.shell = parent.getShell();
        Control control = this.createSettingControl(parent);
        this.initialize();
        return control;
    }

    protected Control createSettingControl(Composite parent) {
        return null;
    }

    protected void createTypeTableViewer(Composite parent) {
        this.typeTableView = new TableViewer(parent, 68356);
        this.typeTableView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.typeTableView.setLabelProvider((IBaseLabelProvider)new TypeTableViewLabelProvider());
        new TableColumn(this.typeTableView.getTable(), 16384, 0);
        this.typeTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
    }

    protected void createDatasetControls(Composite parent) {
        Composite datasetComposite = new Composite(parent, 0);
        datasetComposite.setLayout((Layout)new GridLayout(3, false));
        datasetComposite.setLayoutData((Object)new GridData(768));
        Label datasetLabel = new Label(datasetComposite, 0);
        datasetLabel.setText("Data Set");
        this.datasetListCombo = new ComboViewer(datasetComposite, 8);
        this.datasetListCombo.getControl().setLayoutData((Object)new GridData(768));
        this.datasetListCombo.setLabelProvider((IBaseLabelProvider)new DatasetComboViewLabelProvider());
        this.datasetListCombo.setContentProvider((IContentProvider)new ViewContentProvider());
        this.datasetEditButton = new Button(datasetComposite, 8);
        this.datasetEditButton.setText("...");
    }

    protected void createDataNameControls(Composite parent) {
        Label nameLabel = new Label(parent, 131072);
        nameLabel.setText("Name:");
        this.dataNameLabel = new Label(parent, 0);
        this.dataNameLabel.setLayoutData((Object)new GridData(768));
        this.dataNameLabel.setText("     ");
    }

    protected void createDstTypeNameControls(Composite parent, String dstLabelName) {
        Label dstTypeLabel = new Label(parent, 131072);
        dstTypeLabel.setText(dstLabelName);
        this.dstTypeNameLabel = new Label(parent, 0);
        this.dstTypeNameLabel.setLayoutData((Object)new GridData(768));
        this.dstTypeNameLabel.setText("     ");
    }

    protected void createMappingTableViewer(Composite parent, String bColumnName, String aColumnName) {
        this.mappingTableViewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        this.mappingTableViewer.getTable().setLayoutData((Object)gd);
        this.mappingTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.mappingTableViewer.getTable().setLinesVisible(true);
        this.mappingTableViewer.getTable().setHeaderVisible(true);
        TableColumn tcB = new TableColumn(this.mappingTableViewer.getTable(), 16384, 0);
        tcB.setText(bColumnName);
        TableColumn tcA = new TableColumn(this.mappingTableViewer.getTable(), 16384, 1);
        tcA.setText(aColumnName);
        tcA.setResizable(true);
        this.mappingTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 2) {
                    col[0].setWidth(r.width / 2);
                    col[1].setWidth(r.width / 2);
                }
            }
        });
        String[] dummyItems = new String[]{"A", "B", "C"};
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)this.mappingTableViewer.getTable(), dummyItems, 8);
        String[] columnProperties = new String[]{"B", "A"};
        this.mappingTableViewer.setColumnProperties(columnProperties);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.mappingTableViewer.getTable()), this.comboBoxCellEditor};
        this.mappingTableViewer.setCellEditors(cellEditors);
        this.mappingTableViewer.setCellModifier((ICellModifier)new TableCellModifier(this.mappingTableViewer));
    }

    protected void setMappingDataToControls(MappingData data) {
        if (data != null) {
            this.dataNameLabel.setText(data.getDataName());
            this.dstTypeNameLabel.setText(data.getDstTypeName());
            this.mappingTableViewer.setInput(data.getFields());
        } else {
            this.dataNameLabel.setText("");
            this.dstTypeNameLabel.setText("");
            this.mappingTableViewer.setInput(null);
        }
    }

    protected void initialize() {
    }

    protected void DoSave() {
    }

    class DatasetComboViewLabelProvider
    extends LabelProvider {
        DatasetComboViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MappingData) {
                MappingData data = (MappingData)element;
                String value = String.valueOf(data.getDataName()) + " (" + data.getDstTypeName() + ")";
                return value;
            }
            return element.toString();
        }
    }

    public class TableCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public TableCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (element != null) {
                if (property.equals("B")) {
                    return false;
                }
                if (property.equals("A")) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (property.equals("A")) {
                if (element instanceof MappingField) {
                    MappingField field = (MappingField)element;
                    if (field.getSrc().length() == 0) {
                        return new Integer(0);
                    }
                    String[] items = MappingTablePreferencePage.this.comboBoxCellEditor.getItems();
                    int i = 1;
                    while (i < items.length) {
                        if (items[i].equals(field.getSrc())) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                }
                return new Integer(-1);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals("A")) {
                int index = (Integer)value;
                if (element instanceof TableItem) {
                    TableItem item = (TableItem)element;
                    element = item.getData();
                }
                if (element instanceof MappingField) {
                    MappingField field = (MappingField)element;
                    String[] items = MappingTablePreferencePage.this.comboBoxCellEditor.getItems();
                    if (index == 0) {
                        field.setSrc("");
                        this.viewer.update(element, new String[]{property});
                    } else if (1 <= index && index < items.length) {
                        field.setSrc(items[index]);
                        this.viewer.update(element, new String[]{property});
                    }
                }
            }
        }
    }

    class TypeTableViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TypeTableViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Document) {
                Document doc = (Document)obj;
                return TypeDomImpl.getTypeName((Document)doc);
            }
            if (obj instanceof MappingDataList) {
                MappingDataList mappingDataList = (MappingDataList)obj;
                return mappingDataList.getSrcTypeName();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof MappingDataList) {
                String typename;
                Image newImage;
                MappingDataList mappingDataList = (MappingDataList)obj;
                if (MappingTablePreferencePage.this.imageReg == null) {
                    MappingTablePreferencePage.this.imageReg = new ImageRegistry();
                }
                if ((newImage = MappingTablePreferencePage.this.imageReg.get(typename = mappingDataList.getSrcTypeName())) == null && (newImage = mappingDataList.getSrcImage(MappingTablePreferencePage.this.shell.getDisplay())) != null) {
                    MappingTablePreferencePage.this.imageReg.put(typename, newImage);
                }
                return newImage;
            }
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }
}

