#import "OGRegularExpressionAdditions.h"
#import "CMBlock.h"

@implementation OGRegularExpression (CMAdditions)

- (void)matchInString:(NSString *)aString do:(CMBlock *)aBlock
{
  OGRegularExpressionMatch  *match;
  OGRegularExpressionCapture  *capture;
  NSEnumerator *e;
  unsigned i;

  e = [self matchEnumeratorInString:aString];  
  while ((match = [e nextObject]) != nil) {
    capture = [match captureHistory];
    for (i = 0; i < [capture numberOfChildren]; i++)
      [aBlock value:[[capture childAtIndex:i] string]];
  }
}

- (NSString *)replaceFirstMatchInString:(NSString *)aString
                                     do:(CMBlock *)aBlock
{
  return [self replaceFirstMatchInString:aString
               delegate:self 
               replaceSelector:@selector(_regularExpressionReplace:contextInfo:) 
               contextInfo:aBlock];
}

- (NSAttributedString *)replaceFirstMatchInAttributedString:(NSAttributedString *)aString
                                                         do:(CMBlock *)aBlock
{
  return [self replaceFirstMatchInAttributedString:aString
               delegate:self 
               replaceSelector:@selector(_regularExpressionReplace:contextInfo:) 
               contextInfo:aBlock];
}

- (NSString *)replaceAllMatchesInString:(NSString *)aString
                                     do:(CMBlock *)aBlock
{
  return [self replaceAllMatchesInString:aString
               delegate:self 
               replaceSelector:@selector(_regularExpressionReplace:contextInfo:) 
               contextInfo:aBlock];
}

- (NSAttributedString *)replaceAllMatchesInAttributedString:(NSAttributedString *)aString
                                                         do:(CMBlock *)aBlock
{
  return [self replaceAllMatchesInAttributedString:aString
               delegate:self 
               replaceSelector:@selector(_regularExpressionReplace:contextInfo:) 
               contextInfo:aBlock];
}

- (NSString *)_regularExpressionReplace:(OGRegularExpressionMatch*)aMatch
                            contextInfo:(id)contextInfo
{
  return [contextInfo value:aMatch];
}

@end
