#import <Cocoa/Cocoa.h>
#import <OgreKit/OgreKit.h>

@class CMBlock;

@interface OGRegularExpression (CMAdditions)

// OGRegularExpressionMatchubNŌJԂ
- (void)matchInString:(NSString *)aString do:(CMBlock *)aBlock;

// ex) convert fahrenheit from celsius
// |regexp target replaced celcius fahrenheit|
// regexp = /([+-]?\d+(?:\.\d+)?)C\b/
// target = "36.5C, 3.8C, -195.8C"
// replaced = regexp replaceAllMatchesInString:target
//                                          do:[|match|
//   celcius = (match substringAtIndex:1) doubleValue
//   fahrenheit = (celcius * 9.0 / 5.0) + 32.0
//   return (NSString stringWithFormat:"%.1fF" objects:@(fahrenheit))]
//
// result: 97.7F, 38.8F, -320.4F

- (NSString *)replaceFirstMatchInString:(NSString *)aString
                                     do:(CMBlock *)aBlock;
- (NSAttributedString *)replaceFirstMatchInAttributedString:(NSAttributedString *)aString
                                                         do:(CMBlock *)aBlock;
- (NSString *)replaceAllMatchesInString:(NSString *)aString
                                     do:(CMBlock *)aBlock;
- (NSAttributedString *)replaceAllMatchesInAttributedString:(NSAttributedString *)aString
                                                         do:(CMBlock *)aBlock;
- (NSString *)_regularExpressionReplace:(OGRegularExpressionMatch*)aMatch
                            contextInfo:(id)contextInfo;    
@end
